#version 130

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

out vec4 color;
out vec2 TexCoords;

void main()
{
    vec3 pos = (gl_ModelViewMatrix * gl_Vertex).xyz;
    pos = (gbufferModelViewInverse * vec4(pos,1)).xyz;

    gl_Position = gl_ProjectionMatrix * gbufferModelView * vec4(pos,1);

    color = vec4(gl_Color.rgb, gl_Color.a);
    TexCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
}
