#version 130

in vec4 at_tangent;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

out vec2 TexCoords;
out vec3 viewSpaceGeoNormal;
out vec3 Normal;
out vec4 Color;
out vec2 LightmapCoords;
out vec3 tangent;

void main() {
	tangent = gl_NormalMatrix * at_tangent.xyz;

    gl_Position = ftransform();
	TexCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	
    LightmapCoords = mat2(gl_TextureMatrix[1]) * gl_MultiTexCoord1.st;
    LightmapCoords = (LightmapCoords * 33.05f / 32.0f) - (1.05f / 32.0f);
	
    viewSpaceGeoNormal = gl_NormalMatrix * gl_Normal;
	Normal = gl_Normal;
    Color = gl_Color;
}
