#version 130

#include "/settings.glsl"

varying vec2 TexCoords;
varying vec2 LightmapCoords;
varying vec3 Normal;
varying vec4 Color;

uniform vec3 skyColor;
uniform sampler2D texture;
uniform float near, far;
uniform float rainStrength;

void main()
{
	vec4 albedo = texture2D(texture, TexCoords) * Color;
	albedo.a *= 0.6;
	
	float fog;
    fog = clamp((gl_FogFragCoord - far) * (near * 0.1), 0.0f, 1.0f);
	if(gl_Fog.color.rgb != vec3(0.0f))
	{
		albedo.a = mix(albedo.a, 0, fog);
	}
	
	#if GREY_WEATHER == 1
	albedo.a = 0.0;
	#endif

	gl_FragData[0] = albedo;
}
