#version 130

#include "/settings.glsl"

in vec2 TexCoords;
uniform sampler2D colortex0; // 16 bit
uniform sampler2D colortex6; // LUT Texture 8 bit (4096x4096)

void main() {
	vec4 color = texture2D(colortex0, TexCoords);

	#if LUT == 1
	float x = (mod((color.b * 255.0), 16) * 256.0) + (color.r * 255.0);
    float y = (floor((color.b * 255.0) / 16.0) * 256.0) + (color.g * 255.0);
    vec2 uvLUT = vec2(x, y);
    color.rgb = texture2D(colortex6, uvLUT / 4096.0).rgb;
	#endif
	
    gl_FragData[0] = color;
}
