/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.command.CommandUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

class EntityCommand {
    EntityCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"entity").then(EntityListCommand.register());
    }

    private static class EntityListCommand {
        private static final SimpleCommandExceptionType INVALID_FILTER = new SimpleCommandExceptionType((Message)CommandUtils.makeTranslatableWithFallback("commands.neoforge.entity.list.invalid"));
        private static final DynamicCommandExceptionType INVALID_DIMENSION = new DynamicCommandExceptionType(dim -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.entity.list.invalidworld", dim));
        private static final SimpleCommandExceptionType NO_ENTITIES = new SimpleCommandExceptionType((Message)CommandUtils.makeTranslatableWithFallback("commands.neoforge.entity.list.none"));

        private EntityListCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"filter", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(BuiltInRegistries.ENTITY_TYPE.keySet().stream().map(ResourceLocation::toString).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder)).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> EntityListCommand.execute((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"filter"), (ResourceKey<Level>)DimensionArgument.getDimension((CommandContext)ctx, (String)"dim").dimension())))).executes(ctx -> EntityListCommand.execute((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"filter"), (ResourceKey<Level>)((CommandSourceStack)ctx.getSource()).getLevel().dimension())))).executes(ctx -> EntityListCommand.execute((CommandSourceStack)ctx.getSource(), "*", (ResourceKey<Level>)((CommandSourceStack)ctx.getSource()).getLevel().dimension()));
        }

        private static int execute(CommandSourceStack sender, String filter, ResourceKey<Level> dim) throws CommandSyntaxException {
            String cleanFilter = filter.replace("?", ".?").replace("*", ".*?");
            Set names = BuiltInRegistries.ENTITY_TYPE.keySet().stream().filter(n -> n.toString().matches(cleanFilter)).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw INVALID_FILTER.create();
            }
            ServerLevel level = sender.getServer().getLevel(dim);
            if (level == null) {
                throw INVALID_DIMENSION.create(dim);
            }
            HashMap list = Maps.newHashMap();
            level.getEntities().getAll().forEach(e -> {
                MutablePair info = list.computeIfAbsent(BuiltInRegistries.ENTITY_TYPE.getKey((Object)e.getType()), k -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                ChunkPos chunk = new ChunkPos(e.blockPosition());
                MutablePair mutablePair = info;
                Integer n = (Integer)mutablePair.left;
                mutablePair.left = (Integer)mutablePair.left + 1;
                ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
            });
            if (names.size() == 1) {
                ResourceLocation name = (ResourceLocation)names.iterator().next();
                Pair info = (Pair)list.get(name);
                if (info == null) {
                    throw NO_ENTITIES.create();
                }
                sender.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.entity.list.single.header", name.toString(), info.getLeft()), false);
                ArrayList toSort = new ArrayList();
                toSort.addAll(((Map)info.getRight()).entrySet());
                toSort.sort((a, b) -> {
                    if (Objects.equals(a.getValue(), b.getValue())) {
                        return ((ChunkPos)a.getKey()).toString().compareTo(((ChunkPos)b.getKey()).toString());
                    }
                    return (Integer)b.getValue() - (Integer)a.getValue();
                });
                long limit = 10L;
                for (Map.Entry entry : toSort) {
                    if (limit-- == 0L) break;
                    sender.sendSuccess(() -> Component.literal((String)("  " + String.valueOf(e2.getValue()) + ": " + ((ChunkPos)e.getKey()).x + ", " + ((ChunkPos)e.getKey()).z)), false);
                }
                return toSort.size();
            }
            ArrayList info = new ArrayList();
            list.forEach((key, value) -> {
                if (names.contains(key)) {
                    Pair of = Pair.of((Object)key, (Object)((Integer)value.left));
                    info.add(of);
                }
            });
            info.sort((a, b) -> {
                if (Objects.equals(a.getRight(), b.getRight())) {
                    return ((ResourceLocation)a.getKey()).toString().compareTo(((ResourceLocation)b.getKey()).toString());
                }
                return (Integer)b.getRight() - (Integer)a.getRight();
            });
            if (info.size() == 0) {
                throw NO_ENTITIES.create();
            }
            int count = info.stream().mapToInt(Pair::getRight).sum();
            sender.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.entity.list.multiple.header", count), false);
            info.forEach(e -> sender.sendSuccess(() -> Component.literal((String)("  " + String.valueOf(e.getValue()) + ": " + String.valueOf(e.getKey()))), false));
            return info.size();
        }
    }
}

