/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.earlydisplay;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.fml.earlydisplay.ColourScheme;
import net.minecraftforge.fml.earlydisplay.ElementShader;
import net.minecraftforge.fml.earlydisplay.PerformanceInfo;
import net.minecraftforge.fml.earlydisplay.QuadHelper;
import net.minecraftforge.fml.earlydisplay.STBHelper;
import net.minecraftforge.fml.earlydisplay.SimpleBufferBuilder;
import net.minecraftforge.fml.earlydisplay.SimpleFont;
import net.minecraftforge.fml.loading.progress.Message;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import org.lwjgl.opengl.GL32C;

public class RenderElement {
    static final int INDEX_TEXTURE_OFFSET = 5;
    private final SimpleBufferBuilder bb = new SimpleBufferBuilder(1);
    private final Renderer renderer;
    static int globalAlpha = 255;
    private int retireCount;
    private static final int BAR_HEIGHT = 20;
    private static final int BAR_WIDTH = 400;

    public RenderElement(Initializer rendererInitializer) {
        this.renderer = (Renderer)rendererInitializer.get();
    }

    public boolean render(DisplayContext ctx, int count) {
        this.renderer.accept(this.bb, ctx, count);
        return this.retireCount == 0 || this.retireCount < count;
    }

    public void retire(int frame) {
        this.retireCount = frame;
    }

    private static void startupLogMessages(SimpleBufferBuilder bb, SimpleFont font, DisplayContext context) {
        List messages = StartupNotificationManager.getMessages();
        ArrayList<SimpleFont.DisplayText> texts = new ArrayList<SimpleFont.DisplayText>();
        for (int i = messages.size() - 1; i >= 0; --i) {
            StartupNotificationManager.AgeMessage pair = (StartupNotificationManager.AgeMessage)messages.get(i);
            float fade = RenderElement.clamp((4000.0f - (float)pair.age() - (float)(i - 4) * 1000.0f) / 5000.0f, 0.0f, 1.0f);
            if (fade < 0.01f) continue;
            Message msg = pair.message();
            int colour = Math.min((int)(fade * 255.0f), globalAlpha) << 24 | 0xFFFFFF;
            texts.add(new SimpleFont.DisplayText(msg.getText() + "\n", colour));
        }
        font.generateVerticesForTexts(10, context.scaledHeight() - texts.size() * font.lineSpacing() + font.descent() - 10, bb, (SimpleFont.DisplayText[])texts.toArray(SimpleFont.DisplayText[]::new));
    }

    public static RenderElement monag() {
        return new RenderElement(RenderElement.initializeTexture("monagstudios.png", 45000, 4, (bb, ctx, sz, frame) -> {
            int size = 256;
            int x0 = (ctx.width() - 2 * size) / 2;
            int y0 = 64;
            QuadHelper.loadQuad(bb, x0, x0 + size, y0, (float)y0 + (float)size / 2.0f, 0.0f, 1.0f, 0.0f, 0.5f, -1);
            QuadHelper.loadQuad(bb, x0 + size, x0 + 2 * size, y0, (float)y0 + (float)size / 2.0f, 0.0f, 1.0f, 0.5f, 1.0f, -1);
        }));
    }

    public static RenderElement mojang(int textureId, int frameStart) {
        return new RenderElement(() -> (bb, ctx, frame) -> {
            int size = 256 * ctx.scale();
            int x0 = (ctx.scaledWidth() - 2 * size) / 2;
            int y0 = 64 * ctx.scale() + 32;
            ctx.elementShader().updateTextureUniform(0);
            ctx.elementShader().updateRenderTypeUniform(ElementShader.RenderType.TEXTURE);
            int fade = Math.min((frame - frameStart) * 10, 255);
            GL32C.glBindTexture((int)3553, (int)textureId);
            bb.begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
            QuadHelper.loadQuad(bb, x0, x0 + size, y0, (float)y0 + (float)size / 2.0f, 0.0f, 1.0f, 0.0f, 0.5f, fade << 24 | 0xFFFFFF);
            QuadHelper.loadQuad(bb, x0 + size, x0 + 2 * size, y0, (float)y0 + (float)size / 2.0f, 0.0f, 1.0f, 0.5f, 1.0f, fade << 24 | 0xFFFFFF);
            bb.draw();
            GL32C.glBindTexture((int)3553, (int)0);
        });
    }

    public static RenderElement logMessageOverlay(SimpleFont font) {
        return new RenderElement(RenderElement.initializeText(font, RenderElement::startupLogMessages));
    }

    public static RenderElement forgeVersionOverlay(SimpleFont font, String version) {
        return new RenderElement(RenderElement.initializeText(font, (bb, fnt, ctx) -> font.generateVerticesForTexts(ctx.scaledWidth() - font.stringWidth(version) - 10, ctx.scaledHeight() - font.lineSpacing() + font.descent() - 10, bb, new SimpleFont.DisplayText(version, ctx.colourScheme.foreground().packedint(globalAlpha)))));
    }

    public static RenderElement squir() {
        return new RenderElement(RenderElement.initializeTexture("squirrel.png", 45000, 3, (bb, context, size, frame) -> {
            float inset;
            float x0 = inset = 5.0f;
            float x1 = inset + (float)(size[0] * context.scale());
            float y0 = inset;
            float y1 = inset + (float)(size[1] * context.scale());
            int fade = (int)(Math.cos((double)frame * Math.PI / 16.0) * 16.0) + 16;
            int colour = (Math.min(fade, globalAlpha) & 0xFF) << 24 | 0xFFFFFF;
            QuadHelper.loadQuad(bb, x0, x1, y0, y1, 0.0f, 1.0f, 0.0f, 1.0f, colour);
        }));
    }

    public static RenderElement anvil(SimpleFont font) {
        return new RenderElement(RenderElement.initializeTexture("forge_anvil.png", 20000, 2, (bb, context, size, frame) -> {
            int x0 = context.scaledWidth() - size[0] * context.scale();
            int x1 = context.scaledWidth();
            int y0 = context.scaledHeight() - size[0] * context.scale() - font.descent() - font.lineSpacing();
            int y1 = context.scaledHeight() - font.descent() - font.lineSpacing();
            int frameidx = frame % 32;
            float framepos = (float)frameidx * (float)size[0] / (float)size[1];
            float framesize = (float)size[0] / (float)size[1];
            QuadHelper.loadQuad(bb, x0, x1, y0, y1, 0.0f, 1.0f, framepos, framepos + framesize, globalAlpha << 24 | 0xFFFFFF);
        }));
    }

    public static RenderElement progressBars(SimpleFont font) {
        return new RenderElement(() -> (bb, ctx, frame) -> RenderElement.startupProgressBars(font, bb, ctx, frame));
    }

    public static RenderElement performanceBar(SimpleFont font) {
        return new RenderElement(() -> (bb, ctx, frame) -> RenderElement.memoryInfo(font, bb, ctx, frame));
    }

    public static void startupProgressBars(SimpleFont font, SimpleBufferBuilder buffer, DisplayContext context, int frameNumber) {
        Renderer acc = null;
        int barCount = 2;
        List currentProgress = StartupNotificationManager.getCurrentProgress();
        int size = currentProgress.size();
        int alpha = 255;
        for (int i = 0; i < barCount && i < size; ++i) {
            ProgressMeter pm = (ProgressMeter)currentProgress.get(i);
            Renderer barRenderer = RenderElement.barRenderer(i, alpha, font, pm, context);
            acc = barRenderer.then(acc);
            alpha >>= 1;
        }
        if (acc != null) {
            acc.accept(buffer, context, frameNumber);
        }
    }

    private static Renderer barRenderer(int cnt, int alpha, SimpleFont font, ProgressMeter pm, DisplayContext context) {
        int barSpacing = font.lineSpacing() - font.descent() + 20;
        int y = 250 * context.scale() + cnt * barSpacing;
        int colour = alpha << 24 | 0xFFFFFF;
        Renderer bar = pm.steps() == 0 ? RenderElement.progressBar(ctx -> new int[]{(ctx.scaledWidth() - 400 * ctx.scale()) / 2, y + font.lineSpacing() - font.descent(), 400 * ctx.scale()}, f -> colour, frame -> RenderElement.indeterminateBar(frame, cnt == 0)) : RenderElement.progressBar(ctx -> new int[]{(ctx.scaledWidth() - 400 * ctx.scale()) / 2, y + font.lineSpacing() - font.descent(), 400 * ctx.scale()}, f -> colour, f -> new float[]{0.0f, pm.progress()});
        Renderer label = (bb, ctx, frame) -> RenderElement.renderText(font, RenderElement.text((ctx.scaledWidth() - 400 * ctx.scale()) / 2, y, pm.label().getText(), colour), bb, ctx);
        return bar.then(label);
    }

    private static float[] indeterminateBar(int frame, boolean isActive) {
        if (globalAlpha != 255 || !isActive) {
            return new float[]{0.0f, 1.0f};
        }
        int progress = frame % 100;
        return new float[]{RenderElement.clamp((float)(progress - 2) / 100.0f, 0.0f, 1.0f), RenderElement.clamp((float)(progress + 2) / 100.0f, 0.0f, 1.0f)};
    }

    private static void memoryInfo(SimpleFont font, SimpleBufferBuilder buffer, DisplayContext context, int frameNumber) {
        int y = 10 * context.scale();
        PerformanceInfo pi = context.performance();
        int colour = RenderElement.hsvToRGB((1.0f - (float)Math.pow(pi.memory(), 1.5)) / 3.0f, 1.0f, 0.5f);
        Renderer bar = RenderElement.progressBar(ctx -> new int[]{(ctx.scaledWidth() - 400 * ctx.scale()) / 2, y, 400 * ctx.scale()}, f -> colour, f -> new float[]{0.0f, pi.memory()});
        int width = font.stringWidth(pi.text());
        Renderer label = (bb, ctx, frame) -> RenderElement.renderText(font, RenderElement.text(ctx.scaledWidth() / 2 - width / 2, y + 18, pi.text(), context.colourScheme.foreground().packedint(globalAlpha)), bb, ctx);
        bar.then(label).accept(buffer, context, frameNumber);
    }

    public static Renderer progressBar(BarPosition position, ColourFunction colourFunction, ProgressDisplay progressDisplay) {
        return (bb, context, frame) -> {
            int colour = colourFunction.colour(frame);
            int alpha = (colour & 0xFF000000) >> 24;
            context.elementShader().updateTextureUniform(0);
            context.elementShader().updateRenderTypeUniform(ElementShader.RenderType.BAR);
            float[] progress = progressDisplay.progress(frame);
            bb.begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
            int inset = 2;
            int[] pos = position.location(context);
            int x0 = pos[0];
            int x1 = pos[0] + pos[2] + 4 * inset;
            int y0 = pos[1];
            int y1 = y0 + 20;
            QuadHelper.loadQuad(bb, x0, x1, y0, y1, 0.0f, 0.0f, 0.0f, 0.0f, context.colourScheme().foreground().packedint(alpha));
            QuadHelper.loadQuad(bb, x0 += inset, x1 -= inset, y0 += inset, y1 -= inset, 0.0f, 0.0f, 0.0f, 0.0f, context.colourScheme().background().packedint(globalAlpha));
            x1 = x0 + inset + (int)(progress[1] * (float)pos[2]);
            x0 = (int)((float)x0 + ((float)inset + progress[0] * (float)pos[2]));
            QuadHelper.loadQuad(bb, x0, x1, y0 += inset, y1 -= inset, 0.0f, 0.0f, 0.0f, 0.0f, colour);
            bb.draw();
        };
    }

    private static Initializer initializeText(SimpleFont font, TextGenerator textGenerator) {
        return () -> (bb, context, frame) -> RenderElement.renderText(font, textGenerator, bb, context);
    }

    private static void renderText(SimpleFont font, TextGenerator textGenerator, SimpleBufferBuilder bb, DisplayContext context) {
        context.elementShader().updateTextureUniform(font.textureNumber());
        context.elementShader().updateRenderTypeUniform(ElementShader.RenderType.FONT);
        bb.begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
        textGenerator.accept(bb, font, context);
        bb.draw();
    }

    private static TextGenerator text(int x, int y, String text, int colour) {
        return (bb, font, context) -> font.generateVerticesForTexts(x, y, bb, new SimpleFont.DisplayText(text, colour));
    }

    private static Initializer initializeTexture(String textureFileName, int size, int textureNumber, TextureRenderer positionAndColour) {
        return () -> {
            int[] imgSize = STBHelper.loadTextureFromClasspath(textureFileName, size, 33984 + textureNumber + 5);
            return (bb, ctx, frame) -> {
                ctx.elementShader().updateTextureUniform(textureNumber + 5);
                ctx.elementShader().updateRenderTypeUniform(ElementShader.RenderType.TEXTURE);
                RenderElement.renderTexture(bb, ctx, frame, imgSize, positionAndColour);
            };
        };
    }

    private static void renderTexture(SimpleBufferBuilder bb, DisplayContext context, int frame, int[] size, TextureRenderer positionAndColour) {
        bb.begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
        positionAndColour.accept(bb, context, size, frame);
        bb.draw();
    }

    public static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static int clamp(int num, int min, int max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static int hsvToRGB(float hue, float saturation, float value) {
        float f5;
        float f4;
        int i = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)i;
        float f1 = value * (1.0f - saturation);
        float f2 = value * (1.0f - f * saturation);
        float f3 = value * (1.0f - (1.0f - f) * saturation);
        float f6 = switch (i) {
            case 0 -> {
                f4 = value;
                f5 = f3;
                yield f1;
            }
            case 1 -> {
                f4 = f2;
                f5 = value;
                yield f1;
            }
            case 2 -> {
                f4 = f1;
                f5 = value;
                yield f3;
            }
            case 3 -> {
                f4 = f1;
                f5 = f2;
                yield value;
            }
            case 4 -> {
                f4 = f3;
                f5 = f1;
                yield value;
            }
            case 5 -> {
                f4 = value;
                f5 = f1;
                yield f2;
            }
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
        };
        int j = RenderElement.clamp((int)(f4 * 255.0f), 0, 255);
        int k = RenderElement.clamp((int)(f5 * 255.0f), 0, 255);
        int l = RenderElement.clamp((int)(f6 * 255.0f), 0, 255);
        return 0xFF000000 | j << 16 | k << 8 | l;
    }

    static interface Initializer
    extends Supplier<Renderer> {
    }

    static interface Renderer {
        public void accept(SimpleBufferBuilder var1, DisplayContext var2, int var3);

        default public Renderer then(Renderer r) {
            if (r == null) {
                return this;
            }
            return (bb, ctx, frame) -> {
                r.accept(bb, ctx, frame);
                this.accept(bb, ctx, frame);
            };
        }
    }

    public record DisplayContext(int width, int height, int scale, ElementShader elementShader, ColourScheme colourScheme, PerformanceInfo performance) {
        public int scaledWidth() {
            return this.scale() * this.width();
        }

        public int scaledHeight() {
            return this.scale() * this.height();
        }
    }

    static interface TextureRenderer {
        public void accept(SimpleBufferBuilder var1, DisplayContext var2, int[] var3, int var4);
    }

    static interface TextGenerator {
        public void accept(SimpleBufferBuilder var1, SimpleFont var2, DisplayContext var3);
    }

    static interface BarPosition {
        public int[] location(DisplayContext var1);
    }

    static interface ColourFunction {
        public int colour(int var1);
    }

    static interface ProgressDisplay {
        public float[] progress(int var1);
    }
}

