/*
 * Decompiled with CFR 0.152.
 */
package at.spardat.xma.xdelta;

import com.nothome.delta.Delta;
import com.nothome.delta.DiffWriter;
import com.nothome.delta.GDiffWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarDelta {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeDelta(ZipFile source, ZipFile target, ZipOutputStream output) throws IOException {
        try {
            ByteArrayOutputStream listBytes = new ByteArrayOutputStream();
            PrintWriter list = new PrintWriter(new OutputStreamWriter(listBytes));
            Enumeration<? extends ZipEntry> enumer = target.entries();
            while (enumer.hasMoreElements()) {
                ZipEntry targetEntry = enumer.nextElement();
                ZipEntry sourceEntry = source.getEntry(targetEntry.getName());
                list.println(targetEntry.getName());
                if (targetEntry.isDirectory()) {
                    if (sourceEntry != null) continue;
                    ZipEntry outputEntry = new ZipEntry(targetEntry);
                    output.putNextEntry(outputEntry);
                    continue;
                }
                int targetSize = (int)targetEntry.getSize();
                byte[] targetBytes = new byte[targetSize];
                InputStream targetStream = target.getInputStream(targetEntry);
                for (int erg = targetStream.read(targetBytes); erg < targetBytes.length; erg += targetStream.read(targetBytes, erg, targetBytes.length - erg)) {
                }
                targetStream.close();
                int chunk = 16;
                if (sourceEntry == null || sourceEntry.getSize() <= (long)chunk || targetEntry.getSize() <= (long)chunk) {
                    ZipEntry outputEntry = new ZipEntry(targetEntry);
                    output.putNextEntry(outputEntry);
                    output.write(targetBytes);
                    continue;
                }
                int sourceSize = (int)sourceEntry.getSize();
                byte[] sourceBytes = new byte[sourceSize];
                InputStream sourceStream = source.getInputStream(sourceEntry);
                for (int erg = sourceStream.read(sourceBytes); erg < sourceBytes.length; erg += sourceStream.read(sourceBytes, erg, sourceBytes.length - erg)) {
                }
                sourceStream.close();
                if (this.equal(sourceBytes, targetBytes)) continue;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                GDiffWriter diffWriter = new GDiffWriter(new DataOutputStream(outputStream));
                Delta d = new Delta();
                d.compute(sourceBytes, target.getInputStream(targetEntry), (DiffWriter)diffWriter);
                diffWriter.close();
                ZipEntry outputEntry = new ZipEntry(targetEntry.getName() + ".gdiff");
                outputEntry.setTime(targetEntry.getTime());
                output.putNextEntry(outputEntry);
                output.write(outputStream.toByteArray());
            }
            list.close();
            ZipEntry listEntry = new ZipEntry("META-INF/file.list");
            output.putNextEntry(listEntry);
            output.write(listBytes.toByteArray());
        }
        finally {
            source.close();
            target.close();
            output.close();
        }
    }

    public boolean equal(byte[] source, byte[] target) {
        if (source.length != target.length) {
            return false;
        }
        for (int i = 0; i < source.length; ++i) {
            if (source[i] == target[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("usage JarDelta source target output");
            return;
        }
        new JarDelta().computeDelta(new ZipFile(args[0]), new ZipFile(args[1]), new ZipOutputStream(new FileOutputStream(args[2])));
    }
}

