/*
 * Decompiled with CFR 0.152.
 */
package ace.actually.valkyrienrelogs;

import ace.actually.valkyrienrelogs.blocks.RelogAnchorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixins;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.world.ServerShipWorld;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.DimensionIdProvider;

@Mod(value="valkyrienrelogs")
@Mod.EventBusSubscriber
public class ValkyrienRelogs {
    public static final String MODID = "valkyrienrelogs";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"valkyrienrelogs");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"valkyrienrelogs");
    public static final RegistryObject<Block> RELOG_ANCHOR = BLOCKS.register("relog_anchor", () -> new RelogAnchorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Item> RELOG_ANCHOR_BLOCK_ITEM = ITEMS.register("relog_anchor", () -> new BlockItem((Block)RELOG_ANCHOR.get(), new Item.Properties()));
    public static final ResourceLocation LOG_OFF_DATA = ResourceLocation.m_214293_((String)"valkyrienrelogs", (String)"log_off_data");

    public ValkyrienRelogs() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Mixins.addConfiguration((String)"valkyrienrelogs.mixins.json");
    }

    @SubscribeEvent
    public static void playerThere(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.player.m_19880_().contains("VaReLO")) {
            ServerShipWorld serverShipWorld = (ServerShipWorld)ValkyrienSkiesMod.getVsCore().getHooks().getCurrentShipServerWorld();
            CompoundTag compound = event.player.m_20194_().m_129897_().m_78044_(LOG_OFF_DATA);
            CompoundTag playerCompound = compound.m_128469_(event.player.m_20149_());
            int[] v = playerCompound.m_128465_("pos");
            if (v.length > 0) {
                BlockPos b = new BlockPos(v[0], v[1], v[2]);
                Vector3d go = VSGameUtilsKt.toWorldCoordinates((Ship)serverShipWorld.getAllShips().getById(playerCompound.m_128454_("lastShip")), (BlockPos)b);
                event.player.m_6021_(go.x, go.y + 2.0, go.z);
            }
            if (event.player.m_6047_()) {
                event.player.m_20137_("VaReLO");
            }
        }
    }

    @SubscribeEvent
    public static void tab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.accept(RELOG_ANCHOR_BLOCK_ITEM);
        }
    }

    @SubscribeEvent
    public static void playerLeft(PlayerEvent.PlayerLoggedOutEvent event) {
        Vec3 pos = event.getEntity().m_20182_();
        ServerShipWorld serverShipWorld = (ServerShipWorld)ValkyrienSkiesMod.getVsCore().getHooks().getCurrentShipServerWorld();
        DimensionIdProvider provider = (DimensionIdProvider)event.getEntity().m_9236_();
        ClipContext context = new ClipContext(pos, pos.m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult result = event.getEntity().m_9236_().m_45547_(context);
        if (serverShipWorld.isBlockInShipyard(result.m_82425_().m_123341_(), result.m_82425_().m_123342_(), result.m_82425_().m_123343_(), provider.getDimensionId())) {
            BlockPos b = result.m_82425_();
            ChunkPos chunkPos = event.getEntity().m_9236_().m_46865_(b).m_7697_();
            LoadedServerShip ship = (LoadedServerShip)ValkyrienSkiesMod.getVsCore().getHooks().getCurrentShipServerWorld().getLoadedShips().getByChunkPos(chunkPos.f_45578_, chunkPos.f_45579_, provider.getDimensionId());
            CompoundTag compound = event.getEntity().m_20194_().m_129897_().m_78044_(LOG_OFF_DATA);
            CompoundTag playerCompound = compound.m_128469_(event.getEntity().m_20149_());
            if (playerCompound.m_128454_("lastShip") == ship.getId()) {
                playerCompound.m_128385_("pos", new int[]{b.m_123341_(), b.m_123342_(), b.m_123343_()});
                playerCompound.m_128356_("ship", ship.getId());
                event.getEntity().m_20049_("VaReLO");
            }
            compound.m_128365_(event.getEntity().m_20149_(), (Tag)playerCompound);
            event.getEntity().m_20194_().m_129897_().m_78046_(LOG_OFF_DATA, compound);
        }
    }
}

