/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class PerimeterDiagnostics {
    private MobSpawnSettings.SpawnerData sle = null;
    private ServerLevel worldServer;
    private MobCategory ctype;
    private Mob el;

    private PerimeterDiagnostics(ServerLevel server, MobCategory ctype, Mob el) {
        this.worldServer = server;
        this.ctype = ctype;
        this.el = el;
    }

    public static Result countSpots(ServerLevel worldserver, BlockPos epos, Mob el) {
        int eY = epos.m_123342_();
        int eX = epos.m_123341_();
        int eZ = epos.m_123343_();
        Result result = new Result();
        boolean add_water = false;
        boolean add_ground = false;
        MobCategory ctype = null;
        if (el != null) {
            if (el instanceof WaterAnimal) {
                add_water = true;
                ctype = MobCategory.WATER_CREATURE;
            } else if (el instanceof AgeableMob) {
                add_ground = true;
                ctype = MobCategory.CREATURE;
            } else if (el instanceof Enemy) {
                add_ground = true;
                ctype = MobCategory.MONSTER;
            } else if (el instanceof AmbientCreature) {
                ctype = MobCategory.AMBIENT;
            }
        }
        PerimeterDiagnostics diagnostic = new PerimeterDiagnostics(worldserver, ctype, el);
        EntityType type = EntityType.f_20501_;
        if (el != null) {
            type = el.m_6095_();
        }
        int minY = worldserver.m_141937_();
        int maxY = worldserver.m_151558_();
        for (int x = -128; x <= 128; ++x) {
            for (int z = -128; z <= 128; ++z) {
                if (x * x + z * z > 16384) continue;
                for (int y = minY; y < maxY; ++y) {
                    boolean flag;
                    int distsq;
                    if (Math.abs(y - eY) > 128 || (distsq = x * x + (eY - y) * (eY - y) + z * z) > 16384 || distsq < 576) continue;
                    BlockPos pos = new BlockPos(eX + x, y, eZ + z);
                    BlockState iblockstate = worldserver.m_8055_(pos);
                    BlockState iblockstate_down = worldserver.m_8055_(pos.m_7495_());
                    BlockState iblockstate_up = worldserver.m_8055_(pos.m_7494_());
                    if (iblockstate.m_60819_().m_205070_(FluidTags.f_13131_) && !iblockstate_up.m_60796_((BlockGetter)worldserver, pos)) {
                        ++result.liquid;
                        if (!add_water || !diagnostic.check_entity_spawn(pos)) continue;
                        ++result.specific;
                        if (result.samples.size() >= 10) continue;
                        result.samples.add(pos);
                        continue;
                    }
                    if (!iblockstate_down.m_60796_((BlockGetter)worldserver, pos)) continue;
                    Block block = iblockstate_down.m_60734_();
                    boolean bl = flag = block != Blocks.f_50752_ && block != Blocks.f_50375_;
                    if (!flag || !NaturalSpawner.m_47056_((BlockGetter)worldserver, (BlockPos)pos, (BlockState)iblockstate, (FluidState)iblockstate.m_60819_(), (EntityType)type) || !NaturalSpawner.m_47056_((BlockGetter)worldserver, (BlockPos)pos.m_7494_(), (BlockState)iblockstate_up, (FluidState)iblockstate_up.m_60819_(), (EntityType)type)) continue;
                    ++result.ground;
                    if (!add_ground || !diagnostic.check_entity_spawn(pos)) continue;
                    ++result.specific;
                    if (result.samples.size() >= 10) continue;
                    result.samples.add(pos);
                }
            }
        }
        return result;
    }

    private boolean check_entity_spawn(BlockPos pos) {
        SpawnPlacements.Type spt;
        if (this.sle == null || !this.worldServer.m_7726_().m_8481_().m_223133_(this.worldServer.m_204166_(pos), this.worldServer.m_215010_(), this.ctype, pos).m_146338_().contains(this.sle)) {
            this.sle = null;
            for (MobSpawnSettings.SpawnerData sle : this.worldServer.m_7726_().m_8481_().m_223133_(this.worldServer.m_204166_(pos), this.worldServer.m_215010_(), this.ctype, pos).m_146338_()) {
                if (this.el.m_6095_() != sle.f_48404_) continue;
                this.sle = sle;
                break;
            }
            if (this.sle == null || !this.worldServer.m_7726_().m_8481_().m_223133_(this.worldServer.m_204166_(pos), this.worldServer.m_215010_(), this.ctype, pos).m_146338_().contains(this.sle)) {
                return false;
            }
        }
        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)(spt = SpawnPlacements.m_21752_((EntityType)this.sle.f_48404_)), (LevelReader)this.worldServer, (BlockPos)pos, (EntityType)this.sle.f_48404_)) {
            this.el.m_7678_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), 0.0f, 0.0f);
            return this.el.m_6914_((LevelReader)this.worldServer) && this.el.m_5545_((LevelAccessor)this.worldServer, MobSpawnType.NATURAL) && SpawnPlacements.m_217074_((EntityType)this.el.m_6095_(), (ServerLevelAccessor)((ServerLevel)this.el.m_20193_()), (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)this.el.m_20183_(), (RandomSource)this.el.m_20193_().f_46441_) && this.worldServer.m_45786_((Entity)this.el);
        }
        return false;
    }

    public static class Result {
        public int liquid;
        public int ground;
        public int specific;
        public List<BlockPos> samples = new ArrayList<BlockPos>();

        Result() {
        }
    }
}

