/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.lang3.tuple.Pair;

public class CarpetProfiler {
    private static final Object2LongOpenHashMap<String> SECTION_STATS = new Object2LongOpenHashMap();
    private static final Object2LongOpenHashMap<Pair<Level, Object>> ENTITY_TIMES = new Object2LongOpenHashMap();
    private static final Object2LongOpenHashMap<Pair<Level, Object>> ENTITY_COUNT = new Object2LongOpenHashMap();
    private static CommandSourceStack currentRequester = null;
    public static int tick_health_requested = 0;
    private static int tick_health_elapsed = 0;
    private static TYPE test_type = TYPE.NONE;
    private static long current_tick_start = 0L;
    private static final Map<String, String> GENERAL_SECTIONS = Map.of("Network", "Packet sending, player logins, disconnects, kicks, anti-cheat check for player movement, etc.", "Autosave", "Autosave", "Async Tasks", "Various asynchronous tasks on the server. Mainly chunk generation, chunk saving, etc.", "Datapacks", "Datapack tick function execution. Load function execution if reload was performed.", "Carpet", "Player hud, scripts, and extensions (If they choose to use carpet's onTick).");
    private static final Map<String, String> SCARPET_SECTIONS = Map.of("Scarpet run", "script run command execution", "Scarpet events", "script events, custom or built-in", "Scarpet schedule", "script scheduled calls/events", "Scarpet command", "script custom commands. Calls, executions, suggestions, etc.", "Scarpet load", "script and libraries (if required) loading", "Scarpet app data", "script module data (if required) ticking and saving", "Scarpet client", "script shape rendering. (Client side)");
    private static final Map<String, String> SECTIONS = Map.ofEntries(Map.entry("Spawning", "Spawning of various things. Natural mobs, cats, patrols, wandering traders, phantoms, skeleton horses, etc."), Map.entry("Random Ticks", "Random ticks. Both block random ticks and fluid random ticks."), Map.entry("Ticket Manager", "Chunk ticket manager. Assigning tickets, removing tickets, etc."), Map.entry("Unloading", "POI ticking and chunk unloading."), Map.entry("Schedule Ticks", "Scheduled ticks. Repeaters, observers, redstone torch, water, lava, etc."), Map.entry("Block Events", "Scheduled Block events. Pistons, comparators, noteblocks, block entity events (chests opening/closing), etc."), Map.entry("Entities", "All the entities in the server. Ticking, removing, despawning, dragon fight (if active), etc."), Map.entry("Block Entities", "All the block entities in the server. Removal, ticking, etc."), Map.entry("Entities (Client)", "Entity lag client side. Mostly rendering."), Map.entry("Block Entities (Client)", "Block entity lag client side. Mostly rendering."), Map.entry("Raid", "Raid ticking, stopping, etc."), Map.entry("Environment", "Weather, time, waking up players, water freezing, cauldron filling, snow layers, etc."));

    public static void prepare_tick_report(CommandSourceStack source, int ticks) {
        SECTION_STATS.clear();
        ENTITY_COUNT.clear();
        ENTITY_TIMES.clear();
        test_type = TYPE.GENERAL;
        tick_health_elapsed = ticks;
        tick_health_requested = ticks;
        current_tick_start = 0L;
        currentRequester = source;
    }

    public static void prepare_entity_report(CommandSourceStack source, int ticks) {
        SECTION_STATS.clear();
        ENTITY_COUNT.clear();
        ENTITY_TIMES.clear();
        test_type = TYPE.ENTITY;
        tick_health_elapsed = ticks;
        tick_health_requested = ticks;
        current_tick_start = 0L;
        currentRequester = source;
    }

    public static ProfilerToken start_section(Level world, String name, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.GENERAL || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, name, world);
    }

    public static ProfilerToken start_entity_section(Level world, Entity e, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, e.m_6095_(), world);
    }

    public static ProfilerToken start_block_entity_section(Level world, BlockEntity be, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, be.m_58903_(), world);
    }

    public static void end_current_section(ProfilerToken tok) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.GENERAL || current_tick_start == 0L || tok == null) {
            return;
        }
        long end_time = System.nanoTime();
        if (tok.type == TYPE.GENERAL) {
            Level world = tok.world;
            String current_section = world == null ? (String)tok.section : String.format("%s.%s%s", world.m_46472_().m_135782_(), tok.section, world.f_46443_ ? " (Client)" : "");
            SECTION_STATS.addTo((Object)current_section, end_time - tok.start);
        }
    }

    public static void end_current_entity_section(ProfilerToken tok) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L || tok == null) {
            return;
        }
        long end_time = System.nanoTime();
        Pair section = Pair.of((Object)tok.world, (Object)tok.section);
        ENTITY_TIMES.addTo((Object)section, end_time - tok.start);
        ENTITY_COUNT.addTo((Object)section, 1L);
    }

    public static void start_tick_profiling() {
        current_tick_start = System.nanoTime();
    }

    public static void end_tick_profiling(MinecraftServer server) {
        if (current_tick_start == 0L) {
            return;
        }
        SECTION_STATS.addTo((Object)"tick", System.nanoTime() - current_tick_start);
        if (--tick_health_elapsed <= 0) {
            CarpetProfiler.finalize_tick_report(server);
        }
    }

    public static void finalize_tick_report(MinecraftServer server) {
        if (test_type == TYPE.GENERAL) {
            CarpetProfiler.finalize_tick_report_for_time(server);
        }
        if (test_type == TYPE.ENTITY) {
            CarpetProfiler.finalize_tick_report_for_entities(server);
        }
        CarpetProfiler.cleanup_tick_report();
    }

    public static void cleanup_tick_report() {
        SECTION_STATS.clear();
        ENTITY_TIMES.clear();
        ENTITY_COUNT.clear();
        test_type = TYPE.NONE;
        tick_health_elapsed = 0;
        tick_health_requested = 0;
        current_tick_start = 0L;
        currentRequester = null;
    }

    public static void finalize_tick_report_for_time(MinecraftServer server) {
        double amount;
        if (currentRequester == null) {
            return;
        }
        long total_tick_time = SECTION_STATS.getLong((Object)"tick");
        double divider = 1.0 / (double)tick_health_requested / 1000000.0;
        Messenger.m(currentRequester, "w ");
        Messenger.m(currentRequester, "wb Average tick time: ", String.format("yb %.3fms", divider * (double)total_tick_time));
        long accumulated = 0L;
        for (String section : GENERAL_SECTIONS.keySet()) {
            amount = divider * (double)SECTION_STATS.getLong((Object)section);
            if (!(amount > 0.01)) continue;
            accumulated += SECTION_STATS.getLong((Object)section);
            Messenger.m(currentRequester, "w " + section + ": ", "^ " + GENERAL_SECTIONS.get(section), "y %.3fms".formatted(amount));
        }
        for (String section : SCARPET_SECTIONS.keySet()) {
            amount = divider * (double)SECTION_STATS.getLong((Object)section);
            if (!(amount > 0.01)) continue;
            Messenger.m(currentRequester, "gi " + section + ": ", "^ " + SCARPET_SECTIONS.get(section), "di %.3fms".formatted(amount));
        }
        for (ResourceKey dim : server.m_129784_()) {
            double amount2;
            ResourceLocation dimensionId = dim.m_135782_();
            boolean hasSomethin = false;
            for (String section : SECTIONS.keySet()) {
                amount2 = divider * (double)SECTION_STATS.getLong((Object)(String.valueOf(dimensionId) + "." + section));
                if (!(amount2 > 0.01)) continue;
                hasSomethin = true;
                break;
            }
            if (!hasSomethin) continue;
            Messenger.m(currentRequester, "wb " + (dimensionId.m_135827_().equals("minecraft") ? dimensionId.m_135815_() : dimensionId.toString()) + ":");
            for (String section : SECTIONS.keySet()) {
                amount2 = divider * (double)SECTION_STATS.getLong((Object)(String.valueOf(dimensionId) + "." + section));
                if (!(amount2 > 0.01)) continue;
                boolean cli = section.endsWith("(Client)");
                if (!cli) {
                    accumulated += SECTION_STATS.getLong((Object)(String.valueOf(dimensionId) + "." + section));
                }
                Messenger.m(currentRequester, "%s - %s: ".formatted(cli ? "gi" : "w", section), "^ " + SECTIONS.get(section), "%s %.3fms".formatted(cli ? "di" : "y", amount2));
            }
        }
        long rest = total_tick_time - accumulated;
        Messenger.m(currentRequester, String.format("gi The Rest, whatever that might be: %.3fms", divider * (double)rest));
    }

    private static String sectionName(Pair<Level, Object> section) {
        ResourceLocation dimkey;
        Object name;
        RegistryAccess regs = ((Level)section.getKey()).m_9598_();
        ResourceLocation id = section.getValue() instanceof EntityType ? regs.m_175515_(Registries.f_256939_).m_7981_((Object)((EntityType)section.getValue())) : regs.m_175515_(Registries.f_256922_).m_7981_((Object)((BlockEntityType)section.getValue()));
        Object object = name = "minecraft".equals(id.m_135827_()) ? id.m_135815_() : id.toString();
        if (((Level)section.getKey()).f_46443_) {
            name = (String)name + " (client)";
        }
        String dim = "minecraft".equals((dimkey = ((Level)section.getKey()).m_46472_().m_135782_()).m_135827_()) ? dimkey.m_135815_() : dimkey.toString();
        return (String)name + " in " + dim;
    }

    public static void finalize_tick_report_for_entities(MinecraftServer server) {
        boolean cli;
        Pair section;
        if (currentRequester == null) {
            return;
        }
        long total_tick_time = SECTION_STATS.getLong((Object)"tick");
        double divider = 1.0 / (double)tick_health_requested / 1000000.0;
        double divider_1 = 1.0 / (double)(tick_health_requested - 1) / 1000000.0;
        Messenger.m(currentRequester, "w ");
        Messenger.m(currentRequester, "wb Average tick time: ", String.format("yb %.3fms", divider * (double)total_tick_time));
        SECTION_STATS.removeLong((Object)"tick");
        Messenger.m(currentRequester, "wb Top 10 counts:");
        int total = 0;
        for (Object2LongMap.Entry<Pair<Level, Object>> sectionEntry : CarpetProfiler.sortedByValue(ENTITY_COUNT)) {
            if (++total > 10) break;
            section = (Pair)sectionEntry.getKey();
            cli = ((Level)section.getKey()).f_46443_;
            Messenger.m(currentRequester, String.format("%s - %s: ", cli ? "gi" : "w", CarpetProfiler.sectionName((Pair<Level, Object>)section)), String.format("%s %.1f", cli ? "di" : "y", 1.0 * (double)sectionEntry.getLongValue() / (double)(tick_health_requested - (cli ? 1 : 0))));
        }
        Messenger.m(currentRequester, "wb Top 10 CPU hogs:");
        total = 0;
        for (Object2LongMap.Entry<Pair<Level, Object>> sectionEntry : CarpetProfiler.sortedByValue(ENTITY_TIMES)) {
            if (++total > 10) break;
            section = (Pair)sectionEntry.getKey();
            cli = ((Level)section.getKey()).f_46443_;
            Messenger.m(currentRequester, String.format("%s - %s: ", cli ? "gi" : "w", CarpetProfiler.sectionName((Pair<Level, Object>)section)), String.format("%s %.2fms", cli ? "di" : "y", (cli ? divider : divider_1) * (double)sectionEntry.getLongValue()));
        }
    }

    private static <T> Iterable<Object2LongMap.Entry<T>> sortedByValue(Object2LongMap<T> mapToSort) {
        return () -> mapToSort.object2LongEntrySet().stream().sorted(Comparator.comparingLong(Object2LongMap.Entry::getLongValue).reversed()).iterator();
    }

    public static enum TYPE {
        NONE,
        GENERAL,
        ENTITY,
        TILEENTITY;

    }

    public record ProfilerToken(TYPE type, Object section, long start, Level world) {
        public ProfilerToken(TYPE type, Object section, Level world) {
            this(type, section, System.nanoTime(), world);
        }
    }
}

