/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.script.utils.Colors;
import carpet.utils.Messenger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class BlockInfo {
    public static List<Component> blockInfo(BlockPos pos, ServerLevel world) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        Object metastring = "";
        Registry blocks = world.m_9598_().m_175515_(Registries.f_256747_);
        for (Property iproperty : state.m_61147_()) {
            metastring = (String)metastring + ", " + iproperty.m_61708_() + "=" + String.valueOf(state.m_61143_(iproperty));
        }
        ArrayList<Component> lst = new ArrayList<Component>();
        lst.add(Messenger.s(""));
        lst.add(Messenger.s("====================================="));
        lst.add(Messenger.s(String.format("Block info for %s%s (id %d%s):", blocks.m_7981_((Object)block), metastring, blocks.m_7447_((Object)block), metastring)));
        lst.add(Messenger.s(String.format(" - Map colour: %s", Colors.mapColourName.get(state.m_284242_((BlockGetter)world, pos)))));
        lst.add(Messenger.s(String.format(" - Sound type: %s", Colors.soundName.get(block.m_49962_(state)))));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Full block: %s", state.m_60838_((BlockGetter)world, pos))));
        lst.add(Messenger.s(String.format(" - Normal cube: %s", state.m_60796_((BlockGetter)world, pos))));
        lst.add(Messenger.s(String.format(" - Is liquid: %s", state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_))));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Light in: %d, above: %d", Math.max(world.m_45517_(LightLayer.BLOCK, pos), world.m_45517_(LightLayer.SKY, pos)), Math.max(world.m_45517_(LightLayer.BLOCK, pos.m_7494_()), world.m_45517_(LightLayer.SKY, pos.m_7494_())))));
        lst.add(Messenger.s(String.format(" - Brightness in: %.2f, above: %.2f", Float.valueOf(world.m_220417_(pos)), Float.valueOf(world.m_220417_(pos.m_7494_())))));
        lst.add(Messenger.s(String.format(" - Is opaque: %s", state.m_280296_())));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Causes suffocation: %s", state.m_60828_((BlockGetter)world, pos))));
        lst.add(Messenger.s(String.format(" - Blocks movement on land: %s", !state.m_60647_((BlockGetter)world, pos, PathComputationType.LAND))));
        lst.add(Messenger.s(String.format(" - Blocks movement in air: %s", !state.m_60647_((BlockGetter)world, pos, PathComputationType.AIR))));
        lst.add(Messenger.s(String.format(" - Blocks movement in liquids: %s", !state.m_60647_((BlockGetter)world, pos, PathComputationType.WATER))));
        lst.add(Messenger.s(String.format(" - Can burn: %s", state.m_278200_())));
        lst.add(Messenger.s(String.format(" - Hardness: %.2f", Float.valueOf(state.m_60800_((BlockGetter)world, pos)))));
        lst.add(Messenger.s(String.format(" - Blast resistance: %.2f", Float.valueOf(block.m_7325_()))));
        lst.add(Messenger.s(String.format(" - Ticks randomly: %s", block.m_6724_(state))));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Can provide power: %s", state.m_60803_())));
        lst.add(Messenger.s(String.format(" - Strong power level: %d", world.m_277173_(pos))));
        lst.add(Messenger.s(String.format(" - Redstone power level: %d", world.m_277086_(pos))));
        lst.add(Messenger.s(""));
        lst.add(BlockInfo.wander_chances(pos.m_7494_(), world));
        return lst;
    }

    private static Component wander_chances(BlockPos pos, ServerLevel worldIn) {
        ZombifiedPiglin creature = new ZombifiedPiglin(EntityType.f_20531_, (Level)worldIn);
        creature.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(pos), MobSpawnType.NATURAL, null, null);
        creature.m_20035_(pos, 0.0f, 0.0f);
        RandomStrollGoal wander = new RandomStrollGoal((PathfinderMob)creature, 0.8);
        int success = 0;
        for (int i = 0; i < 1000; ++i) {
            Vec3 vec = DefaultRandomPos.m_148403_((PathfinderMob)creature, (int)10, (int)7);
            if (vec == null) continue;
            ++success;
        }
        long total_ticks = 0L;
        for (int trie = 0; trie < 1000; ++trie) {
            int i;
            for (i = 1; i < 36000 && !wander.m_8036_(); ++i) {
            }
            total_ticks += (long)(3 * i);
        }
        creature.m_146870_();
        long total_time = total_ticks / 1000L / 20L;
        return Messenger.s(String.format(" - Wander chance above: %.1f%%\n - Average standby above: %s", Float.valueOf(100.0f * (float)success / 1000.0f), total_time > 5000L ? "INFINITY" : total_time + " s"));
    }
}

