/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.value.ListValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.StringUtils;

public class NumericValue
extends Value {
    private final double value;
    private Long longValue;
    private static final double epsilon = Math.abs(2.842170943040401E-14);
    private static final MathContext displayRounding = new MathContext(12, RoundingMode.HALF_EVEN);

    public static NumericValue asNumber(Value v1, String id) {
        if (v1 instanceof NumericValue) {
            NumericValue nv = (NumericValue)v1;
            return nv;
        }
        throw new InternalExpressionException("Argument " + id + " has to be of a numeric type");
    }

    public static NumericValue asNumber(Value v1) {
        if (v1 instanceof NumericValue) {
            NumericValue nv = (NumericValue)v1;
            return nv;
        }
        throw new InternalExpressionException("Operand has to be of a numeric type");
    }

    public static <T extends Number> Value of(T value) {
        if (value == null) {
            return Value.NULL;
        }
        if (value.doubleValue() == (double)value.longValue()) {
            return new NumericValue(value.longValue());
        }
        if (value instanceof Float) {
            return new NumericValue(1.0E-6 * (double)Math.round(1000000.0 * value.doubleValue()));
        }
        return new NumericValue(value.doubleValue());
    }

    @Override
    public String getString() {
        if (this.longValue != null) {
            return Long.toString(this.getLong());
        }
        try {
            if (Double.isInfinite(this.value)) {
                return this.value > 0.0 ? "INFINITY" : "-INFINITY";
            }
            if (Double.isNaN(this.value)) {
                return "NaN";
            }
            if (Math.abs(this.value) < epsilon) {
                return Math.signum(this.value) < 0.0 ? "-0" : "0";
            }
            return BigDecimal.valueOf(this.value).round(displayRounding).stripTrailingZeros().toPlainString();
        }
        catch (NumberFormatException exc) {
            throw new InternalExpressionException("Incorrect number format for " + this.value);
        }
    }

    @Override
    public String getPrettyString() {
        return this.longValue != null || this.getDouble() == (double)this.getLong() ? Long.toString(this.getLong()) : String.format(Locale.ROOT, "%.1f..", this.getDouble());
    }

    @Override
    public boolean getBoolean() {
        return Math.abs(this.value) > epsilon;
    }

    public double getDouble() {
        return this.value;
    }

    public float getFloat() {
        return (float)this.value;
    }

    private static long floor(double v) {
        long invValue = (long)v;
        return v < (double)invValue ? invValue - 1L : invValue;
    }

    public long getLong() {
        return this.longValue != null ? this.longValue : Long.valueOf(NumericValue.floor(this.value + epsilon));
    }

    @Override
    public Value add(Value v) {
        if (v instanceof NumericValue) {
            NumericValue nv = (NumericValue)v;
            return this.longValue != null && nv.longValue != null ? new NumericValue(this.longValue + nv.longValue) : new NumericValue(this.value + nv.value);
        }
        return super.add(v);
    }

    @Override
    public Value subtract(Value v) {
        if (v instanceof NumericValue) {
            NumericValue nv = (NumericValue)v;
            return this.longValue != null && nv.longValue != null ? new NumericValue(this.longValue - nv.longValue) : new NumericValue(this.value - nv.value);
        }
        return super.subtract(v);
    }

    @Override
    public Value multiply(Value v) {
        if (v instanceof NumericValue) {
            NumericValue nv = (NumericValue)v;
            return this.longValue != null && nv.longValue != null ? new NumericValue(this.longValue * nv.longValue) : new NumericValue(this.value * nv.value);
        }
        return v instanceof ListValue ? v.multiply(this) : new StringValue(StringUtils.repeat((String)v.getString(), (int)((int)this.getLong())));
    }

    @Override
    public Value divide(Value v) {
        Value value;
        if (v instanceof NumericValue) {
            NumericValue nv = (NumericValue)v;
            value = new NumericValue(this.getDouble() / nv.getDouble());
        } else {
            value = super.divide(v);
        }
        return value;
    }

    public Value clone() {
        return new NumericValue(this.value, this.longValue);
    }

    @Override
    public int compareTo(Value o) {
        if (o.isNull()) {
            return -o.compareTo(this);
        }
        if (o instanceof NumericValue) {
            NumericValue no = (NumericValue)o;
            return this.longValue != null && no.longValue != null ? this.longValue.compareTo(no.longValue) : Double.compare(this.value, no.value);
        }
        return this.getString().compareTo(o.getString());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Value) {
            Value otherValue = (Value)o;
            if (otherValue.isNull()) {
                return o.equals(this);
            }
            if (o instanceof NumericValue) {
                NumericValue no = (NumericValue)o;
                return this.longValue != null && no.longValue != null ? this.longValue.equals(no.longValue) : !this.subtract(no).getBoolean();
            }
            return super.equals(o);
        }
        return false;
    }

    public NumericValue(double value) {
        this.value = value;
    }

    private NumericValue(double value, Long longValue) {
        this.value = value;
        this.longValue = longValue;
    }

    public NumericValue(String value) {
        BigDecimal decimal = new BigDecimal(value);
        if (decimal.stripTrailingZeros().scale() <= 0) {
            try {
                this.longValue = decimal.longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        this.value = decimal.doubleValue();
    }

    public NumericValue(long value) {
        this.longValue = value;
        this.value = value;
    }

    @Override
    public int length() {
        return Long.toString(this.getLong()).length();
    }

    @Override
    public double readDoubleNumber() {
        return this.value;
    }

    @Override
    public long readInteger() {
        return this.getLong();
    }

    @Override
    public String getTypeString() {
        return "number";
    }

    @Override
    public int hashCode() {
        return this.longValue != null || Math.abs(Math.floor(this.value + 0.5) - this.value) < epsilon ? Long.hashCode(this.getLong()) : Double.hashCode(this.value);
    }

    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public Tag toTag(boolean force) {
        if (this.longValue != null) {
            if (Math.abs(this.longValue) < 0x7FFFFFFDL) {
                return IntTag.m_128679_((int)((int)this.longValue.longValue()));
            }
            return LongTag.m_128882_((long)this.longValue);
        }
        long lv = this.getLong();
        if (this.value == (double)lv) {
            if (Math.abs(this.value) < 2.147483645E9) {
                return IntTag.m_128679_((int)((int)lv));
            }
            return LongTag.m_128882_((long)this.getLong());
        }
        return DoubleTag.m_128500_((double)this.value);
    }

    @Override
    public JsonElement toJson() {
        if (this.longValue != null) {
            return new JsonPrimitive((Number)this.longValue);
        }
        return this.isInteger() ? new JsonPrimitive((Number)this.getLong()) : new JsonPrimitive((Number)this.getDouble());
    }

    public NumericValue opposite() {
        return this.longValue != null ? new NumericValue(-this.longValue.longValue()) : new NumericValue(-this.value);
    }

    public boolean isInteger() {
        return this.longValue != null || this.getDouble() == (double)this.getLong();
    }

    public Value mod(NumericValue n2) {
        if (this.longValue != null && n2.longValue != null) {
            return new NumericValue(Math.floorMod((long)this.longValue, n2.longValue));
        }
        double x = this.value;
        double y = n2.value;
        if (y == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        return new NumericValue(x - Math.floor(x / y) * y);
    }
}

