/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.AbstractListValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class ListValue
extends AbstractListValue
implements ContainerValueInterface {
    protected final List<Value> items;

    @Override
    public String getString() {
        return "[" + this.items.stream().map(Value::getString).collect(Collectors.joining(", ")) + "]";
    }

    @Override
    public String getPrettyString() {
        return this.items.size() < 8 ? "[" + this.items.stream().map(Value::getPrettyString).collect(Collectors.joining(", ")) + "]" : "[" + this.items.get(0).getPrettyString() + ", " + this.items.get(1).getPrettyString() + ", ..., " + this.items.get(this.items.size() - 2).getPrettyString() + ", " + this.items.get(this.items.size() - 1).getPrettyString() + "]";
    }

    @Override
    public boolean getBoolean() {
        return !this.items.isEmpty();
    }

    public Value clone() {
        return new ListValue(this.items);
    }

    @Override
    public Value deepcopy() {
        ArrayList<Value> copyItems = new ArrayList<Value>(this.items.size());
        for (Value entry : this.items) {
            copyItems.add(entry.deepcopy());
        }
        return new ListValue((List<Value>)copyItems);
    }

    public ListValue(Collection<? extends Value> list) {
        this.items = new ArrayList<Value>(list);
    }

    protected ListValue(List<Value> list) {
        this.items = list;
    }

    public static Value fromTriple(double a, double b, double c) {
        return ListValue.of(new NumericValue(a), new NumericValue(b), new NumericValue(c));
    }

    public static Value fromTriple(int a, int b, int c) {
        return ListValue.fromTriple((double)a, (double)b, (double)c);
    }

    public static ListValue wrap(Stream<Value> stream) {
        return ListValue.wrap(stream.collect(Collectors.toList()));
    }

    public static ListValue wrap(List<Value> list) {
        return new ListValue(list);
    }

    public static ListValue of(Value ... list) {
        return new ListValue((List<Value>)new ArrayList<Value>(Arrays.asList(list)));
    }

    public static ListValue ofNums(Number ... list) {
        ArrayList<Value> valList = new ArrayList<Value>();
        for (Number i : list) {
            valList.add(new NumericValue(i.doubleValue()));
        }
        return new ListValue((List<Value>)valList);
    }

    public static LazyValue lazyEmpty() {
        ListValue ret = new ListValue();
        return (c, t) -> ret;
    }

    private ListValue() {
        this.items = new ArrayList<Value>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value add(Value other) {
        ListValue output = new ListValue();
        if (other instanceof ListValue) {
            ListValue list = (ListValue)other;
            List<Value> otherItems = list.items;
            if (otherItems.size() != this.items.size()) throw new InternalExpressionException("Cannot add two lists of uneven sizes");
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                output.items.add(this.items.get(i).add(otherItems.get(i)));
            }
            return output;
        } else {
            for (Value v : this.items) {
                output.items.add(v.add(other));
            }
        }
        return output;
    }

    @Override
    public void append(Value v) {
        this.items.add(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value subtract(Value other) {
        ListValue output = new ListValue();
        if (other instanceof ListValue) {
            ListValue list = (ListValue)other;
            List<Value> otherItems = list.items;
            if (otherItems.size() != this.items.size()) throw new InternalExpressionException("Cannot subtract two lists of uneven sizes");
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                output.items.add(this.items.get(i).subtract(otherItems.get(i)));
            }
            return output;
        } else {
            for (Value v : this.items) {
                output.items.add(v.subtract(other));
            }
        }
        return output;
    }

    public void subtractFrom(Value v) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value multiply(Value other) {
        ListValue output = new ListValue();
        if (other instanceof ListValue) {
            ListValue list = (ListValue)other;
            List<Value> otherItems = list.items;
            if (otherItems.size() != this.items.size()) throw new InternalExpressionException("Cannot multiply two lists of uneven sizes");
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                output.items.add(this.items.get(i).multiply(otherItems.get(i)));
            }
            return output;
        } else {
            for (Value v : this.items) {
                output.items.add(v.multiply(other));
            }
        }
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value divide(Value other) {
        ListValue output = new ListValue();
        if (other instanceof ListValue) {
            ListValue list = (ListValue)other;
            List<Value> otherItems = list.items;
            if (otherItems.size() != this.items.size()) throw new InternalExpressionException("Cannot divide two lists of uneven sizes");
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                output.items.add(this.items.get(i).divide(otherItems.get(i)));
            }
            return output;
        } else {
            for (Value v : this.items) {
                output.items.add(v.divide(other));
            }
        }
        return output;
    }

    @Override
    public int compareTo(Value o) {
        if (o instanceof ListValue) {
            int otherSize;
            ListValue ol = (ListValue)o;
            int size = this.getItems().size();
            if (size != (otherSize = ol.getItems().size())) {
                return size - otherSize;
            }
            if (size == 0) {
                return 0;
            }
            for (int i = 0; i < size; ++i) {
                int res = this.items.get(i).compareTo(ol.items.get(i));
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
        return this.getString().compareTo(o.getString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ListValue)) return false;
        ListValue list = (ListValue)o;
        if (!this.getItems().equals(list.getItems())) return false;
        return true;
    }

    public List<Value> getItems() {
        return this.items;
    }

    @Override
    public Iterator<Value> iterator() {
        return new ArrayList<Value>(this.items).iterator();
    }

    @Override
    public List<Value> unpack() {
        return new ArrayList<Value>(this.items);
    }

    public void extend(List<Value> subList) {
        this.items.addAll(subList);
    }

    public static int normalizeIndex(long idx, int len) {
        if (idx >= 0L && idx < (long)len) {
            return (int)idx;
        }
        long range = Math.abs(idx) / (long)len;
        idx += (range + 2L) * (long)len;
        return (int)(idx %= (long)len);
    }

    @Override
    public int length() {
        return this.items.size();
    }

    @Override
    public Value in(Value value1) {
        for (int i = 0; i < this.items.size(); ++i) {
            Value v = this.items.get(i);
            if (!v.equals(value1)) continue;
            return new NumericValue(i);
        }
        return Value.NULL;
    }

    @Override
    public Value slice(long fromDesc, Long toDesc) {
        List<Value> items = this.getItems();
        int size = items.size();
        int from = ListValue.normalizeIndex(fromDesc, size);
        if (toDesc == null) {
            return new ListValue((List<Value>)new ArrayList<Value>(this.getItems().subList(from, size)));
        }
        int to = ListValue.normalizeIndex(toDesc, size + 1);
        if (from > to) {
            return ListValue.of(new Value[0]);
        }
        return new ListValue((List<Value>)new ArrayList<Value>(this.getItems().subList(from, to)));
    }

    @Override
    public Value split(Value delimiter) {
        ListValue result = new ListValue();
        if (delimiter == null) {
            this.forEach(item -> result.items.add(ListValue.of(item)));
            return result;
        }
        int startIndex = 0;
        int index = 0;
        for (Value val : this.items) {
            ++index;
            if (!val.equals(delimiter)) continue;
            result.items.add(new ListValue((List<Value>)new ArrayList<Value>(this.items.subList(startIndex, index - 1))));
            startIndex = index;
        }
        result.items.add(new ListValue((List<Value>)new ArrayList<Value>(this.items.subList(startIndex, this.length()))));
        return result;
    }

    @Override
    public double readDoubleNumber() {
        return this.items.size();
    }

    @Override
    public boolean put(Value where, Value value, Value conditionValue) {
        String condition = conditionValue.getString();
        if (condition.equalsIgnoreCase("insert")) {
            return this.put(where, value, false, false);
        }
        if (condition.equalsIgnoreCase("extend")) {
            return this.put(where, value, false, true);
        }
        if (condition.equalsIgnoreCase("replace")) {
            return this.put(where, value, true, false);
        }
        throw new InternalExpressionException("List 'put' modifier could be either 'insert', 'replace', or extend");
    }

    @Override
    public boolean put(Value ind, Value value) {
        return this.put(ind, value, true, false);
    }

    private boolean put(Value ind, Value value, boolean replace, boolean extend) {
        if (ind.isNull()) {
            if (extend && value instanceof AbstractListValue) {
                ((AbstractListValue)value).iterator().forEachRemaining(this.items::add);
            } else {
                this.items.add(value);
            }
        } else {
            int numitems = this.items.size();
            if (!(ind instanceof NumericValue)) {
                return false;
            }
            int index = (int)((NumericValue)ind).getLong();
            if (index < 0) {
                index = ListValue.normalizeIndex(index, numitems);
            }
            if (replace) {
                while (index >= this.items.size()) {
                    this.items.add(Value.NULL);
                }
                this.items.set(index, value);
                return true;
            }
            while (index > this.items.size()) {
                this.items.add(Value.NULL);
            }
            if (extend && value instanceof AbstractListValue) {
                Iterable iterable = ((AbstractListValue)value)::iterator;
                List appendix = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
                this.items.addAll(index, appendix);
                return true;
            }
            this.items.add(index, value);
        }
        return true;
    }

    @Override
    public Value get(Value value) {
        int size = this.items.size();
        return size == 0 ? Value.NULL : this.items.get(ListValue.normalizeIndex(NumericValue.asNumber(value, "'address' to a list index").getLong(), size));
    }

    @Override
    public boolean has(Value where) {
        long index = NumericValue.asNumber(where, "'address' to a list index").getLong();
        return index >= 0L && index < (long)this.items.size();
    }

    @Override
    public boolean delete(Value where) {
        if (!(where instanceof NumericValue) || this.items.isEmpty()) {
            return false;
        }
        long index = ((NumericValue)where).getLong();
        this.items.remove(ListValue.normalizeIndex(index, this.items.size()));
        return true;
    }

    @Override
    public String getTypeString() {
        return "list";
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    public Tag toTag(boolean force) {
        int argSize = this.items.size();
        if (argSize == 0) {
            return new ListTag();
        }
        ListTag tag = new ListTag();
        if (argSize == 1) {
            tag.add((Object)this.items.get(0).toTag(force));
            return tag;
        }
        ArrayList tags = new ArrayList();
        this.items.forEach(v -> tags.add(v.toTag(force)));
        EnumSet<TagTypeCompat> cases = EnumSet.noneOf(TagTypeCompat.class);
        tags.forEach(t -> cases.add(TagTypeCompat.getType(t)));
        if (cases.size() == 1) {
            tag.addAll(tags);
            return tag;
        }
        if (cases.contains((Object)TagTypeCompat.LIST) || cases.contains((Object)TagTypeCompat.MAP) || cases.contains((Object)TagTypeCompat.STRING)) {
            if (!force) {
                throw new NBTSerializableValue.IncompatibleTypeException(this);
            }
            tags.forEach(t -> tag.add((Object)StringTag.m_129297_((String)t.m_7916_())));
            return tag;
        }
        tags.forEach(cases.contains((Object)TagTypeCompat.DBL) ? t -> tag.add((Object)DoubleTag.m_128500_((double)((NumericTag)t).m_7061_())) : t -> tag.add((Object)LongTag.m_128882_((long)((NumericTag)t).m_7046_())));
        return tag;
    }

    @Override
    public JsonElement toJson() {
        JsonArray array = new JsonArray();
        for (Value el : this.items) {
            array.add(el.toJson());
        }
        return array;
    }

    private static enum TagTypeCompat {
        INT,
        LONG,
        DBL,
        LIST,
        MAP,
        STRING;


        private static TagTypeCompat getType(Tag tag) {
            if (tag instanceof IntTag) {
                return INT;
            }
            if (tag instanceof LongTag) {
                return LONG;
            }
            if (tag instanceof DoubleTag) {
                return DBL;
            }
            if (tag instanceof ListTag) {
                return LIST;
            }
            if (tag instanceof CompoundTag) {
                return MAP;
            }
            return STRING;
        }
    }

    public static class ListConstructorValue
    extends ListValue {
        public ListConstructorValue(Collection<? extends Value> list) {
            super(list);
        }
    }
}

