/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.external.Carpet;
import carpet.script.external.VanillaClient;
import carpet.script.utils.ShapeDispatcher;
import carpet.script.utils.shapes.ShapeDirection;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ShapesRenderer {
    private final Map<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> shapes;
    private final Map<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> labels;
    private final Minecraft client;
    private final Map<String, BiFunction<Minecraft, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> renderedShapes = new HashMap<String, BiFunction<Minecraft, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>(){
        {
            this.put("line", RenderedLine::new);
            this.put("box", RenderedBox::new);
            this.put("sphere", RenderedSphere::new);
            this.put("cylinder", RenderedCylinder::new);
            this.put("label", RenderedText::new);
            this.put("polygon", RenderedPolyface::new);
            this.put("block", (c, s) -> new RenderedSprite((Minecraft)c, (ShapeDispatcher.ExpiringShape)s, false));
            this.put("item", (c, s) -> new RenderedSprite((Minecraft)c, (ShapeDispatcher.ExpiringShape)s, true));
        }
    };

    public static void rotatePoseStackByShapeDirection(PoseStack poseStack, ShapeDirection shapeDirection, Camera camera, Vec3 objectPos) {
        switch (shapeDirection) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case CAMERA: {
                poseStack.m_252781_(camera.m_253121_());
                break;
            }
            case PLAYER: {
                Vec3 vector = objectPos.m_82546_(camera.m_90583_());
                double x = vector.f_82479_;
                double y = vector.f_82480_;
                double z = vector.f_82481_;
                double d = Math.sqrt(x * x + z * z);
                float rotX = (float)Math.atan2(x, z);
                float rotY = (float)Math.atan2(y, d);
                poseStack.m_252781_(Axis.f_252436_.m_252961_(rotX));
                poseStack.m_252781_(Axis.f_252529_.m_252961_(-rotY));
            }
        }
    }

    public ShapesRenderer(Minecraft minecraftClient) {
        this.client = minecraftClient;
        this.shapes = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
        this.labels = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
    }

    public void render(PoseStack matrices, Camera camera, float partialTick) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        ClientLevel iWorld = this.client.f_91073_;
        ResourceKey dimensionType = iWorld.m_46472_();
        if ((this.shapes.get(dimensionType) == null || this.shapes.get(dimensionType).isEmpty()) && (this.labels.get(dimensionType) == null || this.labels.get(dimensionType).isEmpty())) {
            return;
        }
        long currentTime = this.client.f_91073_.m_46467_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_;
        double cameraZ = camera.m_90583_().f_82481_;
        boolean entityBoxes = this.client.m_91290_().m_114377_();
        if (!this.shapes.isEmpty()) {
            this.shapes.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            PoseStack matrixStack = RenderSystem.getModelViewStack();
            matrixStack.m_85836_();
            matrixStack.m_252931_(matrices.m_85850_().m_252922_());
            RenderSystem.applyModelViewMatrix();
            RenderSystem.lineWidth((float)0.5f);
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((ResourceKey<Level>)dimensionType)) {
                    s.renderLines(matrices, tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                }
            });
            RenderSystem.lineWidth((float)0.1f);
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((ResourceKey<Level>)dimensionType)) {
                    s.renderFaces(tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                }
            });
            RenderSystem.lineWidth((float)1.0f);
            matrixStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
        if (!this.labels.isEmpty()) {
            this.labels.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            this.labels.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((ResourceKey<Level>)dimensionType)) {
                    s.renderLines(matrices, tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                }
            });
        }
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        token.run();
    }

    public void addShapes(ListTag tag) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        int count = tag.size();
        for (int i = 0; i < count; ++i) {
            this.addShape(tag.m_128728_(i));
        }
        token.run();
    }

    public void addShape(CompoundTag tag) {
        ShapeDispatcher.ExpiringShape shape = ShapeDispatcher.fromTag(tag, (Level)this.client.f_91073_);
        if (shape == null) {
            return;
        }
        BiFunction<Minecraft, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>> shapeFactory = this.renderedShapes.get(tag.m_128461_("shape"));
        if (shapeFactory == null) {
            CarpetScriptServer.LOG.info("Unrecognized shape: " + tag.m_128461_("shape"));
        } else {
            RenderedShape<? extends ShapeDispatcher.ExpiringShape> rshape = shapeFactory.apply(this.client, shape);
            ResourceKey<Level> dim = shape.shapeDimension;
            long key = rshape.key();
            Map<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> container = rshape.stageDeux() ? this.labels : this.shapes;
            RenderedShape existing = (RenderedShape)container.computeIfAbsent(dim, d -> new Long2ObjectOpenHashMap()).get(key);
            if (existing != null) {
                existing.promoteWith(rshape);
            } else {
                container.get(dim).put(key, rshape);
            }
        }
    }

    public void reset() {
        this.shapes.values().forEach(Long2ObjectOpenHashMap::clear);
        this.labels.values().forEach(Long2ObjectOpenHashMap::clear);
    }

    public void renewShapes() {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        this.shapes.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        this.labels.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        token.run();
    }

    public static void drawLine(Tesselator tessellator, BufferBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2, float red1, float grn1, float blu1, float alpha) {
        builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        builder.m_5483_((double)x1, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
        builder.m_5483_((double)x2, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawBoxWireGLLines(Tesselator tessellator, BufferBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha, float red2, float grn2, float blu2) {
        builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        if (xthick) {
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_85950_(red1, grn2, blu2, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_85950_(red1, grn2, blu2, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
        }
        if (ythick) {
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_85950_(red2, grn1, blu2, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_85950_(red2, grn1, blu2, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
        }
        if (zthick) {
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_85950_(red2, grn2, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_85950_(red2, grn2, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
        }
        tessellator.m_85914_();
    }

    public static void drawBoxFaces(Tesselator tessellator, BufferBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha) {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (xthick && ythick) {
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            if (zthick) {
                builder.m_5483_((double)x1, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x1, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x2, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x2, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            }
        }
        if (zthick && ythick) {
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            if (xthick) {
                builder.m_5483_((double)x2, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x2, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x2, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x2, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            }
        }
        if (zthick && xthick) {
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            if (ythick) {
                builder.m_5483_((double)x1, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x2, (double)y2, (double)z1).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x2, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
                builder.m_5483_((double)x1, (double)y2, (double)z2).m_85950_(red1, grn1, blu1, alpha).m_5752_();
            }
        }
        tessellator.m_85914_();
    }

    public static void drawCylinderWireframe(Tesselator tessellator, BufferBuilder builder, float cx, float cy, float cz, float r, float h, Direction.Axis axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        int hsteps = 1;
        float hstep = 1.0f;
        if (!isFlat) {
            hsteps = (int)Math.ceil(Mth.m_14154_((float)h) / (step * r)) + 1;
            hstep = h / (float)(hsteps - 1);
        }
        if (axis == Direction.Axis.Y) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                for (int i = 0; i <= num_steps360 + 1; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.m_14089_((float)theta);
                    float y = hh;
                    float z = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(x + cx), (double)(y + cy), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                    theta = step * (float)i;
                    float x = r * Mth.m_14089_((float)theta);
                    z = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x), (double)(cy + 0.0f), (double)(cz - z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x), (double)(cy + h), (double)(cz - z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx - x), (double)(cy + h), (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    tessellator.m_85914_();
                }
            } else {
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float x = r * Mth.m_14089_((float)theta);
                    z = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(cx - x), (double)cy, (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x), (double)cy, (double)(cz - z)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
            }
        } else if (axis == Direction.Axis.X) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float z = r * Mth.m_14089_((float)theta);
                    float x = hh;
                    float y = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(x + cx), (double)(y + cy), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                    theta = step * (float)i;
                    float y = r * Mth.m_14089_((float)theta);
                    z = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(cx + 0.0f), (double)(cy - y), (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + 0.0f), (double)(cy + y), (double)(cz - z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + h), (double)(cy + y), (double)(cz - z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + h), (double)(cy - y), (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    tessellator.m_85914_();
                }
            } else {
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float y = r * Mth.m_14089_((float)theta);
                    z = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)cx, (double)(cy - y), (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)cx, (double)(cy + y), (double)(cz - z)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
            }
        } else if (axis == Direction.Axis.Z) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float y = r * Mth.m_14089_((float)theta);
                    float z = hh;
                    float x = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(x + cx), (double)(y + cy), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                    theta = step * (float)i;
                    float x = r * Mth.m_14089_((float)theta);
                    y = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(cx + x), (double)(cy - y), (double)(cz + 0.0f)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx - x), (double)(cy + y), (double)(cz + 0.0f)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx - x), (double)(cy + y), (double)(cz + h)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x), (double)(cy - y), (double)(cz + h)).m_85950_(red, grn, blu, alpha).m_5752_();
                    tessellator.m_85914_();
                }
            } else {
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float x = r * Mth.m_14089_((float)theta);
                    y = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(cx + x), (double)(cy - y), (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx - x), (double)(cy + y), (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
            }
        }
    }

    public static void drawCylinderFaces(Tesselator tessellator, BufferBuilder builder, float cx, float cy, float cz, float r, float h, Direction.Axis axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        if (axis == Direction.Axis.Y) {
            float z;
            float x;
            float theta;
            int i;
            builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            builder.m_5483_((double)cx, (double)cy, (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                x = r * Mth.m_14089_((float)theta);
                z = r * Mth.m_14031_((float)theta);
                builder.m_5483_((double)(x + cx), (double)cy, (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
            }
            tessellator.m_85914_();
            if (!isFlat) {
                builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                builder.m_5483_((double)cx, (double)(cy + h), (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    x = r * Mth.m_14089_((float)theta);
                    z = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(x + cx), (double)(cy + h), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                float xp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i2 = 1; i2 <= num_steps360; ++i2) {
                    float theta2 = step * (float)i2;
                    float x2 = r * Mth.m_14089_((float)theta2);
                    float z2 = r * Mth.m_14031_((float)theta2);
                    builder.m_5483_((double)(cx + xp), (double)(cy + 0.0f), (double)(cz + zp)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + xp), (double)(cy + h), (double)(cz + zp)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x2), (double)(cy + h), (double)(cz + z2)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x2), (double)(cy + 0.0f), (double)(cz + z2)).m_85950_(red, grn, blu, alpha).m_5752_();
                    xp = x2;
                    zp = z2;
                }
                tessellator.m_85914_();
            }
        } else if (axis == Direction.Axis.X) {
            float z;
            float y;
            float theta;
            int i;
            builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            builder.m_5483_((double)cx, (double)cy, (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                y = r * Mth.m_14089_((float)theta);
                z = r * Mth.m_14031_((float)theta);
                builder.m_5483_((double)cx, (double)(cy + y), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
            }
            tessellator.m_85914_();
            if (!isFlat) {
                builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                builder.m_5483_((double)(cx + h), (double)cy, (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    y = r * Mth.m_14089_((float)theta);
                    z = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(cx + h), (double)(cy + y), (double)(cz + z)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                float yp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i3 = 1; i3 <= num_steps360; ++i3) {
                    float theta3 = step * (float)i3;
                    float y2 = r * Mth.m_14089_((float)theta3);
                    float z3 = r * Mth.m_14031_((float)theta3);
                    builder.m_5483_((double)(cx + 0.0f), (double)(cy + yp), (double)(cz + zp)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + h), (double)(cy + yp), (double)(cz + zp)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + h), (double)(cy + y2), (double)(cz + z3)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + 0.0f), (double)(cy + y2), (double)(cz + z3)).m_85950_(red, grn, blu, alpha).m_5752_();
                    yp = y2;
                    zp = z3;
                }
                tessellator.m_85914_();
            }
        } else if (axis == Direction.Axis.Z) {
            float y;
            float x;
            float theta;
            int i;
            builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            builder.m_5483_((double)cx, (double)cy, (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                x = r * Mth.m_14089_((float)theta);
                y = r * Mth.m_14031_((float)theta);
                builder.m_5483_((double)(x + cx), (double)(cy + y), (double)cz).m_85950_(red, grn, blu, alpha).m_5752_();
            }
            tessellator.m_85914_();
            if (!isFlat) {
                builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                builder.m_5483_((double)cx, (double)cy, (double)(cz + h)).m_85950_(red, grn, blu, alpha).m_5752_();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    x = r * Mth.m_14089_((float)theta);
                    y = r * Mth.m_14031_((float)theta);
                    builder.m_5483_((double)(x + cx), (double)(cy + y), (double)(cz + h)).m_85950_(red, grn, blu, alpha).m_5752_();
                }
                tessellator.m_85914_();
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                float xp = r;
                float yp = 0.0f;
                for (int i4 = 1; i4 <= num_steps360; ++i4) {
                    float theta4 = step * (float)i4;
                    float x3 = r * Mth.m_14089_((float)theta4);
                    float y3 = r * Mth.m_14031_((float)theta4);
                    builder.m_5483_((double)(cx + xp), (double)(cy + yp), (double)(cz + 0.0f)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + xp), (double)(cy + yp), (double)(cz + h)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x3), (double)(cy + y3), (double)(cz + h)).m_85950_(red, grn, blu, alpha).m_5752_();
                    builder.m_5483_((double)(cx + x3), (double)(cy + y3), (double)(cz + 0.0f)).m_85950_(red, grn, blu, alpha).m_5752_();
                    xp = x3;
                    yp = y3;
                }
                tessellator.m_85914_();
            }
        }
    }

    public static void drawSphereWireframe(Tesselator tessellator, BufferBuilder builder, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float y;
        float z;
        float x;
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        for (int i = 0; i <= num_steps360; ++i) {
            builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            float theta = step * (float)i;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = step * (float)j;
                x = r * Mth.m_14031_((float)phi) * Mth.m_14089_((float)theta);
                z = r * Mth.m_14031_((float)phi) * Mth.m_14031_((float)theta);
                y = r * Mth.m_14089_((float)phi);
                builder.m_5483_((double)(x + cx), (double)(y + cy), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
            }
            tessellator.m_85914_();
        }
        for (int j = 0; j <= num_steps180; ++j) {
            builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            float phi = step * (float)j;
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                x = r * Mth.m_14031_((float)phi) * Mth.m_14089_((float)theta);
                z = r * Mth.m_14031_((float)phi) * Mth.m_14031_((float)theta);
                y = r * Mth.m_14089_((float)phi);
                builder.m_5483_((double)(x + cx), (double)(y + cy), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
            }
            tessellator.m_85914_();
        }
    }

    public static void drawSphereFaces(Tesselator tessellator, BufferBuilder builder, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        for (int i = 0; i <= num_steps360; ++i) {
            float theta = (float)i * step;
            float thetaprime = theta + step;
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float xb = 0.0f;
            float zb = 0.0f;
            float xbp = 0.0f;
            float zbp = 0.0f;
            float yp = r;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = (float)j * step;
                float x = r * Mth.m_14031_((float)phi) * Mth.m_14089_((float)theta);
                float z = r * Mth.m_14031_((float)phi) * Mth.m_14031_((float)theta);
                float y = r * Mth.m_14089_((float)phi);
                float xp = r * Mth.m_14031_((float)phi) * Mth.m_14089_((float)thetaprime);
                float zp = r * Mth.m_14031_((float)phi) * Mth.m_14031_((float)thetaprime);
                builder.m_5483_((double)(xb + cx), (double)(yp + cy), (double)(zb + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                builder.m_5483_((double)(xbp + cx), (double)(yp + cy), (double)(zbp + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                builder.m_5483_((double)(xp + cx), (double)(y + cy), (double)(zp + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                builder.m_5483_((double)(x + cx), (double)(y + cy), (double)(z + cz)).m_85950_(red, grn, blu, alpha).m_5752_();
                xb = x;
                zb = z;
                xbp = xp;
                zbp = zp;
                yp = y;
            }
            tessellator.m_85914_();
        }
    }

    public static abstract class RenderedShape<T extends ShapeDispatcher.ExpiringShape> {
        protected T shape;
        protected Minecraft client;
        long expiryTick;
        double renderEpsilon;

        public abstract void renderLines(PoseStack var1, Tesselator var2, BufferBuilder var3, double var4, double var6, double var8, float var10);

        public void renderFaces(Tesselator tessellator, BufferBuilder builder, double cx, double cy, double cz, float partialTick) {
        }

        protected RenderedShape(Minecraft client, T shape) {
            this.shape = shape;
            this.client = client;
            this.expiryTick = client.f_91073_.m_46467_() + (long)((ShapeDispatcher.ExpiringShape)shape).getExpiry();
            this.renderEpsilon = (3.0 + (double)this.key() / 9.223372036854776E18) / 1000.0;
        }

        public boolean isExpired(long currentTick) {
            return this.expiryTick < currentTick;
        }

        public long key() {
            return ((ShapeDispatcher.ExpiringShape)this.shape).key(this.client.f_91073_.m_9598_());
        }

        public boolean shouldRender(ResourceKey<Level> dim) {
            if (((ShapeDispatcher.ExpiringShape)this.shape).followEntity <= 0) {
                return true;
            }
            if (this.client.f_91073_ == null) {
                return false;
            }
            if (this.client.f_91073_.m_46472_() != dim) {
                return false;
            }
            return this.client.f_91073_.m_6815_(((ShapeDispatcher.ExpiringShape)this.shape).followEntity) != null;
        }

        public boolean stageDeux() {
            return false;
        }

        public void promoteWith(RenderedShape<?> rshape) {
            this.expiryTick = rshape.expiryTick;
        }
    }

    public static class RenderedCylinder
    extends RenderedShape<ShapeDispatcher.Cylinder> {
        public RenderedCylinder(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Cylinder)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).a == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = Mth.m_14205_((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderWireframe(tessellator, bufferBuilder, (float)(vc.f_82479_ - cx - dir * this.renderEpsilon), (float)(vc.f_82480_ - cy - dir * this.renderEpsilon), (float)(vc.f_82481_ - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).r, ((ShapeDispatcher.Cylinder)this.shape).g, ((ShapeDispatcher.Cylinder)this.shape).b, ((ShapeDispatcher.Cylinder)this.shape).a);
        }

        @Override
        public void renderFaces(Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).fa == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = Mth.m_14205_((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderFaces(tessellator, bufferBuilder, (float)(vc.f_82479_ - cx - dir * this.renderEpsilon), (float)(vc.f_82480_ - cy - dir * this.renderEpsilon), (float)(vc.f_82481_ - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).fr, ((ShapeDispatcher.Cylinder)this.shape).fg, ((ShapeDispatcher.Cylinder)this.shape).fb, ((ShapeDispatcher.Cylinder)this.shape).fa);
        }
    }

    public static class RenderedSphere
    extends RenderedShape<ShapeDispatcher.Sphere> {
        public RenderedSphere(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Sphere)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).a == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereWireframe(tessellator, bufferBuilder, (float)(vc.f_82479_ - cx), (float)(vc.f_82480_ - cy), (float)(vc.f_82481_ - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).r, ((ShapeDispatcher.Sphere)this.shape).g, ((ShapeDispatcher.Sphere)this.shape).b, ((ShapeDispatcher.Sphere)this.shape).a);
        }

        @Override
        public void renderFaces(Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).fa == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereFaces(tessellator, bufferBuilder, (float)(vc.f_82479_ - cx), (float)(vc.f_82480_ - cy), (float)(vc.f_82481_ - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).fr, ((ShapeDispatcher.Sphere)this.shape).fg, ((ShapeDispatcher.Sphere)this.shape).fb, ((ShapeDispatcher.Sphere)this.shape).fa);
        }
    }

    public static class RenderedPolyface
    extends RenderedShape<ShapeDispatcher.Polyface> {
        private static final VertexFormat.Mode[] faceIndices = new VertexFormat.Mode[]{VertexFormat.Mode.LINES, VertexFormat.Mode.LINE_STRIP, VertexFormat.Mode.DEBUG_LINES, VertexFormat.Mode.DEBUG_LINE_STRIP, VertexFormat.Mode.TRIANGLES, VertexFormat.Mode.TRIANGLE_STRIP, VertexFormat.Mode.TRIANGLE_FAN, VertexFormat.Mode.QUADS};

        public RenderedPolyface(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Polyface)shape);
        }

        @Override
        public void renderFaces(Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if (((ShapeDispatcher.Polyface)this.shape).fa == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).doublesided) {
                RenderSystem.disableCull();
            } else {
                RenderSystem.enableCull();
            }
            bufferBuilder.m_166779_(faceIndices[((ShapeDispatcher.Polyface)this.shape).mode], DefaultVertexFormat.f_85815_);
            for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                Vec3 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vec, partialTick);
                }
                bufferBuilder.m_5483_(vec.m_7096_() - cx, vec.m_7098_() - cy, vec.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).fr, ((ShapeDispatcher.Polyface)this.shape).fg, ((ShapeDispatcher.Polyface)this.shape).fb, ((ShapeDispatcher.Polyface)this.shape).fa).m_5752_();
            }
            tessellator.m_85914_();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tessellator, BufferBuilder builder, double cx, double cy, double cz, float partialTick) {
            if (((ShapeDispatcher.Polyface)this.shape).a == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 6) {
                Vec3 vec;
                int i;
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                Vec3 vec0 = null;
                for (i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vec, partialTick);
                    }
                    if (i == 0) {
                        vec0 = vec;
                    }
                    builder.m_5483_(vec.m_7096_() - cx, vec.m_7098_() - cy, vec.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                }
                builder.m_5483_(vec0.m_7096_() - cx, vec0.m_7098_() - cy, vec0.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                tessellator.m_85914_();
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                    for (i = 1; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                            vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vec, partialTick);
                        }
                        builder.m_5483_(vec.m_7096_() - cx, vec.m_7098_() - cy, vec.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                        builder.m_5483_(vec0.m_7096_() - cx, vec0.m_7098_() - cy, vec0.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    }
                    tessellator.m_85914_();
                }
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 5) {
                int i;
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                Vec3 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(1);
                if (((ShapeDispatcher.Polyface)this.shape).relative.get(1).booleanValue()) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vec, partialTick);
                }
                builder.m_5483_(vec.m_7096_() - cx, vec.m_7098_() - cy, vec.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                for (i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); i += 2) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vec, partialTick);
                    }
                    builder.m_5483_(vec.m_7096_() - cx, vec.m_7098_() - cy, vec.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                }
                i = ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1;
                i -= 1 - i % 2;
                while (i > 0) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vec, partialTick);
                    }
                    builder.m_5483_(vec.m_7096_() - cx, vec.m_7098_() - cy, vec.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    i -= 2;
                }
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    for (i = 2; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                            vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vec, partialTick);
                        }
                        builder.m_5483_(vec.m_7096_() - cx, vec.m_7098_() - cy, vec.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    }
                }
                tessellator.m_85914_();
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 4) {
                builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    Vec3 vecA = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecA = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vecA, partialTick);
                    }
                    Vec3 vecB = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecB = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vecB, partialTick);
                    }
                    Vec3 vecC = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecC = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.f_91073_, vecC, partialTick);
                    }
                    builder.m_5483_(vecA.m_7096_() - cx, vecA.m_7098_() - cy, vecA.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    builder.m_5483_(vecB.m_7096_() - cx, vecB.m_7098_() - cy, vecB.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    builder.m_5483_(vecB.m_7096_() - cx, vecB.m_7098_() - cy, vecB.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    builder.m_5483_(vecC.m_7096_() - cx, vecC.m_7098_() - cy, vecC.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    builder.m_5483_(vecC.m_7096_() - cx, vecC.m_7098_() - cy, vecC.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                    builder.m_5483_(vecA.m_7096_() - cx, vecA.m_7098_() - cy, vecA.m_7094_() - cz).m_85950_(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).m_5752_();
                }
                tessellator.m_85914_();
            }
        }
    }

    public static class RenderedLine
    extends RenderedShape<ShapeDispatcher.Line> {
        public RenderedLine(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Line)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            Vec3 v1 = ((ShapeDispatcher.Line)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Line)this.shape).from, partialTick);
            Vec3 v2 = ((ShapeDispatcher.Line)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Line)this.shape).to, partialTick);
            ShapesRenderer.drawLine(tessellator, bufferBuilder, (float)(v1.f_82479_ - cx - this.renderEpsilon), (float)(v1.f_82480_ - cy - this.renderEpsilon), (float)(v1.f_82481_ - cz - this.renderEpsilon), (float)(v2.f_82479_ - cx + this.renderEpsilon), (float)(v2.f_82480_ - cy + this.renderEpsilon), (float)(v2.f_82481_ - cz + this.renderEpsilon), ((ShapeDispatcher.Line)this.shape).r, ((ShapeDispatcher.Line)this.shape).g, ((ShapeDispatcher.Line)this.shape).b, ((ShapeDispatcher.Line)this.shape).a);
        }
    }

    public static class RenderedBox
    extends RenderedShape<ShapeDispatcher.Box> {
        private RenderedBox(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Box)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).a == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            Vec3 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxWireGLLines(tessellator, bufferBuilder, (float)(v1.f_82479_ - cx - this.renderEpsilon), (float)(v1.f_82480_ - cy - this.renderEpsilon), (float)(v1.f_82481_ - cz - this.renderEpsilon), (float)(v2.f_82479_ - cx + this.renderEpsilon), (float)(v2.f_82480_ - cy + this.renderEpsilon), (float)(v2.f_82481_ - cz + this.renderEpsilon), v1.f_82479_ != v2.f_82479_, v1.f_82480_ != v2.f_82480_, v1.f_82481_ != v2.f_82481_, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b, ((ShapeDispatcher.Box)this.shape).a, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b);
        }

        @Override
        public void renderFaces(Tesselator tessellator, BufferBuilder bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).fa == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            Vec3 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxFaces(tessellator, bufferBuilder, (float)(v1.f_82479_ - cx - this.renderEpsilon), (float)(v1.f_82480_ - cy - this.renderEpsilon), (float)(v1.f_82481_ - cz - this.renderEpsilon), (float)(v2.f_82479_ - cx + this.renderEpsilon), (float)(v2.f_82480_ - cy + this.renderEpsilon), (float)(v2.f_82481_ - cz + this.renderEpsilon), v1.f_82479_ != v2.f_82479_, v1.f_82480_ != v2.f_82480_, v1.f_82481_ != v2.f_82481_, ((ShapeDispatcher.Box)this.shape).fr, ((ShapeDispatcher.Box)this.shape).fg, ((ShapeDispatcher.Box)this.shape).fb, ((ShapeDispatcher.Box)this.shape).fa);
        }
    }

    public static class RenderedText
    extends RenderedShape<ShapeDispatcher.DisplayedText> {
        protected RenderedText(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.DisplayedText)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tessellator, BufferBuilder builder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.DisplayedText)this.shape).a == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.DisplayedText)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.DisplayedText)this.shape).pos, partialTick);
            Camera camera1 = this.client.f_91063_.m_109153_();
            Font textRenderer = this.client.f_91062_;
            if (((ShapeDispatcher.DisplayedText)this.shape).doublesided) {
                RenderSystem.disableCull();
            } else {
                RenderSystem.enableCull();
            }
            matrices.m_85836_();
            matrices.m_85837_(v1.f_82479_ - cx, v1.f_82480_ - cy, v1.f_82481_ - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedText)this.shape).facing, camera1, v1);
            matrices.m_85841_(((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, -((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, ((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f);
            if (((ShapeDispatcher.DisplayedText)this.shape).tilt != 0.0f) {
                matrices.m_252781_(Axis.f_252403_.m_252977_(((ShapeDispatcher.DisplayedText)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).lean != 0.0f) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(((ShapeDispatcher.DisplayedText)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).turn != 0.0f) {
                matrices.m_252781_(Axis.f_252436_.m_252977_(((ShapeDispatcher.DisplayedText)this.shape).turn));
            }
            matrices.m_85837_((double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).indent), (double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).height - 9.0f), -10.0 * this.renderEpsilon - (double)(10.0f * ((ShapeDispatcher.DisplayedText)this.shape).raise));
            matrices.m_85841_(-1.0f, 1.0f, 1.0f);
            float text_x = 0.0f;
            if (((ShapeDispatcher.DisplayedText)this.shape).align == 0) {
                text_x = (float)(-textRenderer.m_92895_(((ShapeDispatcher.DisplayedText)this.shape).value.getString())) / 2.0f;
            } else if (((ShapeDispatcher.DisplayedText)this.shape).align == 1) {
                text_x = -textRenderer.m_92895_(((ShapeDispatcher.DisplayedText)this.shape).value.getString());
            }
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)builder);
            textRenderer.m_272077_(((ShapeDispatcher.DisplayedText)this.shape).value, text_x, 0.0f, ((ShapeDispatcher.DisplayedText)this.shape).textcolor, false, matrices.m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, ((ShapeDispatcher.DisplayedText)this.shape).textbck, 0xF000F0);
            immediate.m_109911_();
            matrices.m_85849_();
            RenderSystem.enableCull();
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        @Override
        public void promoteWith(RenderedShape<?> rshape) {
            super.promoteWith(rshape);
            try {
                ((ShapeDispatcher.DisplayedText)this.shape).value = ((ShapeDispatcher.DisplayedText)rshape.shape).value;
            }
            catch (ClassCastException ignored) {
                CarpetScriptServer.LOG.error("shape " + String.valueOf(rshape.shape.getClass()) + " cannot cast to a Label");
            }
        }
    }

    public static class RenderedSprite
    extends RenderedShape<ShapeDispatcher.DisplayedSprite> {
        private final boolean isitem;
        private ItemDisplayContext transformType = ItemDisplayContext.NONE;
        private BlockPos blockPos;
        private BlockState blockState;
        private BlockEntity BlockEntity = null;

        protected RenderedSprite(Minecraft client, ShapeDispatcher.ExpiringShape shape, boolean isitem) {
            super(client, (ShapeDispatcher.DisplayedSprite)shape);
            this.isitem = isitem;
            if (isitem) {
                this.transformType = ItemDisplayContext.valueOf((String)((ShapeDispatcher.DisplayedSprite)shape).itemTransformType.toUpperCase(Locale.ROOT));
            }
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tessellator, BufferBuilder builder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.DisplayedSprite)this.shape).a == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.DisplayedSprite)this.shape).relativiseRender((Level)this.client.f_91073_, ((ShapeDispatcher.DisplayedSprite)this.shape).pos, partialTick);
            Camera camera1 = this.client.f_91063_.m_109153_();
            matrices.m_85836_();
            if (!this.isitem) {
                matrices.m_85837_(0.5, 0.5, 0.5);
            }
            matrices.m_85837_(v1.f_82479_ - cx, v1.f_82480_ - cy, v1.f_82481_ - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedSprite)this.shape).facing, camera1, this.isitem ? v1 : v1.m_82520_(0.5, 0.5, 0.5));
            if (((ShapeDispatcher.DisplayedSprite)this.shape).tilt != 0.0f) {
                matrices.m_252781_(Axis.f_252403_.m_252977_(-((ShapeDispatcher.DisplayedSprite)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).lean != 0.0f) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(-((ShapeDispatcher.DisplayedSprite)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).turn != 0.0f) {
                matrices.m_252781_(Axis.f_252436_.m_252977_(((ShapeDispatcher.DisplayedSprite)this.shape).turn));
            }
            matrices.m_85841_(((ShapeDispatcher.DisplayedSprite)this.shape).scaleX, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleY, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleZ);
            if (!this.isitem) {
                matrices.m_85837_(-0.5, -0.5, -0.5);
            } else {
                matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            this.blockPos = BlockPos.m_274446_((Position)v1);
            int light = 0;
            if (this.client.f_91073_ != null) {
                light = LightTexture.m_109885_((int)(((ShapeDispatcher.DisplayedSprite)this.shape).blockLight < 0 ? this.client.f_91073_.m_45517_(LightLayer.BLOCK, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).blockLight), (int)(((ShapeDispatcher.DisplayedSprite)this.shape).skyLight < 0 ? this.client.f_91073_.m_45517_(LightLayer.SKY, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).skyLight));
            }
            this.blockState = ((ShapeDispatcher.DisplayedSprite)this.shape).blockState;
            MultiBufferSource.BufferSource immediate = this.client.m_91269_().m_110104_();
            if (!this.isitem) {
                BlockEntityRenderer blockEntityRenderer;
                BlockEntity color22;
                Block color22;
                if (this.blockState.m_60799_() == RenderShape.MODEL) {
                    BakedModel bakedModel = this.client.m_91289_().m_110910_(this.blockState);
                    int color22 = this.client.m_91298_().m_92577_(this.blockState, (BlockAndTintGetter)this.client.f_91073_, this.blockPos, 0);
                    float red = (float)(color22 >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color22 >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color22 & 0xFF) / 255.0f;
                    this.client.m_91289_().m_110937_().m_111067_(matrices.m_85850_(), immediate.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)this.blockState, (boolean)false)), this.blockState, bakedModel, red, green, blue, light, OverlayTexture.f_118083_);
                }
                if (this.BlockEntity == null && (color22 = this.blockState.m_60734_()) instanceof EntityBlock) {
                    EntityBlock eb = (EntityBlock)color22;
                    this.BlockEntity = eb.m_142194_(this.blockPos, this.blockState);
                    if (this.BlockEntity != null) {
                        this.BlockEntity.m_142339_((Level)this.client.f_91073_);
                        if (((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity != null) {
                            this.BlockEntity.m_142466_(((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity);
                        }
                    }
                }
                if ((color22 = this.BlockEntity) instanceof ShulkerBoxBlockEntity) {
                    ShulkerBoxBlockEntity sbBlockEntity = (ShulkerBoxBlockEntity)color22;
                    this.sbrender(sbBlockEntity, partialTick, matrices, (MultiBufferSource)immediate, light, OverlayTexture.f_118083_);
                } else if (this.BlockEntity != null && (blockEntityRenderer = this.client.m_167982_().m_112265_(this.BlockEntity)) != null) {
                    blockEntityRenderer.m_6922_(this.BlockEntity, partialTick, matrices, (MultiBufferSource)immediate, light, OverlayTexture.f_118083_);
                }
            } else if (((ShapeDispatcher.DisplayedSprite)this.shape).item != null) {
                this.client.m_91291_().m_269128_(((ShapeDispatcher.DisplayedSprite)this.shape).item, this.transformType, light, OverlayTexture.f_118083_, matrices, (MultiBufferSource)immediate, (Level)this.client.f_91073_, (int)((ShapeDispatcher.DisplayedSprite)this.shape).key(this.client.f_91073_.m_9598_()));
            }
            matrices.m_85849_();
            immediate.m_109911_();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        public void sbrender(ShulkerBoxBlockEntity shulkerBoxBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
            DyeColor dyeColor;
            BlockState blockState;
            Direction direction = Direction.UP;
            if (shulkerBoxBlockEntity.m_58898_() && (blockState = shulkerBoxBlockEntity.m_58900_()).m_60734_() instanceof ShulkerBoxBlock) {
                direction = (Direction)blockState.m_61143_((Property)ShulkerBoxBlock.f_56183_);
            }
            Material material = (dyeColor = shulkerBoxBlockEntity.m_59701_()) == null ? Sheets.f_110741_ : (Material)Sheets.f_110742_.get(dyeColor.m_41060_());
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85841_(0.9995f, 0.9995f, 0.9995f);
            poseStack.m_252781_(direction.m_253075_());
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            poseStack.m_85837_(0.0, -1.0, 0.0);
            ShulkerModel<?> model = VanillaClient.ShulkerBoxRenderer_model((BlockEntityRenderer<ShulkerBoxBlockEntity>)this.client.m_167982_().m_112265_((BlockEntity)shulkerBoxBlockEntity));
            ModelPart modelPart = model.m_103742_();
            modelPart.m_104227_(0.0f, 24.0f - shulkerBoxBlockEntity.m_59657_(f) * 0.5f * 16.0f, 0.0f);
            modelPart.f_104204_ = 270.0f * shulkerBoxBlockEntity.m_59657_(f) * ((float)Math.PI / 180);
            VertexConsumer vertexConsumer = material.m_119194_(multiBufferSource, RenderType::m_110458_);
            model.m_7695_(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }
}

