/*
 * Decompiled with CFR 0.152.
 */
package carpet.patches;

import carpet.CarpetSettings;
import carpet.fakes.ServerPlayerInterface;
import carpet.patches.FakeClientConnection;
import carpet.utils.Messenger;
import com.mojang.authlib.GameProfile;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityPlayerMPFake
extends ServerPlayer {
    public Runnable fixStartingPosition = () -> {};
    public boolean isAShadow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityPlayerMPFake createFake(String username, MinecraftServer server, Vec3 pos, double yaw, double pitch, ResourceKey<Level> dimensionId, GameType gamemode, boolean flying) {
        GameProfile gameprofile;
        ServerLevel worldIn = server.m_129880_(dimensionId);
        GameProfileCache.m_11004_((boolean)false);
        try {
            gameprofile = server.m_129927_().m_10996_(username).orElse(null);
        }
        catch (Throwable throwable) {
            GameProfileCache.m_11004_((server.m_6982_() && server.m_129797_() ? 1 : 0) != 0);
            throw throwable;
        }
        GameProfileCache.m_11004_((server.m_6982_() && server.m_129797_() ? 1 : 0) != 0);
        if (gameprofile == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                return null;
            }
            gameprofile = new GameProfile(UUIDUtil.m_235879_((String)username), username);
        }
        if (gameprofile.getProperties().containsKey((Object)"textures")) {
            AtomicReference result = new AtomicReference();
            SkullBlockEntity.m_155738_((GameProfile)gameprofile, result::set);
            gameprofile = (GameProfile)result.get();
        }
        EntityPlayerMPFake instance = new EntityPlayerMPFake(server, worldIn, gameprofile, false);
        instance.fixStartingPosition = () -> instance.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)yaw, (float)pitch);
        server.m_6846_().m_11261_((Connection)new FakeClientConnection(PacketFlow.SERVERBOUND), (ServerPlayer)instance);
        instance.m_8999_(worldIn, pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)yaw, (float)pitch);
        instance.m_21153_(20.0f);
        instance.m_146912_();
        instance.m_274367_(0.6f);
        instance.f_8941_.m_143473_(gamemode);
        server.m_6846_().m_11270_((Packet)new ClientboundRotateHeadPacket((Entity)instance, (byte)(instance.f_20885_ * 256.0f / 360.0f)), dimensionId);
        server.m_6846_().m_11270_((Packet)new ClientboundTeleportEntityPacket((Entity)instance), dimensionId);
        instance.f_19804_.m_135381_(f_36089_, (Object)127);
        instance.m_150110_().f_35935_ = flying;
        return instance;
    }

    public static EntityPlayerMPFake createShadow(MinecraftServer server, ServerPlayer player) {
        player.m_20194_().m_6846_().m_11286_(player);
        player.f_8906_.m_9942_((Component)Component.m_237115_((String)"multiplayer.disconnect.duplicate_login"));
        ServerLevel worldIn = player.m_284548_();
        GameProfile gameprofile = player.m_36316_();
        EntityPlayerMPFake playerShadow = new EntityPlayerMPFake(server, worldIn, gameprofile, true);
        playerShadow.m_252981_(player.m_246404_());
        server.m_6846_().m_11261_((Connection)new FakeClientConnection(PacketFlow.SERVERBOUND), (ServerPlayer)playerShadow);
        playerShadow.m_21153_(player.m_21223_());
        playerShadow.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        playerShadow.f_8941_.m_143473_(player.f_8941_.m_9290_());
        ((ServerPlayerInterface)((Object)playerShadow)).getActionPack().copyFrom(((ServerPlayerInterface)player).getActionPack());
        playerShadow.m_274367_(0.6f);
        playerShadow.f_19804_.m_135381_(f_36089_, (Object)((Byte)player.m_20088_().m_135370_(f_36089_)));
        server.m_6846_().m_11270_((Packet)new ClientboundRotateHeadPacket((Entity)playerShadow, (byte)(player.f_20885_ * 256.0f / 360.0f)), playerShadow.m_9236_().m_46472_());
        server.m_6846_().m_11268_((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)playerShadow));
        playerShadow.m_150110_().f_35935_ = player.m_150110_().f_35935_;
        return playerShadow;
    }

    public static EntityPlayerMPFake respawnFake(MinecraftServer server, ServerLevel level, GameProfile profile) {
        return new EntityPlayerMPFake(server, level, profile, false);
    }

    private EntityPlayerMPFake(MinecraftServer server, ServerLevel worldIn, GameProfile profile, boolean shadow) {
        super(server, worldIn, profile);
        this.isAShadow = shadow;
    }

    public void m_238392_(EquipmentSlot slot, ItemStack previous, ItemStack stack) {
        if (!this.m_6117_()) {
            super.m_238392_(slot, previous, stack);
        }
    }

    public void m_6074_() {
        this.kill(Messenger.s("Killed"));
    }

    public void kill(Component reason) {
        TranslatableContents text;
        this.shakeOff();
        ComponentContents componentContents = reason.m_214077_();
        if (componentContents instanceof TranslatableContents && (text = (TranslatableContents)componentContents).m_237508_().equals("multiplayer.disconnect.duplicate_login")) {
            this.f_8906_.m_7026_(reason);
        } else {
            this.f_8924_.m_6937_((Runnable)new TickTask(this.f_8924_.m_129921_(), () -> this.f_8906_.m_7026_(reason)));
        }
    }

    public void m_8119_() {
        if (this.m_20194_().m_129921_() % 10 == 0) {
            this.f_8906_.m_9953_();
            this.m_284548_().m_7726_().m_8385_((ServerPlayer)this);
        }
        try {
            super.m_8119_();
            this.m_9240_();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void shakeOff() {
        if (this.m_20202_() instanceof Player) {
            this.m_8127_();
        }
        for (Entity passenger : this.m_146897_()) {
            if (!(passenger instanceof Player)) continue;
            passenger.m_8127_();
        }
    }

    public void m_6667_(DamageSource cause) {
        this.shakeOff();
        super.m_6667_(cause);
        this.m_21153_(20.0f);
        this.f_36097_ = new FoodData();
        this.kill(this.m_21231_().m_19293_());
    }

    public String m_9239_() {
        return "127.0.0.1";
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.m_289599_(0.0, y, 0.0, onGround);
    }

    public Entity m_5489_(ServerLevel serverLevel) {
        super.m_5489_(serverLevel);
        if (this.f_8944_) {
            ServerboundClientCommandPacket p = new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN);
            this.f_8906_.m_6272_(p);
        }
        if (this.f_8906_.f_9743_.m_8958_()) {
            this.f_8906_.f_9743_.m_8959_();
        }
        return this.f_8906_.f_9743_;
    }
}

