/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.SettingsManager;
import carpet.fakes.MinecraftServerInterface;
import carpet.fakes.ServerGamePacketListenerImplInterface;
import carpet.helpers.ServerTickRateManager;
import carpet.network.CarpetClient;
import carpet.script.utils.SnoopyCommandSource;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class ServerNetworkHandler {
    private static final Map<ServerPlayer, String> remoteCarpetPlayers = new HashMap<ServerPlayer, String>();
    private static final Set<ServerPlayer> validCarpetPlayers = new HashSet<ServerPlayer>();
    private static final Map<String, BiConsumer<ServerPlayer, Tag>> dataHandlers = Map.of("clientCommand", (p, t) -> ServerNetworkHandler.handleClientCommand(p, (CompoundTag)t));

    public static void handleData(FriendlyByteBuf data, ServerPlayer player) {
        if (data != null) {
            int id = data.m_130242_();
            if (id == 420) {
                ServerNetworkHandler.onHello(player, data);
            }
            if (id == 1) {
                ServerNetworkHandler.onClientData(player, data);
            }
        }
    }

    public static void onPlayerJoin(ServerPlayer playerEntity) {
        if (!((ServerGamePacketListenerImplInterface)playerEntity.f_8906_).getConnection().m_129531_()) {
            playerEntity.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, new FriendlyByteBuf(Unpooled.buffer()).m_130130_(69).m_130070_(CarpetSettings.carpetVersion)));
        } else {
            validCarpetPlayers.add(playerEntity);
        }
    }

    public static void onHello(ServerPlayer playerEntity, FriendlyByteBuf packetData) {
        validCarpetPlayers.add(playerEntity);
        String clientVersion = packetData.m_130136_(64);
        remoteCarpetPlayers.put(playerEntity, clientVersion);
        if (clientVersion.equals(CarpetSettings.carpetVersion)) {
            CarpetSettings.LOG.info("Player " + playerEntity.m_7755_().getString() + " joined with a matching carpet client");
        } else {
            CarpetSettings.LOG.warn("Player " + playerEntity.m_7755_().getString() + " joined with another carpet version: " + clientVersion);
        }
        DataBuilder data = DataBuilder.create(playerEntity.f_8924_);
        CarpetServer.settingsManager.getCarpetRules().forEach(data::withRule);
        CarpetServer.extensions.forEach(e -> {
            SettingsManager eManager = e.extensionSettingsManager();
            if (eManager != null) {
                eManager.getCarpetRules().forEach(data::withRule);
            }
        });
        playerEntity.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, data.build()));
    }

    public static void sendPlayerLevelData(ServerPlayer player, ServerLevel level) {
        DataBuilder data = DataBuilder.create(player.f_8924_).withTickRate().withFrozenState().withTickPlayerActiveTimeout();
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, data.build()));
    }

    private static void handleClientCommand(ServerPlayer player, CompoundTag commandData) {
        String command = commandData.m_128461_("command");
        String id = commandData.m_128461_("id");
        ArrayList<Component> output = new ArrayList<Component>();
        Component[] error = new Component[]{null};
        int resultCode = -1;
        if (player.m_20194_() == null) {
            error[0] = Component.m_237113_((String)"No Server");
        } else {
            resultCode = player.m_20194_().m_129892_().m_230957_((CommandSourceStack)new SnoopyCommandSource(player, error, output), command);
        }
        CompoundTag result = new CompoundTag();
        result.m_128359_("id", id);
        result.m_128405_("code", resultCode);
        if (error[0] != null) {
            result.m_128359_("error", error[0].m_214077_().toString());
        }
        ListTag outputResult = new ListTag();
        for (Component line : output) {
            outputResult.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)line)));
        }
        if (!output.isEmpty()) {
            result.m_128365_("output", (Tag)outputResult);
        }
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withCustomNbt("clientCommand", (Tag)result).build()));
    }

    private static void onClientData(ServerPlayer player, FriendlyByteBuf data) {
        CompoundTag compound = data.m_130260_();
        if (compound == null) {
            return;
        }
        for (String key : compound.m_128431_()) {
            if (dataHandlers.containsKey(key)) {
                dataHandlers.get(key).accept(player, compound.m_128423_(key));
                continue;
            }
            CarpetSettings.LOG.warn("Unknown carpet client data: " + key);
        }
    }

    public static void updateRuleWithConnectedClients(CarpetRule<?> rule) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : remoteCarpetPlayers.keySet()) {
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withRule(rule).build()));
        }
    }

    public static void updateTickSpeedToConnectedPlayers(MinecraftServer server) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : validCarpetPlayers) {
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withTickRate().build()));
        }
    }

    public static void updateFrozenStateToConnectedPlayers(MinecraftServer server) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : validCarpetPlayers) {
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withFrozenState().build()));
        }
    }

    public static void updateSuperHotStateToConnectedPlayers(MinecraftServer server) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : validCarpetPlayers) {
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withSuperHotState().build()));
        }
    }

    public static void updateTickPlayerActiveTimeoutToConnectedPlayers(MinecraftServer server) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : validCarpetPlayers) {
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withTickPlayerActiveTimeout().build()));
        }
    }

    public static void broadcastCustomCommand(String command, Tag data) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : validCarpetPlayers) {
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withCustomNbt(command, data).build()));
        }
    }

    public static void sendCustomCommand(ServerPlayer player, String command, Tag data) {
        if (ServerNetworkHandler.isValidCarpetPlayer(player)) {
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, DataBuilder.create(player.f_8924_).withCustomNbt(command, data).build()));
        }
    }

    public static void onPlayerLoggedOut(ServerPlayer player) {
        validCarpetPlayers.remove(player);
        if (!((ServerGamePacketListenerImplInterface)player.f_8906_).getConnection().m_129531_()) {
            remoteCarpetPlayers.remove(player);
        }
    }

    public static void close() {
        remoteCarpetPlayers.clear();
        validCarpetPlayers.clear();
    }

    public static boolean isValidCarpetPlayer(ServerPlayer player) {
        if (CarpetSettings.superSecretSetting) {
            return false;
        }
        return validCarpetPlayers.contains(player);
    }

    public static String getPlayerStatus(ServerPlayer player) {
        if (remoteCarpetPlayers.containsKey(player)) {
            return "carpet " + remoteCarpetPlayers.get(player);
        }
        if (validCarpetPlayers.contains(player)) {
            return "carpet " + CarpetSettings.carpetVersion;
        }
        return "vanilla";
    }

    private static class DataBuilder {
        private CompoundTag tag = new CompoundTag();
        private MinecraftServer server;

        private static DataBuilder create(MinecraftServer server) {
            return new DataBuilder(server);
        }

        private DataBuilder(MinecraftServer server) {
            this.server = server;
        }

        private DataBuilder withTickRate() {
            ServerTickRateManager trm = ((MinecraftServerInterface)this.server).getTickRateManager();
            this.tag.m_128350_("TickRate", trm.tickrate());
            return this;
        }

        private DataBuilder withFrozenState() {
            ServerTickRateManager trm = ((MinecraftServerInterface)this.server).getTickRateManager();
            CompoundTag tickingState = new CompoundTag();
            tickingState.m_128379_("is_paused", trm.gameIsPaused());
            tickingState.m_128379_("deepFreeze", trm.deeplyFrozen());
            this.tag.m_128365_("TickingState", (Tag)tickingState);
            return this;
        }

        private DataBuilder withSuperHotState() {
            ServerTickRateManager trm = ((MinecraftServerInterface)this.server).getTickRateManager();
            this.tag.m_128379_("SuperHotState", trm.isSuperHot());
            return this;
        }

        private DataBuilder withTickPlayerActiveTimeout() {
            ServerTickRateManager trm = ((MinecraftServerInterface)this.server).getTickRateManager();
            this.tag.m_128405_("TickPlayerActiveTimeout", trm.getPlayerActiveTimeout());
            return this;
        }

        private DataBuilder withRule(CarpetRule<?> rule) {
            CompoundTag rules = (CompoundTag)this.tag.m_128423_("Rules");
            if (rules == null) {
                rules = new CompoundTag();
                this.tag.m_128365_("Rules", (Tag)rules);
            }
            String identifier = rule.settingsManager().identifier();
            Object key = rule.name();
            while (rules.m_128441_((String)key)) {
                key = (String)key + "2";
            }
            CompoundTag ruleNBT = new CompoundTag();
            ruleNBT.m_128359_("Value", RuleHelper.toRuleString(rule.value()));
            ruleNBT.m_128359_("Manager", identifier);
            ruleNBT.m_128359_("Rule", rule.name());
            rules.m_128365_((String)key, (Tag)ruleNBT);
            return this;
        }

        public DataBuilder withCustomNbt(String key, Tag value) {
            this.tag.m_128365_(key, value);
            return this;
        }

        private FriendlyByteBuf build() {
            FriendlyByteBuf packetBuf = new FriendlyByteBuf(Unpooled.buffer());
            packetBuf.m_130130_(1);
            packetBuf.m_130079_(this.tag);
            return packetBuf;
        }
    }
}

