/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.EntityInterface;
import carpet.fakes.ServerPlayerInterface;
import carpet.script.CarpetEventServer;
import carpet.script.EntityEventsGroup;
import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayer_scarpetEventMixin
extends Player
implements ServerPlayerInterface {
    @Unique
    private boolean isInvalidReference = false;
    @Shadow
    public boolean f_8944_;
    private Vec3 previousLocation;
    private ResourceKey<Level> previousDimension;

    public ServerPlayer_scarpetEventMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Redirect(method={"completeUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;completeUsingItem()V"))
    private void finishedUsingItem(Player playerEntity) {
        if (CarpetEventServer.Event.PLAYER_FINISHED_USING_ITEM.isNeeded()) {
            InteractionHand hand = this.m_7655_();
            if (!CarpetEventServer.Event.PLAYER_FINISHED_USING_ITEM.onItemAction((ServerPlayer)this, hand, this.m_21211_())) {
                super.m_8095_();
            }
        } else {
            super.m_8095_();
        }
    }

    @Inject(method={"awardStat"}, at={@At(value="HEAD")})
    private void grabStat(Stat<?> stat, int amount, CallbackInfo ci) {
        CarpetEventServer.Event.STATISTICS.onPlayerStatistic((ServerPlayer)this, stat, amount);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void onDeathEvent(DamageSource source, CallbackInfo ci) {
        ((EntityInterface)((Object)this)).getEventContainer().onEvent(EntityEventsGroup.Event.ON_DEATH, source.m_19385_());
        if (CarpetEventServer.Event.PLAYER_DIES.isNeeded()) {
            CarpetEventServer.Event.PLAYER_DIES.onPlayerEvent((ServerPlayer)this);
        }
    }

    @Redirect(method={"setPlayerInput"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setShiftKeyDown(Z)V"))
    private void setSneakingConditionally(ServerPlayer serverPlayerEntity, boolean sneaking) {
        if (!((EntityInterface)serverPlayerEntity.m_20202_()).isPermanentVehicle()) {
            serverPlayerEntity.m_20260_(sneaking);
        }
    }

    @Inject(method={"changeDimension"}, at={@At(value="HEAD")}, remap=false)
    private void logPreviousCoordinates(ServerLevel serverWorld, ITeleporter teleporter, CallbackInfoReturnable<Entity> cir) {
        this.previousLocation = this.m_20182_();
        this.previousDimension = this.m_9236_().m_46472_();
    }

    @Inject(method={"changeDimension"}, at={@At(value="RETURN")}, remap=false)
    private void atChangeDimension(ServerLevel destination, ITeleporter teleporter, CallbackInfoReturnable<Entity> cir) {
        if (CarpetEventServer.Event.PLAYER_CHANGES_DIMENSION.isNeeded()) {
            ServerPlayer player = (ServerPlayer)this;
            Vec3 to = null;
            if (!this.f_8944_ || this.previousDimension != Level.f_46430_ || destination.m_46472_() != Level.f_46428_) {
                to = this.m_20182_();
            }
            CarpetEventServer.Event.PLAYER_CHANGES_DIMENSION.onDimensionChange(player, this.previousLocation, to, this.previousDimension, (ResourceKey<Level>)destination.m_46472_());
        }
    }

    @Override
    public void invalidateEntityObjectReference() {
        this.isInvalidReference = true;
    }

    @Override
    public boolean isInvalidEntityObject() {
        return this.isInvalidReference;
    }
}

