/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.MinecraftServerInterface;
import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.helpers.ServerTickRateManager;
import carpet.utils.CarpetProfiler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
public abstract class ServerChunkCache_tickMixin {
    @Shadow
    @Final
    ServerLevel f_8329_;
    @Shadow
    @Final
    public ChunkMap f_8325_;
    CarpetProfiler.ProfilerToken currentSection;

    @Inject(method={"tickChunks"}, at={@At(value="HEAD")})
    private void startSpawningSection(CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section((Level)this.f_8329_, "Spawning", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickChunks"}, at={@At(value="FIELD", target="net/minecraft/server/level/ServerChunkCache.level:Lnet/minecraft/server/level/ServerLevel;", ordinal=10)})
    private void skipChunkTicking(CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
        }
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE", target="net/minecraft/server/level/ServerLevel.tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V", shift=At.Shift.AFTER)})
    private void resumeSpawningSection(CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section((Level)this.f_8329_, "Spawning", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickChunks"}, at={@At(value="RETURN")})
    private void stopSpawningSection(CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
        }
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isDebug()Z"))
    private boolean skipChunkTicking(ServerLevel serverWorld) {
        boolean debug = serverWorld.m_46659_();
        if (!((MinecraftServerInterface)serverWorld.m_7654_()).getTickRateManager().runsNormally()) {
            if (!debug) {
                ArrayList holders = Lists.newArrayList(((ThreadedAnvilChunkStorageInterface)this.f_8325_).getChunksCM());
                Collections.shuffle(holders);
                for (ChunkHolder holder : holders) {
                    Optional optional = holder.m_140026_().getNow(ChunkHolder.f_139997_).left();
                    if (!optional.isPresent()) continue;
                    holder.m_140054_((LevelChunk)optional.get());
                }
            }
            return true;
        }
        return debug;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;purgeStaleTickets()V"))
    private void pauseTicketSystem(DistanceManager distanceManager) {
        ServerTickRateManager trm = ((MinecraftServerInterface)this.f_8329_.m_7654_()).getTickRateManager();
        if (!trm.runsNormally() && trm.deeplyFrozen()) {
            return;
        }
        distanceManager.m_140776_();
    }
}

