/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.RedstoneWireBlockInterface;
import carpet.helpers.RedstoneWireTurbo;
import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RedStoneWireBlock.class})
public abstract class RedstoneWireBlock_fastMixin
implements RedstoneWireBlockInterface {
    private RedstoneWireTurbo wireTurbo = null;

    @Shadow
    private void m_55530_(Level world_1, BlockPos blockPos_1, BlockState blockState_1) {
    }

    @Shadow
    private int m_55527_(Level world, BlockPos pos) {
        return 0;
    }

    @Override
    @Accessor(value="shouldSignal")
    public abstract void setWiresGivePower(boolean var1);

    @Override
    @Accessor(value="shouldSignal")
    public abstract boolean getWiresGivePower();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onRedstoneWireBlockCTOR(BlockBehaviour.Properties settings, CallbackInfo ci) {
        this.wireTurbo = new RedstoneWireTurbo((RedStoneWireBlock)this);
    }

    public void fastUpdate(Level world, BlockPos pos, BlockState state, BlockPos source) {
        if (CarpetSettings.fastRedstoneDust) {
            this.wireTurbo.updateSurroundingRedstone(world, pos, state, source);
            return;
        }
        this.m_55530_(world, pos, state);
    }

    @Inject(method={"updatePowerStrength"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateLogicAlternative(Level world, BlockPos pos, BlockState state, CallbackInfo cir) {
        if (CarpetSettings.fastRedstoneDust) {
            this.updateLogicPublic(world, pos, state);
            cir.cancel();
        }
    }

    @Override
    public BlockState updateLogicPublic(Level world_1, BlockPos blockPos_1, BlockState blockState_1) {
        int i = this.m_55527_(world_1, blockPos_1);
        BlockState blockState = blockState_1;
        if ((Integer)blockState_1.m_61143_((Property)RedStoneWireBlock.f_55500_) != i) {
            blockState_1 = (BlockState)blockState_1.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(i));
            if (world_1.m_8055_(blockPos_1) == blockState && world_1.m_7731_(blockPos_1, blockState_1, 18)) {
                this.wireTurbo.updateNeighborShapes(world_1, blockPos_1, blockState_1);
            }
            if (!CarpetSettings.fastRedstoneDust) {
                HashSet set = Sets.newHashSet();
                set.add(blockPos_1);
                for (Direction direction : Direction.values()) {
                    set.add(blockPos_1.m_121945_(direction));
                }
                for (BlockPos blockPos : set) {
                    world_1.m_46672_(blockPos, blockState_1.m_60734_());
                }
            }
        }
        return blockState_1;
    }

    @Redirect(method={"onPlace"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    private void redirectOnBlockAddedUpdate(RedStoneWireBlock self, Level world_1, BlockPos blockPos_1, BlockState blockState_1) {
        this.fastUpdate(world_1, blockPos_1, blockState_1, null);
    }

    @Redirect(method={"onRemove"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    private void redirectOnStateReplacedUpdate(RedStoneWireBlock self, Level world_1, BlockPos blockPos_1, BlockState blockState_1) {
        this.fastUpdate(world_1, blockPos_1, blockState_1, null);
    }

    @Redirect(method={"neighborChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    private void redirectNeighborUpdateUpdate(RedStoneWireBlock self, Level world_1, BlockPos blockPos_1, BlockState blockState_1, BlockState blockState_2, Level world_2, BlockPos blockPos_2, Block block_1, BlockPos blockPos_3, boolean boolean_1) {
        this.fastUpdate(world_1, blockPos_1, blockState_1, blockPos_3);
    }
}

