/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.LevelInterface;
import carpet.helpers.TickRateManager;
import carpet.utils.CarpetProfiler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.redstone.NeighborUpdater;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
public abstract class Level_tickMixin
implements LevelInterface {
    @Shadow
    @Final
    public boolean f_46443_;
    @Shadow
    @Final
    protected NeighborUpdater f_220350_;
    CarpetProfiler.ProfilerToken currentSection;
    CarpetProfiler.ProfilerToken entitySection;
    Map<EntityType<?>, Entity> precookedMobs = new HashMap();

    @Override
    @Unique
    public NeighborUpdater getNeighborUpdater() {
        return this.f_220350_;
    }

    @Override
    public Map<EntityType<?>, Entity> getPrecookedMobs() {
        return this.precookedMobs;
    }

    @Inject(method={"tickBlockEntities"}, at={@At(value="HEAD")})
    private void startBlockEntities(CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section((Level)this, "Block Entities", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickBlockEntities"}, at={@At(value="TAIL")})
    private void endBlockEntities(CallbackInfo ci) {
        CarpetProfiler.end_current_section(this.currentSection);
    }

    @Inject(method={"guardEntityTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void startEntity(Consumer<Entity> consumer_1, Entity e, CallbackInfo ci) {
        TickRateManager trm = this.tickRateManager();
        if (!trm.shouldEntityTick(e)) {
            ci.cancel();
        }
        this.entitySection = CarpetProfiler.start_entity_section((Level)this, e, CarpetProfiler.TYPE.ENTITY);
    }

    @Inject(method={"guardEntityTick"}, at={@At(value="TAIL")})
    private void endEntity(Consumer<Entity> call, Entity e, CallbackInfo ci) {
        CarpetProfiler.end_current_entity_section(this.entitySection);
    }
}

