/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.ItemEntityInterface;
import carpet.helpers.InventoryHelper;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements ItemEntityInterface {
    @Shadow
    private int f_31985_;
    @Shadow
    private int f_31986_;

    public ItemEntityMixin(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
        if (CarpetSettings.lightningKillsDropsFix) {
            if (this.f_31985_ > 8) {
                super.m_8038_(world, lightning);
            }
        } else {
            super.m_8038_(world, lightning);
        }
    }

    @Override
    public int getPickupDelayCM() {
        return this.f_31986_;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void removeEmptyShulkerBoxTags(Level worldIn, double x, double y, double z, ItemStack stack, CallbackInfo ci) {
        BlockItem bi;
        Item item;
        if (CarpetSettings.shulkerBoxStackSize > 1 && (item = stack.m_41720_()) instanceof BlockItem && (bi = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) {
            InventoryHelper.cleanUpShulkerBoxTag(stack);
        }
    }

    @Redirect(method={"isMergable()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I"))
    private int getItemStackMaxAmount(ItemStack stack) {
        if (CarpetSettings.shulkerBoxStackSize > 1 && stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof ShulkerBoxBlock) {
            return CarpetSettings.shulkerBoxStackSize;
        }
        return stack.m_41741_();
    }

    @Inject(method={"tryToMerge(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryStackShulkerBoxes(ItemEntity other, CallbackInfo ci) {
        BlockItem bi;
        Item item;
        ItemEntity self = (ItemEntity)this;
        ItemStack selfStack = self.m_32055_();
        if (CarpetSettings.shulkerBoxStackSize == 1 || !((item = selfStack.m_41720_()) instanceof BlockItem) || !((bi = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock)) {
            return;
        }
        ItemStack otherStack = other.m_32055_();
        if (selfStack.m_41720_() == otherStack.m_41720_() && !InventoryHelper.shulkerBoxHasItems(selfStack) && !InventoryHelper.shulkerBoxHasItems(otherStack) && Objects.equals(selfStack.m_41783_(), otherStack.m_41783_()) && selfStack.m_41613_() != CarpetSettings.shulkerBoxStackSize) {
            int amount = Math.min(otherStack.m_41613_(), CarpetSettings.shulkerBoxStackSize - selfStack.m_41613_());
            selfStack.m_41769_(amount);
            self.m_32045_(selfStack);
            this.f_31986_ = Math.max(((ItemEntityInterface)other).getPickupDelayCM(), this.f_31986_);
            this.f_31985_ = Math.min(other.m_32059_(), this.f_31985_);
            otherStack.m_41774_(amount);
            if (otherStack.m_41619_()) {
                other.m_146870_();
            } else {
                other.m_32045_(otherStack);
            }
            ci.cancel();
        }
    }
}

