/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.MinecraftServerInterface;
import carpet.helpers.ServerTickRateManager;
import carpet.network.ServerNetworkHandler;
import carpet.utils.CarpetProfiler;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TickCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tick").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandTick))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"rate").executes(c -> TickCommand.queryTps((CommandSourceStack)c.getSource()))).then(Commands.m_82129_((String)"rate", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)500.0f)).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"20.0"}, (SuggestionsBuilder)b)).executes(c -> TickCommand.setTps((CommandSourceStack)c.getSource(), FloatArgumentType.getFloat((CommandContext)c, (String)"rate")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"warp").executes(c -> TickCommand.setWarp((CommandSourceStack)c.getSource(), 0, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"3600", "72000"}, (SuggestionsBuilder)b)).executes(c -> TickCommand.setWarp((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), null))).then(Commands.m_82129_((String)"tail command", (ArgumentType)StringArgumentType.greedyString()).executes(c -> TickCommand.setWarp((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), StringArgumentType.getString((CommandContext)c, (String)"tail command"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"freeze").executes(c -> TickCommand.toggleFreeze((CommandSourceStack)c.getSource(), false))).then(Commands.m_82127_((String)"status").executes(c -> TickCommand.freezeStatus((CommandSourceStack)c.getSource())))).then(Commands.m_82127_((String)"deep").executes(c -> TickCommand.toggleFreeze((CommandSourceStack)c.getSource(), true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"on").executes(c -> TickCommand.setFreeze((CommandSourceStack)c.getSource(), false, true))).then(Commands.m_82127_((String)"deep").executes(c -> TickCommand.setFreeze((CommandSourceStack)c.getSource(), true, true))))).then(Commands.m_82127_((String)"off").executes(c -> TickCommand.setFreeze((CommandSourceStack)c.getSource(), false, false))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"step").executes(c -> TickCommand.step((CommandSourceStack)c.getSource(), 1))).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)72000)).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"20"}, (SuggestionsBuilder)b)).executes(c -> TickCommand.step((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))))).then(Commands.m_82127_((String)"superHot").executes(c -> TickCommand.toggleSuperHot((CommandSourceStack)c.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"health").executes(c -> TickCommand.healthReport((CommandSourceStack)c.getSource(), 100))).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)20, (int)24000)).executes(c -> TickCommand.healthReport((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"entities").executes(c -> TickCommand.healthEntities((CommandSourceStack)c.getSource(), 100))).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)20, (int)24000)).executes(c -> TickCommand.healthEntities((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))));
        dispatcher.register(literalargumentbuilder);
    }

    private static int setTps(CommandSourceStack source, float tps) {
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        trm.setTickRate(tps, true);
        TickCommand.queryTps(source);
        return (int)tps;
    }

    private static int queryTps(CommandSourceStack source) {
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        Messenger.m(source, "w Current tps is: ", String.format("wb %.1f", Float.valueOf(trm.tickrate())));
        return (int)trm.tickrate();
    }

    private static int setWarp(CommandSourceStack source, int advance, String tail_command) {
        ServerPlayer player = source.m_230896_();
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        Component message = trm.requestGameToWarpSpeed(player, advance, tail_command, source);
        source.m_288197_(() -> message, false);
        return 1;
    }

    private static int freezeStatus(CommandSourceStack source) {
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        if (trm.gameIsPaused()) {
            Messenger.m(source, "gi Freeze Status: Game is " + (trm.deeplyFrozen() ? "deeply " : "") + "frozen");
        } else {
            Messenger.m(source, "gi Freeze Status: Game runs normally");
        }
        return 1;
    }

    private static int setFreeze(CommandSourceStack source, boolean isDeep, boolean freeze) {
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        trm.setFrozenState(freeze, isDeep);
        if (trm.gameIsPaused()) {
            Messenger.m(source, "gi Game is " + (isDeep ? "deeply " : "") + "frozen");
        } else {
            Messenger.m(source, "gi Game runs normally");
        }
        return 1;
    }

    private static int toggleFreeze(CommandSourceStack source, boolean isDeep) {
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        return TickCommand.setFreeze(source, isDeep, !trm.gameIsPaused());
    }

    private static int step(CommandSourceStack source, int advance) {
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        trm.stepGameIfPaused(advance);
        Messenger.m(source, "gi Stepping " + advance + " tick" + (advance != 1 ? "s" : ""));
        return 1;
    }

    private static int toggleSuperHot(CommandSourceStack source) {
        ServerTickRateManager trm;
        trm.setSuperHot(!(trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager()).isSuperHot());
        ServerNetworkHandler.updateSuperHotStateToConnectedPlayers(source.m_81377_());
        if (trm.isSuperHot()) {
            Messenger.m(source, "gi Superhot enabled");
        } else {
            Messenger.m(source, "gi Superhot disabled");
        }
        return 1;
    }

    public static int healthReport(CommandSourceStack source, int ticks) {
        CarpetProfiler.prepare_tick_report(source, ticks);
        return 1;
    }

    public static int healthEntities(CommandSourceStack source, int ticks) {
        CarpetProfiler.prepare_entity_report(source, ticks);
        return 1;
    }
}

