/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.MinecraftServerInterface;
import carpet.fakes.SpawnGroupInterface;
import carpet.helpers.HopperCounter;
import carpet.helpers.ServerTickRateManager;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class SpawnCommand {
    private static final Map<String, MobCategory> MOB_CATEGORY_MAP = Arrays.stream(MobCategory.values()).collect(Collectors.toMap(MobCategory::m_21607_, Function.identity()));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandSpawn));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> SpawnCommand.listSpawns((CommandSourceStack)c.getSource(), BlockPosArgument.m_174395_((CommandContext)c, (String)"pos")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tracking").executes(c -> SpawnCommand.printTrackingReport((CommandSourceStack)c.getSource()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"start").executes(c -> SpawnCommand.startTracking((CommandSourceStack)c.getSource(), null, null))).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> SpawnCommand.startTracking((CommandSourceStack)c.getSource(), BlockPosArgument.m_174395_((CommandContext)c, (String)"from"), BlockPosArgument.m_174395_((CommandContext)c, (String)"to"))))))).then(Commands.m_82127_((String)"stop").executes(c -> SpawnCommand.stopTracking((CommandSourceStack)c.getSource())))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(MobCategory.values()).map(MobCategory::m_21607_), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.recentSpawnsForType((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"test").executes(c -> SpawnCommand.runTest((CommandSourceStack)c.getSource(), 72000, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)10)).executes(c -> SpawnCommand.runTest((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), null))).then(Commands.m_82129_((String)"counter", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(DyeColor.values()).map(DyeColor::toString), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.runTest((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), StringArgumentType.getString((CommandContext)c, (String)"counter"))))))).then(Commands.m_82127_((String)"mocking").then(Commands.m_82129_((String)"to do or not to do?", (ArgumentType)BoolArgumentType.bool()).executes(c -> SpawnCommand.toggleMocking((CommandSourceStack)c.getSource(), BoolArgumentType.getBool((CommandContext)c, (String)"to do or not to do?")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rates").executes(c -> SpawnCommand.generalMobcaps((CommandSourceStack)c.getSource()))).then(Commands.m_82127_((String)"reset").executes(c -> SpawnCommand.resetSpawnRates((CommandSourceStack)c.getSource())))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(MobCategory.values()).map(MobCategory::m_21607_), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"rounds", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"1"}, (SuggestionsBuilder)b)).executes(c -> SpawnCommand.setSpawnRates((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), IntegerArgumentType.getInteger((CommandContext)c, (String)"rounds"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mobcaps").executes(c -> SpawnCommand.generalMobcaps((CommandSourceStack)c.getSource()))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"cap (hostile)", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1400)).executes(c -> SpawnCommand.setMobcaps((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"cap (hostile)")))))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(c -> SpawnCommand.mobcapsForDimension((CommandSourceStack)c.getSource(), DimensionArgument.m_88808_((CommandContext)c, (String)"dimension")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"entities").executes(c -> SpawnCommand.generalMobcaps((CommandSourceStack)c.getSource()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(MobCategory.values()).map(MobCategory::m_21607_), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.listEntitiesOfType((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), false))).then(Commands.m_82127_((String)"all").executes(c -> SpawnCommand.listEntitiesOfType((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), true)))));
        dispatcher.register(literalargumentbuilder);
    }

    private static MobCategory getCategory(String string) throws CommandSyntaxException {
        if (!Arrays.stream(MobCategory.values()).map(MobCategory::m_21607_).collect(Collectors.toSet()).contains(string)) {
            throw new SimpleCommandExceptionType((Message)Messenger.c("r Wrong mob type: " + string + " should be " + Arrays.stream(MobCategory.values()).map(MobCategory::m_21607_).collect(Collectors.joining(", ")))).create();
        }
        return MOB_CATEGORY_MAP.get(string.toLowerCase(Locale.ROOT));
    }

    private static int listSpawns(CommandSourceStack source, BlockPos pos) {
        Messenger.send(source, SpawnReporter.report(pos, source.m_81372_()));
        return 1;
    }

    private static int printTrackingReport(CommandSourceStack source) {
        Messenger.send(source, SpawnReporter.tracking_report((Level)source.m_81372_()));
        return 1;
    }

    private static int startTracking(CommandSourceStack source, BlockPos a, BlockPos b) {
        if (SpawnReporter.track_spawns != 0L) {
            Messenger.m(source, "r You are already tracking spawning.");
            return 0;
        }
        BlockPos lsl = null;
        BlockPos usl = null;
        if (a != null && b != null) {
            lsl = new BlockPos(Math.min(a.m_123341_(), b.m_123341_()), Math.min(a.m_123342_(), b.m_123342_()), Math.min(a.m_123343_(), b.m_123343_()));
            usl = new BlockPos(Math.max(a.m_123341_(), b.m_123341_()), Math.max(a.m_123342_(), b.m_123342_()), Math.max(a.m_123343_(), b.m_123343_()));
        }
        SpawnReporter.reset_spawn_stats(source.m_81377_(), false);
        SpawnReporter.track_spawns = source.m_81377_().m_129921_();
        SpawnReporter.lower_spawning_limit = lsl;
        SpawnReporter.upper_spawning_limit = usl;
        Messenger.m(source, "gi Spawning tracking started.");
        return 1;
    }

    private static int stopTracking(CommandSourceStack source) {
        Messenger.send(source, SpawnReporter.tracking_report((Level)source.m_81372_()));
        SpawnReporter.reset_spawn_stats(source.m_81377_(), false);
        SpawnReporter.track_spawns = 0L;
        SpawnReporter.lower_spawning_limit = null;
        SpawnReporter.upper_spawning_limit = null;
        Messenger.m(source, "gi Spawning tracking stopped.");
        return 1;
    }

    private static int recentSpawnsForType(CommandSourceStack source, String mob_type) throws CommandSyntaxException {
        MobCategory cat = SpawnCommand.getCategory(mob_type);
        Messenger.send(source, SpawnReporter.recent_spawns((Level)source.m_81372_(), cat));
        return 1;
    }

    private static int runTest(CommandSourceStack source, int ticks, String counter) {
        SpawnReporter.reset_spawn_stats(source.m_81377_(), false);
        SpawnReporter.track_spawns = source.m_81377_().m_129921_();
        if (counter == null) {
            HopperCounter.resetAll(source.m_81377_(), false);
        } else {
            HopperCounter hCounter = HopperCounter.getCounter(counter);
            if (hCounter != null) {
                hCounter.reset(source.m_81377_());
            }
        }
        ServerTickRateManager trm = ((MinecraftServerInterface)source.m_81377_()).getTickRateManager();
        trm.requestGameToWarpSpeed(null, 0, null, null);
        CommandSourceStack csource = null;
        ServerPlayer player = null;
        try {
            player = source.m_81375_();
            csource = source;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        trm.requestGameToWarpSpeed(player, ticks, null, csource);
        Messenger.m(source, String.format("gi Started spawn test for %d ticks", ticks));
        return 1;
    }

    private static int toggleMocking(CommandSourceStack source, boolean domock) {
        if (domock) {
            SpawnReporter.initialize_mocking();
            Messenger.m(source, "gi Mob spawns will now be mocked.");
        } else {
            SpawnReporter.stop_mocking();
            Messenger.m(source, "gi Normal mob spawning.");
        }
        return 1;
    }

    private static int generalMobcaps(CommandSourceStack source) {
        Messenger.send(source, SpawnReporter.printMobcapsForDimension(source.m_81372_(), true));
        return 1;
    }

    private static int resetSpawnRates(CommandSourceStack source) {
        for (MobCategory s : SpawnReporter.spawn_tries.keySet()) {
            SpawnReporter.spawn_tries.put(s, 1);
        }
        Messenger.m(source, "gi Spawn rates brought to 1 round per tick for all groups.");
        return 1;
    }

    private static int setSpawnRates(CommandSourceStack source, String mobtype, int rounds) throws CommandSyntaxException {
        MobCategory cat = SpawnCommand.getCategory(mobtype);
        SpawnReporter.spawn_tries.put(cat, rounds);
        Messenger.m(source, "gi " + mobtype + " mobs will now spawn " + rounds + " times per tick");
        return 1;
    }

    private static int setMobcaps(CommandSourceStack source, int hostile_cap) {
        double desired_ratio = (double)hostile_cap / (double)((SpawnGroupInterface)MobCategory.MONSTER).getInitialSpawnCap();
        SpawnReporter.mobcap_exponent = 4.0 * Math.log(desired_ratio) / Math.log(2.0);
        Messenger.m(source, String.format("gi Mobcaps for hostile mobs changed to %d, other groups will follow", hostile_cap));
        return 1;
    }

    private static int mobcapsForDimension(CommandSourceStack source, ServerLevel world) {
        Messenger.send(source, SpawnReporter.printMobcapsForDimension(world, true));
        return 1;
    }

    private static int listEntitiesOfType(CommandSourceStack source, String mobtype, boolean all) throws CommandSyntaxException {
        MobCategory cat = SpawnCommand.getCategory(mobtype);
        Messenger.send(source, SpawnReporter.printEntitiesByType(cat, (Level)source.m_81372_(), all));
        return 1;
    }
}

