/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PlayerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandPlayer))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(PlayerCommand.getPlayerSuggestions((CommandSourceStack)c.getSource()), (SuggestionsBuilder)b)).then(Commands.m_82127_((String)"stop").executes(PlayerCommand.manipulation(EntityPlayerActionPack::stopAll)))).then(PlayerCommand.makeActionCommand("use", EntityPlayerActionPack.ActionType.USE))).then(PlayerCommand.makeActionCommand("jump", EntityPlayerActionPack.ActionType.JUMP))).then(PlayerCommand.makeActionCommand("attack", EntityPlayerActionPack.ActionType.ATTACK))).then(PlayerCommand.makeActionCommand("drop", EntityPlayerActionPack.ActionType.DROP_ITEM))).then(PlayerCommand.makeDropCommand("drop", false))).then(PlayerCommand.makeActionCommand("dropStack", EntityPlayerActionPack.ActionType.DROP_STACK))).then(PlayerCommand.makeDropCommand("dropStack", true))).then(PlayerCommand.makeActionCommand("swapHands", EntityPlayerActionPack.ActionType.SWAP_HANDS))).then(Commands.m_82127_((String)"hotbar").then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.setSlot(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"))))))).then(Commands.m_82127_((String)"kill").executes(PlayerCommand::kill))).then(Commands.m_82127_((String)"shadow").executes(PlayerCommand::shadow))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mount").executes(PlayerCommand.manipulation(ap -> ap.mount(true)))).then(Commands.m_82127_((String)"anything").executes(PlayerCommand.manipulation(ap -> ap.mount(false)))))).then(Commands.m_82127_((String)"dismount").executes(PlayerCommand.manipulation(EntityPlayerActionPack::dismount)))).then(Commands.m_82127_((String)"sneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(true))))).then(Commands.m_82127_((String)"unsneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(false))))).then(Commands.m_82127_((String)"sprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(true))))).then(Commands.m_82127_((String)"unsprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"look").then(Commands.m_82127_((String)"north").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.NORTH))))).then(Commands.m_82127_((String)"south").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.SOUTH))))).then(Commands.m_82127_((String)"east").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.EAST))))).then(Commands.m_82127_((String)"west").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.WEST))))).then(Commands.m_82127_((String)"up").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.UP))))).then(Commands.m_82127_((String)"down").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.DOWN))))).then(Commands.m_82127_((String)"at").then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.lookAt(Vec3Argument.m_120844_((CommandContext)c, (String)"position"))))))).then(Commands.m_82129_((String)"direction", (ArgumentType)RotationArgument.m_120479_()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.look(RotationArgument.m_120482_((CommandContext)c, (String)"direction").m_6970_((CommandSourceStack)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"turn").then(Commands.m_82127_((String)"left").executes(PlayerCommand.manipulation(ap -> ap.turn(-90.0f, 0.0f))))).then(Commands.m_82127_((String)"right").executes(PlayerCommand.manipulation(ap -> ap.turn(90.0f, 0.0f))))).then(Commands.m_82127_((String)"back").executes(PlayerCommand.manipulation(ap -> ap.turn(180.0f, 0.0f))))).then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.turn(RotationArgument.m_120482_((CommandContext)c, (String)"rotation").m_6970_((CommandSourceStack)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"move").executes(PlayerCommand.manipulation(EntityPlayerActionPack::stopMovement))).then(Commands.m_82127_((String)"forward").executes(PlayerCommand.manipulation(ap -> ap.setForward(1.0f))))).then(Commands.m_82127_((String)"backward").executes(PlayerCommand.manipulation(ap -> ap.setForward(-1.0f))))).then(Commands.m_82127_((String)"left").executes(PlayerCommand.manipulation(ap -> ap.setStrafing(1.0f))))).then(Commands.m_82127_((String)"right").executes(PlayerCommand.manipulation(ap -> ap.setStrafing(-1.0f)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"in").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"gamemode", (ArgumentType)GameModeArgument.m_257772_()).executes(PlayerCommand::spawn)))).then(Commands.m_82127_((String)"at").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).executes(PlayerCommand::spawn)).then(Commands.m_82127_((String)"facing").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"direction", (ArgumentType)RotationArgument.m_120479_()).executes(PlayerCommand::spawn)).then(Commands.m_82127_((String)"in").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"in").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"gamemode", (ArgumentType)GameModeArgument.m_257772_()).executes(PlayerCommand::spawn)))))))))));
        dispatcher.register(command);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> makeActionCommand(String actionName, EntityPlayerActionPack.ActionType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)actionName).executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.once())))).then(Commands.m_82127_((String)"once").executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.once()))))).then(Commands.m_82127_((String)"continuous").executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.continuous()))))).then(Commands.m_82127_((String)"interval").then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.start(type, EntityPlayerActionPack.Action.interval(IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> makeDropCommand(String actionName, boolean dropAll) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)actionName).then(Commands.m_82127_((String)"all").executes(PlayerCommand.manipulation(ap -> ap.drop(-2, dropAll))))).then(Commands.m_82127_((String)"mainhand").executes(PlayerCommand.manipulation(ap -> ap.drop(-1, dropAll))))).then(Commands.m_82127_((String)"offhand").executes(PlayerCommand.manipulation(ap -> ap.drop(40, dropAll))))).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.drop(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"), dropAll))));
    }

    private static Collection<String> getPlayerSuggestions(CommandSourceStack source) {
        LinkedHashSet<String> players = new LinkedHashSet<String>(List.of("Steve", "Alex"));
        players.addAll(source.m_5982_());
        return players;
    }

    private static ServerPlayer getPlayer(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        return server.m_6846_().m_11255_(playerName);
    }

    private static boolean cantManipulate(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = PlayerCommand.getPlayer(context);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (player == null) {
            Messenger.m(source, "r Can only manipulate existing players");
            return true;
        }
        ServerPlayer sender = source.m_230896_();
        if (sender == null) {
            return false;
        }
        if (!source.m_81377_().m_6846_().m_11303_(sender.m_36316_()) && sender != player && !(player instanceof EntityPlayerMPFake)) {
            Messenger.m(source, "r Non OP players can't control other real players");
            return true;
        }
        return false;
    }

    private static boolean cantReMove(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return true;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            return false;
        }
        Messenger.m((CommandSourceStack)context.getSource(), "r Only fake players can be moved or killed");
        return true;
    }

    private static boolean cantSpawn(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        PlayerList manager = server.m_6846_();
        if (manager.m_11255_(playerName) != null) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Player ", "rb " + playerName, "r  is already logged on");
            return true;
        }
        GameProfile profile = server.m_129927_().m_10996_(playerName).orElse(null);
        if (profile == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                Messenger.m((CommandSourceStack)context.getSource(), "r Player " + playerName + " is either banned by Mojang, or auth servers are down. Banned players can only be summoned in Singleplayer and in servers in off-line mode.");
                return true;
            }
            profile = new GameProfile(UUIDUtil.m_235879_((String)playerName), playerName);
        }
        if (manager.m_11295_().m_11406_(profile)) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Player ", "rb " + playerName, "r  is banned on this server");
            return true;
        }
        if (manager.m_11311_() && manager.m_5764_(profile) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Whitelisted players can only be spawned by operators");
            return true;
        }
        return false;
    }

    private static int kill(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantReMove(context)) {
            return 0;
        }
        PlayerCommand.getPlayer(context).m_6074_();
        return 1;
    }

    private static <T> T getArgOrDefault(SupplierWithCSE<T> getter, T defaultValue) throws CommandSyntaxException {
        try {
            return getter.get();
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private static int spawn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (PlayerCommand.cantSpawn(context)) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Vec3 pos = PlayerCommand.getArgOrDefault(() -> Vec3Argument.m_120844_((CommandContext)context, (String)"position"), source.m_81371_());
        Vec2 facing = PlayerCommand.getArgOrDefault(() -> RotationArgument.m_120482_((CommandContext)context, (String)"direction").m_6970_(source), source.m_81376_());
        ResourceKey dimType = PlayerCommand.getArgOrDefault(() -> DimensionArgument.m_88808_((CommandContext)context, (String)"dimension").m_46472_(), source.m_81372_().m_46472_());
        GameType mode = GameType.CREATIVE;
        boolean flying = false;
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sender = (ServerPlayer)entity;
            mode = sender.f_8941_.m_9290_();
            flying = sender.m_150110_().f_35935_;
        }
        try {
            mode = GameModeArgument.m_257804_(context, (String)"gamemode");
        }
        catch (IllegalArgumentException sender) {
            // empty catch block
        }
        if (mode == GameType.SPECTATOR) {
            flying = true;
        } else if (mode.m_46409_()) {
            flying = false;
        }
        String playerName = StringArgumentType.getString(context, (String)"player");
        if (playerName.length() > PlayerCommand.maxNameLength(source.m_81377_())) {
            Messenger.m(source, "rb Player name: " + playerName + " is too long");
            return 0;
        }
        if (!Level.m_46741_((BlockPos)BlockPos.m_274446_((Position)pos))) {
            Messenger.m(source, "rb Player " + playerName + " cannot be placed outside of the world");
            return 0;
        }
        EntityPlayerMPFake player = EntityPlayerMPFake.createFake(playerName, source.m_81377_(), pos, facing.f_82471_, facing.f_82470_, (ResourceKey<Level>)dimType, mode, flying);
        if (player == null) {
            Messenger.m(source, "rb Player " + playerName + " doesn't exist and cannot spawn in online mode. Turn the server offline to spawn non-existing players");
            return 0;
        }
        return 1;
    }

    private static int maxNameLength(MinecraftServer server) {
        return server.m_7010_() >= 0 ? 16 : 40;
    }

    private static int manipulate(CommandContext<CommandSourceStack> context, Consumer<EntityPlayerActionPack> action) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        action.accept(((ServerPlayerInterface)player).getActionPack());
        return 1;
    }

    private static Command<CommandSourceStack> manipulation(Consumer<EntityPlayerActionPack> action) {
        return c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, action);
    }

    private static int shadow(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Cannot shadow fake players");
            return 0;
        }
        if (player.m_20194_().m_7779_(player.m_36316_())) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Cannot shadow single-player server owner");
            return 0;
        }
        EntityPlayerMPFake.createShadow(player.f_8924_, player);
        return 1;
    }

    @FunctionalInterface
    static interface SupplierWithCSE<T> {
        public T get() throws CommandSyntaxException;
    }
}

