/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import carpet.utils.PerimeterDiagnostics;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class PerimeterInfoCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"perimeterinfo").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandPerimeterInfo))).executes(c -> PerimeterInfoCommand.perimeterDiagnose((CommandSourceStack)c.getSource(), BlockPos.m_274446_((Position)((CommandSourceStack)c.getSource()).m_81371_()), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"center position", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> PerimeterInfoCommand.perimeterDiagnose((CommandSourceStack)c.getSource(), BlockPosArgument.m_174395_((CommandContext)c, (String)"center position"), null))).then(Commands.m_82129_((String)"mob", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)commandBuildContext, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(c -> PerimeterInfoCommand.perimeterDiagnose((CommandSourceStack)c.getSource(), BlockPosArgument.m_174395_((CommandContext)c, (String)"center position"), ResourceArgument.m_247713_((CommandContext)c, (String)"mob").m_205785_().m_135782_().toString()))));
        dispatcher.register(command);
    }

    private static int perimeterDiagnose(CommandSourceStack source, BlockPos pos, String mobId) {
        CompoundTag nbttagcompound = new CompoundTag();
        Mob entityliving = null;
        if (mobId != null) {
            nbttagcompound.m_128359_("id", mobId);
            Entity baseEntity = EntityType.m_20645_((CompoundTag)nbttagcompound, (Level)source.m_81372_(), entity_1x -> {
                entity_1x.m_20035_(new BlockPos(pos.m_123341_(), source.m_81372_().m_141937_() - 10, pos.m_123343_()), entity_1x.m_146908_(), entity_1x.m_146909_());
                return !source.m_81372_().m_8847_(entity_1x) ? null : entity_1x;
            });
            if (!(baseEntity instanceof Mob)) {
                Messenger.m(source, "r /perimeterinfo requires a mob entity to test against.");
                if (baseEntity != null) {
                    baseEntity.m_146870_();
                }
                return 0;
            }
            entityliving = (Mob)baseEntity;
        }
        PerimeterDiagnostics.Result res = PerimeterDiagnostics.countSpots(source.m_81372_(), pos, entityliving);
        Messenger.m(source, "w Spawning spaces around ", Messenger.tp("c", pos), "w :");
        Messenger.m(source, "w   potential in-liquid: ", "wb " + res.liquid);
        Messenger.m(source, "w   potential on-ground: ", "wb " + res.ground);
        if (entityliving != null) {
            Messenger.m(source, "w   ", entityliving.m_5446_(), "w : ", "wb " + res.specific);
            res.samples.forEach(bp -> Messenger.m(source, "w   ", Messenger.tp("c", bp)));
            entityliving.m_146870_();
        }
        return 1;
    }
}

