/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public class CounterCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"counter").requires(c -> CarpetSettings.hopperCounters)).executes(c -> CounterCommand.listAllCounters((CommandSourceStack)c.getSource(), false))).then(Commands.m_82127_((String)"reset").executes(c -> CounterCommand.resetCounters((CommandSourceStack)c.getSource())));
        for (DyeColor dyeColor : DyeColor.values()) {
            commandBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)dyeColor.toString()).executes(c -> CounterCommand.displayCounter((CommandSourceStack)c.getSource(), dyeColor, false))).then(Commands.m_82127_((String)"reset").executes(c -> CounterCommand.resetCounter((CommandSourceStack)c.getSource(), dyeColor)))).then(Commands.m_82127_((String)"realtime").executes(c -> CounterCommand.displayCounter((CommandSourceStack)c.getSource(), dyeColor, true))));
        }
        dispatcher.register(commandBuilder);
    }

    private static int displayCounter(CommandSourceStack source, DyeColor color, boolean realtime) {
        HopperCounter counter = HopperCounter.getCounter(color);
        for (Component message : counter.format(source.m_81377_(), realtime, false)) {
            source.m_288197_(() -> message, false);
        }
        return 1;
    }

    private static int resetCounters(CommandSourceStack source) {
        HopperCounter.resetAll(source.m_81377_(), false);
        Messenger.m(source, "w Restarted all counters");
        return 1;
    }

    private static int resetCounter(CommandSourceStack source, DyeColor color) {
        HopperCounter.getCounter(color).reset(source.m_81377_());
        Messenger.m(source, "w Restarted " + String.valueOf(color) + " counter");
        return 1;
    }

    private static int listAllCounters(CommandSourceStack source, boolean realtime) {
        for (Component message : HopperCounter.formatAll(source.m_81377_(), realtime)) {
            source.m_288197_(() -> message, false);
        }
        return 1;
    }
}

