/*
 * Decompiled with CFR 0.152.
 */
package carpet;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.Validator;
import carpet.api.settings.Validators;
import carpet.script.external.Carpet;
import carpet.settings.Rule;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import carpet.utils.SpawnChunks;
import carpet.utils.Translations;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarpetSettings {
    public static final String carpetVersion = ((ModContainer)ModList.get().getModContainerById("carpet").orElseThrow()).getModInfo().getVersion().toString();
    public static final String releaseTarget = "1.20.1";
    public static final Logger LOG = LoggerFactory.getLogger((String)"carpet");
    public static final ThreadLocal<Boolean> skipGenerationChecks = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> impendingFillSkipUpdates = ThreadLocal.withInitial(() -> false);
    public static int runPermissionLevel = 2;
    public static Block structureBlockIgnoredBlock = Blocks.f_50454_;
    @Rule(desc="Sets the language for Carpet", category={"feature"}, options={"en_us", "pt_br", "zh_cn", "zh_tw"}, strict=true, validate={LanguageValidator.class})
    public static String language = "en_us";
    @Rule(desc="Carpet command permission level. Can only be set via .conf file", category={"creative"}, validate={CarpetPermissionLevel.class}, options={"ops", "2", "4"})
    public static String carpetCommandPermissionLevel = "ops";
    @Rule(desc="Gbhs sgnf sadsgras fhskdpri!!!", category={"experimental"})
    public static boolean superSecretSetting = false;
    @Rule(desc="Amount of delay ticks to use a nether portal in creative", options={"1", "40", "80", "72000"}, category={"creative"}, strict=false, validate={OneHourMaxDelayLimit.class})
    public static int portalCreativeDelay = 1;
    @Rule(desc="Amount of delay ticks to use a nether portal in survival", options={"1", "40", "80", "72000"}, category={"survival"}, strict=false, validate={OneHourMaxDelayLimit.class})
    public static int portalSurvivalDelay = 80;
    @Rule(desc="Dropping entire stacks works also from on the crafting UI result slot", category={"bugfix", "survival"})
    public static boolean ctrlQCraftingFix = false;
    @Rule(desc="Parrots don't get of your shoulders until you receive proper damage", category={"survival", "feature"})
    public static boolean persistentParrots = false;
    @Rule(desc="Players absorb XP instantly, without delay", category={"creative"})
    public static boolean xpNoCooldown = false;
    @Rule(desc="Empty shulker boxes can stack when thrown on the ground.", extra={".. or when manipulated inside the inventories"}, validate={StackableShulkerBoxValidator.class}, options={"false", "true", "16"}, strict=false, category={"survival", "feature"})
    public static String stackableShulkerBoxes = "false";
    public static int shulkerBoxStackSize = 1;
    @Rule(desc="Explosions won't destroy blocks", category={"creative", "tnt"})
    public static boolean explosionNoBlockDamage = false;
    @Rule(desc="Experience will drop from all experience barring blocks with any explosion type", category={"survival", "feature"})
    public static boolean xpFromExplosions = false;
    @Rule(desc="Removes random TNT momentum when primed", category={"creative", "tnt"})
    public static boolean tntPrimerMomentumRemoved = false;
    @Rule(desc="TNT causes less lag when exploding in the same spot and in liquids", category={"tnt"})
    public static boolean optimizedTNT = false;
    @Rule(desc="Sets the tnt random explosion range to a fixed value", category={"tnt"}, options={"-1"}, strict=false, validate={CheckOptimizedTntEnabledValidator.class, TNTRandomRangeValidator.class}, extra={"Set to -1 for default behavior"})
    public static double tntRandomRange = -1.0;
    @Rule(desc="Sets the horizontal random angle on TNT for debugging of TNT contraptions", category={"tnt"}, options={"-1"}, strict=false, validate={TNTAngleValidator.class}, extra={"Set to -1 for default behavior"})
    public static double hardcodeTNTangle = -1.0;
    @Rule(desc="Merges stationary primed TNT entities", category={"tnt"})
    public static boolean mergeTNT = false;
    @Rule(desc="Lag optimizations for redstone dust", extra={"by Theosib", ".. also fixes some locational behaviours or vanilla redstone MC-11193", "so behaviour of locational vanilla contraptions is not guaranteed"}, category={"experimental", "optimization"})
    public static boolean fastRedstoneDust = false;
    @Rule(desc="Only husks spawn in desert temples", category={"feature"})
    public static boolean huskSpawningInTemples = false;
    @Rule(desc="Shulkers will respawn in end cities", category={"feature"})
    public static boolean shulkerSpawningInEndCities = false;
    @Rule(desc="Piglins will respawn in bastion remnants", extra={"Includes piglins, brutes, and a few hoglins"}, category={"feature"})
    public static boolean piglinsSpawningInBastions = false;
    @Rule(desc="TNT doesn't update when placed against a power source", category={"creative", "tnt"})
    public static boolean tntDoNotUpdate = false;
    @Rule(desc="Prevents players from rubberbanding when moving too fast", extra={"... or being kicked out for 'flying'", "Puts more trust in clients positioning", "Increases player allowed mining distance to 32 blocks"}, category={"creative", "survival"})
    public static boolean antiCheatDisabled = false;
    @Rule(desc="Pistons, droppers, and dispensers check for power to the block(s) above them.", extra={"Defines the range at which pistons, droppers, and dispensers check for 'quasi power'."}, category={"creative"}, validate={QuasiConnectivityValidator.class})
    public static int quasiConnectivity = 1;
    @Rule(desc="Players can flip and rotate blocks when holding cactus", extra={"Doesn't cause block updates when rotated/flipped", "Applies to pistons, observers, droppers, repeaters, stairs, glazed terracotta etc..."}, category={"creative", "survival", "feature"})
    public static boolean flippinCactus = false;
    @Rule(desc="hoppers pointing to wool will count items passing through them", extra={"Enables /counter command, and actions while placing red and green carpets on wool blocks", "Use /counter <color?> reset to reset the counter, and /counter <color?> to query", "In survival, place green carpet on same color wool to query, red to reset the counters", "Counters are global and shared between players, 16 channels available", "Items counted are destroyed, count up to one stack per tick per hopper"}, category={"command", "creative", "feature"})
    public static boolean hopperCounters = false;
    @Rule(desc="Allows Budding Amethyst blocks to be moved", extra={"Allow for them to be moved by pistons", "as well as adds extra drop when mining with silk touch pickaxe"}, category={"feature"})
    public static boolean movableAmethyst = false;
    @Rule(desc="Guardians turn into Elder Guardian when struck by lightning", category={"feature"})
    public static boolean renewableSponges = false;
    @Rule(desc="Pistons can push block entities, like hoppers, chests etc.", category={"experimental", "feature"})
    public static boolean movableBlockEntities = false;
    @Rule(desc="Chains will stick to each other on the long ends", extra={"and will stick to other blocks that connect to them directly.", "With stick_to_all: it will stick even if not visually connected"}, category={"experimental", "feature"})
    public static ChainStoneMode chainStone = ChainStoneMode.FALSE;
    @Rule(desc="Saplings turn into dead shrubs in hot climates and no water access", category={"feature"})
    public static boolean desertShrubs = false;
    @Rule(desc="Silverfish drop a gravel item when breaking out of a block", category={"feature"})
    public static boolean silverFishDropGravel = false;
    @Rule(desc="summoning a lightning bolt has all the side effects of natural lightning", category={"creative"})
    public static boolean summonNaturalLightning = false;
    @Rule(desc="Enables /spawn command for spawn tracking", category={"command"})
    public static String commandSpawn = "ops";
    @Rule(desc="Enables /tick command to control game clocks", category={"command"})
    public static String commandTick = "ops";
    @Rule(desc="Enables /profile command to monitor game performance", extra={"subset of /tick command capabilities"}, category={"command"})
    public static String commandProfile = "true";
    @Rule(desc="Required permission level for /perf command", options={"2", "4"}, category={"creative"})
    public static int perfPermissionLevel = 4;
    @Rule(desc="Enables /log command to monitor events via chat and overlays", category={"command"})
    public static String commandLog = "true";
    @Rule(desc="sets these loggers in their default configurations for all new players", extra={"use csv, like 'tps,mobcaps' for multiple loggers, none for nothing"}, category={"creative", "survival"}, options={"none", "tps", "mobcaps,tps"}, strict=false)
    public static String defaultLoggers = "none";
    @Rule(desc="Enables /distance command to measure in game distance between points", extra={"Also enables brown carpet placement action if 'carpets' rule is turned on as well"}, category={"command"})
    public static String commandDistance = "true";
    @Rule(desc="Enables /info command for blocks", extra={"Also enables gray carpet placement action", "if 'carpets' rule is turned on as well"}, category={"command"})
    public static String commandInfo = "true";
    @Rule(desc="Enables /perimeterinfo command", extra={"... that scans the area around the block for potential spawnable spots"}, category={"command"})
    public static String commandPerimeterInfo = "true";
    @Rule(desc="Enables /draw commands", extra={"... allows for drawing simple shapes or", "other shapes which are sorta difficult to do normally"}, category={"command"})
    public static String commandDraw = "ops";
    @Rule(desc="Enables /script command", extra={"An in-game scripting API for Scarpet programming language"}, category={"command", "scarpet"})
    public static String commandScript = "true";
    @Rule(desc="Enables restrictions for arbitrary code execution with scarpet", extra={"Users that don't have this permission level", "won't be able to load apps or /script run.", "It is also the permission level apps will", "have when running commands with run()"}, category={"scarpet"}, options={"ops", "0", "1", "2", "3", "4"}, validate={Validators.CommandLevel.class, ModulePermissionLevel.class})
    public static String commandScriptACE = "ops";
    @Rule(desc="Scarpet script from world files will autoload on server/world start ", extra={"if /script is enabled"}, category={"scarpet"})
    public static boolean scriptsAutoload = true;
    @Rule(desc="Enables scripts debugging messages in system log", category={"scarpet"})
    public static boolean scriptsDebugging = false;
    @Rule(desc="Enables scripts optimization", category={"scarpet"})
    public static boolean scriptsOptimization = true;
    @Rule(desc="Location of the online repository of scarpet apps", extra={"set to 'none' to disable.", "Point to any github repo with scarpet apps", "using <user>/<repo>/contents/<path...>"}, category={"scarpet"}, strict=false, validate={Carpet.ScarpetAppStoreValidator.class})
    public static String scriptsAppStore = "gnembon/scarpet/contents/programs";
    @Rule(desc="Enables /player command to control/spawn players", category={"command"})
    public static String commandPlayer = "ops";
    @Rule(desc="Spawn offline players in online mode if online-mode player with specified name does not exist", category={"command"})
    public static boolean allowSpawningOfflinePlayers = true;
    @Rule(desc="Allows to track mobs AI via /track command", category={"command"})
    public static String commandTrackAI = "ops";
    @Rule(desc="Placing carpets may issue carpet commands for non-op players", category={"survival"})
    public static boolean carpets = false;
    @Rule(desc="Glass can be broken faster with pickaxes", category={"survival"})
    public static boolean missingTools = false;
    @Rule(desc="fill/clone/setblock and structure blocks cause block updates", category={"creative"})
    public static boolean fillUpdates = true;
    @Rule(desc="placing blocks cause block updates", category={"creative"})
    public static boolean interactionUpdates = true;
    @Rule(desc="Disables breaking of blocks caused by flowing liquids", category={"creative"})
    public static boolean liquidDamageDisabled = false;
    @Rule(desc="smooth client animations with low tps settings", extra={"works only in SP, and will slow down players"}, category={"creative", "survival", "client"})
    public static boolean smoothClientAnimations;
    @Rule(desc="Customizable piston push limit", options={"10", "12", "14", "100"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int pushLimit;
    @Rule(desc="Customizable powered rail power range", options={"9", "15", "30"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int railPowerLimit;
    @Rule(desc="[Deprecated] Customizable fill/fillbiome/clone volume limit", extra={"Use vanilla gamerule instead. This setting will be removed in 1.20.0"}, options={"32768", "250000", "1000000"}, category={"creative"}, strict=false, validate={FillLimitMigrator.class})
    public static int fillLimit;
    @Rule(desc="Customizable forceload chunk limit", options={"256"}, category={"creative"}, strict=false, validate={ForceloadLimitValidator.class})
    public static int forceloadLimit;
    @Rule(desc="Customizable maximal entity collision limits, 0 for no limits", options={"0", "1", "20"}, category={"optimization"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static int maxEntityCollisions;
    @Rule(desc="Customizable server list ping (Multiplayer menu) playerlist sample limit", options={"0", "12", "20", "40"}, category={"creative"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static int pingPlayerListLimit;
    @Rule(desc="Sets a different motd message on client trying to connect to the server", extra={"use '_' to use the startup setting from server.properties"}, options={"_"}, strict=false, category={"creative"})
    public static String customMOTD;
    @Rule(desc="Cactus in dispensers rotates blocks.", extra={"Rotates block anti-clockwise if possible"}, category={"feature", "dispenser"})
    public static boolean rotatorBlock;
    @Rule(desc="Changes the view distance of the server.", extra={"Set to 0 to not override the value in server settings."}, options={"0", "12", "16", "32"}, category={"creative"}, strict=false, validate={ViewDistanceValidator.class})
    public static int viewDistance;
    @Rule(desc="Changes the simulation distance of the server.", extra={"Set to 0 to not override the value in server settings."}, options={"0", "12", "16", "32"}, category={"creative"}, strict=false, validate={SimulationDistanceValidator.class})
    public static int simulationDistance;
    @Rule(desc="Changes size of spawn chunks", extra={"Defines new radius", "setting it to 0 - disables spawn chunks"}, category={"creative"}, strict=false, options={"0", "11"}, validate={ChangeSpawnChunksValidator.class})
    public static int spawnChunksSize;
    @Rule(desc="Changes maximum light tasks batch size", extra={"Allows for a higher light suppression tolerance", "setting it to 5 - Default limit defined by the game"}, category={"experimental", "optimization"}, strict=false, options={"5", "50", "100", "200"}, validate={LightBatchValidator.class})
    public static int lightEngineMaxBatchSize;
    @Rule(desc="Coral structures will grow with bonemeal from coral plants", extra={"Expanded also allows growing from coral fans for sustainable farming outside of warm oceans"}, category={"feature"})
    public static RenewableCoralMode renewableCoral;
    @Rule(desc="Nether basalt generator without soul sand below ", extra={"  .. will convert into blackstone instead"}, category={"feature"})
    public static boolean renewableBlackstone;
    @Rule(desc="Lava and water generate deepslate and cobbled deepslate instead below Y0", category={"feature"})
    public static boolean renewableDeepslate;
    @Rule(desc="fixes block placement rotation issue when player rotates quickly while placing blocks", category={"bugfix"})
    public static boolean placementRotationFix;
    @Rule(desc="Spawning requires much less CPU and Memory", category={"optimization"})
    public static boolean lagFreeSpawning;
    @Rule(desc="Increases for testing purposes number of blue skulls shot by the wither", category={"creative"})
    public static boolean moreBlueSkulls;
    @Rule(desc="Removes fog from client in the nether and the end", extra={"Improves visibility, but looks weird"}, category={"client"})
    public static boolean fogOff;
    @Rule(desc="Creative No Clip", extra={"On servers it needs to be set on both ", "client and server to function properly.", "Has no effect when set on the server only", "Can allow to phase through walls", "if only set on the carpet client side", "but requires some trapdoor magic to", "allow the player to enter blocks"}, category={"creative", "client"})
    public static boolean creativeNoClip;
    @Rule(desc="Creative flying speed multiplier", extra={"Purely client side setting, meaning that", "having it set on the decicated server has no effect", "but this also means it will work on vanilla servers as well"}, category={"creative", "client"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static double creativeFlySpeed;
    @Rule(desc="Creative air drag", extra={"Increased drag will slow down your flight", "So need to adjust speed accordingly", "With 1.0 drag, using speed of 11 seems to matching vanilla speeds.", "Purely client side setting, meaning that", "having it set on the decicated server has no effect", "but this also means it will work on vanilla servers as well"}, category={"creative", "client"}, strict=false, validate={Validators.Probablity.class})
    public static double creativeFlyDrag;
    @Rule(desc="Removes obnoxious messages from the logs", extra={"Doesn't display 'Maximum sound pool size 247 reached'", "Which is normal with decent farms and contraptions"}, category={"survival", "client"})
    public static boolean cleanLogs;
    @Rule(desc="Customizable structure block limit of each axis", extra={"WARNING: Needs to be permanent for correct loading.", "Setting 'structureBlockIgnored' to air is recommended", "when saving massive structures.", "Required on client of player editing the Structure Block.", "'structureBlockOutlineDistance' may be required for", "correct rendering of long structures."}, options={"48", "96", "192", "256"}, category={"creative"}, validate={StructureBlockLimitValidator.class}, strict=false)
    public static int structureBlockLimit;
    @Rule(desc="Changes the block ignored by the Structure Block", options={"minecraft:structure_void", "minecraft:air"}, category={"creative"}, validate={StructureBlockIgnoredValidator.class}, strict=false)
    public static String structureBlockIgnored;
    @Rule(desc="Customizable Structure Block outline render distance", extra={"Required on client to work properly"}, options={"96", "192", "2048"}, category={"creative", "client"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static int structureBlockOutlineDistance;
    @Rule(desc="Lightning kills the items that drop when lightning kills an entity", extra={"Setting to true will prevent lightning from killing drops", "Fixes [MC-206922](https://bugs.mojang.com/browse/MC-206922)."}, category={"bugfix"})
    public static boolean lightningKillsDropsFix;
    @Rule(desc="Placing an activator rail on top of a barrier block will fill the neighbor updater stack when the rail turns off.", extra={"The integer entered is the amount of updates that should be left in the stack", "-1 turns it off"}, category={"creative"}, options={"-1", "0", "10", "50"}, strict=false, validate={UpdateSuppressionBlockModes.class})
    public static int updateSuppressionBlock;
    @Rule(desc="Creative players load chunks, or they don't! Just like spectators!", extra={"Toggling behaves exactly as if the player is in spectator mode and toggling the gamerule spectatorsGenerateChunks."}, category={"creative", "feature"})
    public static boolean creativePlayersLoadChunks;
    @Rule(desc="Customizable sculk sensor range", options={"8", "16", "32"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int sculkSensorRange;
    @Rule(desc="Makes world borders move based on in game time instead of real time", extra={"This has the effect that when the tick rate changes the world border speed also changes proportional to it"}, category={"feature"}, validate={WorldBorderValidator.class})
    public static boolean tickSyncedWorldBorders;
    @Rule(desc="Allows to grow nether fungi with 3x3 base with bonemeal", extra={"Setting to 'all' will make all nether fungi grow into 3x3 trees", "Setting to 'random' will make 6% of all nether fungi grow into 3x3 trees", "(this being consistent with worldgen)"}, category={"survival", "feature"})
    public static FungusGrowthMode thickFungusGrowth;

    public static boolean isCreativeFlying(Entity entity) {
        return creativeNoClip && entity instanceof Player && ((Player)entity).m_7500_() && ((Player)entity).m_150110_().f_35935_;
    }

    static {
        pushLimit = 12;
        railPowerLimit = 9;
        fillLimit = 32768;
        forceloadLimit = 256;
        maxEntityCollisions = 0;
        pingPlayerListLimit = 12;
        customMOTD = "_";
        rotatorBlock = false;
        viewDistance = 0;
        simulationDistance = 0;
        spawnChunksSize = 11;
        lightEngineMaxBatchSize = 5;
        renewableCoral = RenewableCoralMode.FALSE;
        renewableBlackstone = false;
        renewableDeepslate = false;
        placementRotationFix = false;
        lagFreeSpawning = false;
        moreBlueSkulls = false;
        fogOff = false;
        creativeNoClip = false;
        creativeFlySpeed = 1.0;
        creativeFlyDrag = 0.09;
        cleanLogs = false;
        structureBlockLimit = 48;
        structureBlockIgnored = "minecraft:structure_void";
        structureBlockOutlineDistance = 96;
        lightningKillsDropsFix = false;
        updateSuppressionBlock = -1;
        creativePlayersLoadChunks = true;
        sculkSensorRange = 8;
        tickSyncedWorldBorders = false;
        thickFungusGrowth = FungusGrowthMode.FALSE;
    }

    public static enum ChainStoneMode {
        TRUE,
        FALSE,
        STICK_TO_ALL;


        public boolean enabled() {
            return this != FALSE;
        }
    }

    public static enum RenewableCoralMode {
        FALSE,
        EXPANDED,
        TRUE;

    }

    public static enum FungusGrowthMode {
        FALSE,
        RANDOM,
        ALL;

    }

    private static class WorldBorderValidator
    extends Validator<Boolean> {
        private WorldBorderValidator() {
        }

        @Override
        public Boolean validate(CommandSourceStack source, CarpetRule<Boolean> changingRule, Boolean newValue, String userInput) {
            if (changingRule.value() ^ newValue) {
                tickSyncedWorldBorders = newValue;
                MinecraftServer server = CarpetServer.minecraft_server;
                if (server == null) {
                    return newValue;
                }
                for (ServerLevel level : server.m_129785_()) {
                    WorldBorder worldBorder = level.m_6857_();
                    if (worldBorder.m_61954_() == BorderStatus.STATIONARY) continue;
                    double from = worldBorder.m_61959_();
                    double to = worldBorder.m_61961_();
                    long time = worldBorder.m_61960_();
                    worldBorder.m_61919_(from, to, time);
                }
            }
            return newValue;
        }
    }

    private static class UpdateSuppressionBlockModes
    extends Validator<Integer> {
        private UpdateSuppressionBlockModes() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue < -1 ? null : newValue;
        }

        @Override
        public String description() {
            return "This value represents the amount of updates required before the logger logs them. Must be -1 or larger";
        }
    }

    public static class StructureBlockIgnoredValidator
    extends Validator<String> {
        @Override
        public String validate(CommandSourceStack source, CarpetRule<String> currentRule, String newValue, String string) {
            if (source == null) {
                return newValue;
            }
            Optional ignoredBlock = source.m_5894_().m_175515_(Registries.f_256747_).m_6612_(ResourceLocation.m_135820_((String)newValue));
            if (!ignoredBlock.isPresent()) {
                Messenger.m(source, "r Unknown block '" + newValue + "'.");
                return null;
            }
            structureBlockIgnoredBlock = (Block)ignoredBlock.get();
            return newValue;
        }
    }

    public static class StructureBlockLimitValidator
    extends Validator<Integer> {
        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue >= 48 ? newValue : null;
        }

        @Override
        public String description() {
            return "You have to choose a value greater or equal to 48";
        }
    }

    public static class LightBatchValidator
    extends Validator<Integer> {
        public static void applyLightBatchSizes(MinecraftServer server, int maxBatchSize) {
            for (ServerLevel serverLevel : server.m_129785_()) {
            }
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (source == null) {
                return newValue;
            }
            if (newValue < 0) {
                Messenger.m(source, "r light batch size has to be at least 0");
                return null;
            }
            if (currentRule.value().intValue() == newValue.intValue()) {
                return newValue;
            }
            LightBatchValidator.applyLightBatchSizes(source.m_81377_(), newValue);
            return newValue;
        }
    }

    public static class ChangeSpawnChunksValidator
    extends Validator<Integer> {
        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r spawn chunk size has to be between 0 and 32");
                return null;
            }
            if (currentRule.value().intValue() == newValue.intValue()) {
                return newValue;
            }
            ServerLevel currentOverworld = source.m_81377_().m_129783_();
            if (currentOverworld != null) {
                SpawnChunks.changeSpawnSize(currentOverworld, newValue);
            }
            return newValue;
        }
    }

    private static class SimulationDistanceValidator
    extends Validator<Integer> {
        private SimulationDistanceValidator() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (currentRule.value().equals(newValue) || source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r simulation distance has to be between 0 and 32");
                return null;
            }
            MinecraftServer server = source.m_81377_();
            if (server.m_6982_()) {
                int vd;
                int n = vd = newValue >= 2 ? newValue : ((DedicatedServer)server).m_7913_().f_183715_;
                if (vd != server.m_6846_().m_184213_()) {
                    server.m_6846_().m_184211_(vd);
                }
                return newValue;
            }
            Messenger.m(source, "r simulation distance can only be changed on a server");
            return 0;
        }

        @Override
        public String description() {
            return "You must choose a value from 0 (use server settings) to 32";
        }
    }

    private static class ViewDistanceValidator
    extends Validator<Integer> {
        private ViewDistanceValidator() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (currentRule.value().equals(newValue) || source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r view distance has to be between 0 and 32");
                return null;
            }
            MinecraftServer server = source.m_81377_();
            if (server.m_6982_()) {
                int vd;
                int n = vd = newValue >= 2 ? newValue : ((ServerInterface)server).m_7913_().f_139714_;
                if (vd != server.m_6846_().m_11312_()) {
                    server.m_6846_().m_11217_(vd);
                }
                return newValue;
            }
            Messenger.m(source, "r view distance can only be changed on a server");
            return 0;
        }

        @Override
        public String description() {
            return "You must choose a value from 0 (use server settings) to 32";
        }
    }

    private static class ForceloadLimitValidator
    extends Validator<Integer> {
        private ForceloadLimitValidator() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 20000000 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 20M";
        }
    }

    private static class FillLimitMigrator
    extends Validator<Integer> {
        private FillLimitMigrator() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> changingRule, Integer newValue, String userInput) {
            GameRules.IntegerValue gamerule;
            if (source != null && source.m_81377_().m_129783_() != null && (gamerule = (GameRules.IntegerValue)source.m_81377_().m_129900_().m_46170_(GameRules.f_263760_)).m_46288_() != newValue.intValue()) {
                if (newValue == 32768 && changingRule.value() == newValue) {
                    Messenger.m(source, "g Syncing fillLimit rule with gamerule");
                    newValue = gamerule.m_46288_();
                } else if (newValue != 32768 && gamerule.m_46288_() == 32768) {
                    Messenger.m(source, "g Migrated value of fillLimit carpet rule to commandModificationBlockLimit gamerule");
                    gamerule.m_151489_(newValue.intValue(), source.m_81377_());
                }
            }
            return newValue;
        }

        @Override
        public String description() {
            return "The value of this rule will be migrated to the gamerule";
        }
    }

    private static class PushLimitLimits
    extends Validator<Integer> {
        private PushLimitLimits() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 1024 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 1024";
        }
    }

    private static class ModulePermissionLevel
    extends Validator<String> {
        private ModulePermissionLevel() {
        }

        @Override
        public String validate(CommandSourceStack source, CarpetRule<String> currentRule, String newValue, String string) {
            int permissionLevel = switch (newValue) {
                case "false" -> 0;
                case "true", "ops" -> 2;
                case "0", "1", "2", "3", "4" -> Integer.parseInt(newValue);
                default -> throw new IllegalArgumentException();
            };
            if (source != null && !source.m_6761_(permissionLevel)) {
                return null;
            }
            runPermissionLevel = permissionLevel;
            if (source != null) {
                CommandHelper.notifyPlayersCommandsChanged(source.m_81377_());
            }
            return newValue;
        }

        @Override
        public String description() {
            return "When changing the rule, you must at least have the permission level you are trying to give it";
        }
    }

    private static class QuasiConnectivityValidator
    extends Validator<Integer> {
        private QuasiConnectivityValidator() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> changingRule, Integer newValue, String userInput) {
            int minRange = 0;
            int maxRange = 1;
            if (source == null) {
                maxRange = Integer.MAX_VALUE;
            } else {
                for (Level level : source.m_81377_().m_129785_()) {
                    maxRange = Math.max(maxRange, level.m_141928_() - 1);
                }
            }
            return newValue >= minRange && newValue <= maxRange ? newValue : null;
        }
    }

    private static class TNTAngleValidator
    extends Validator<Double> {
        private TNTAngleValidator() {
        }

        @Override
        public Double validate(CommandSourceStack source, CarpetRule<Double> currentRule, Double newValue, String string) {
            return newValue >= 0.0 && newValue < Math.PI * 2 || newValue == -1.0 ? newValue : null;
        }

        @Override
        public String description() {
            return "Must be between 0 and 2pi, or -1";
        }
    }

    private static class TNTRandomRangeValidator
    extends Validator<Double> {
        private TNTRandomRangeValidator() {
        }

        @Override
        public Double validate(CommandSourceStack source, CarpetRule<Double> currentRule, Double newValue, String string) {
            return newValue == -1.0 || newValue >= 0.0 ? newValue : null;
        }

        @Override
        public String description() {
            return "Cannot be negative, except for -1";
        }
    }

    private static class CheckOptimizedTntEnabledValidator<T>
    extends Validator<T> {
        private CheckOptimizedTntEnabledValidator() {
        }

        @Override
        public T validate(CommandSourceStack source, CarpetRule<T> currentRule, T newValue, String string) {
            return (T)(optimizedTNT || currentRule.defaultValue().equals(newValue) ? newValue : null);
        }

        @Override
        public String description() {
            return "optimizedTNT must be enabled";
        }
    }

    public static class StackableShulkerBoxValidator
    extends Validator<String> {
        @Override
        public String validate(CommandSourceStack source, CarpetRule<String> currentRule, String newValue, String string) {
            int value;
            if (newValue.matches("^[0-9]+$") && (value = Integer.parseInt(newValue)) <= 64 && value >= 2) {
                shulkerBoxStackSize = value;
                return newValue;
            }
            if (newValue.equalsIgnoreCase("false")) {
                shulkerBoxStackSize = 1;
                return newValue;
            }
            if (newValue.equalsIgnoreCase("true")) {
                shulkerBoxStackSize = 64;
                return newValue;
            }
            return null;
        }

        @Override
        public String description() {
            return "Value must either be true, false, or a number between 2-64";
        }
    }

    private static class OneHourMaxDelayLimit
    extends Validator<Integer> {
        private OneHourMaxDelayLimit() {
        }

        @Override
        public Integer validate(CommandSourceStack source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 72000 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 72000";
        }
    }

    private static class CarpetPermissionLevel
    extends Validator<String> {
        private CarpetPermissionLevel() {
        }

        @Override
        public String validate(CommandSourceStack source, CarpetRule<String> currentRule, String newValue, String string) {
            if (source == null || source.m_6761_(4)) {
                return newValue;
            }
            return null;
        }

        @Override
        public String description() {
            return "This setting can only be set by admins with op level 4";
        }
    }

    private static class LanguageValidator
    extends Validator<String> {
        private LanguageValidator() {
        }

        @Override
        public String validate(CommandSourceStack source, CarpetRule<String> currentRule, String newValue, String string) {
            if (!Translations.isValidLanguage(newValue)) {
                Messenger.m(source, "r " + newValue + " is not a valid language");
                return null;
            }
            language = newValue;
            Translations.updateLanguage();
            return newValue;
        }
    }
}

