/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jarjar.nio.pathfs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.neoforged.jarjar.nio.pathfs.PathFileSystem;
import net.neoforged.jarjar.nio.pathfs.PathPath;

public class PathFileSystemProvider
extends FileSystemProvider {
    protected static final String COMPONENT_SEPERATOR = "~";
    public static final String PATH_SEPERATOR = "~/";
    private final Map<String, PathFileSystem> fileSystems = new HashMap<String, PathFileSystem>();

    @Override
    public String getScheme() {
        return "path";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Path packagePath = env.getOrDefault("packagePath", null);
        if (packagePath == null) {
            throw new UnsupportedOperationException("Missing packagePath");
        }
        String key = this.makeKey(uri);
        if (this.fileSystems.containsKey(key)) {
            return this.fileSystems.get(key);
        }
        try {
            return this.newFileSystemInternal(key, packagePath);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        Path packagePath = env.getOrDefault("packagePath", null);
        if (packagePath == null) {
            throw new UnsupportedOperationException("Missing packagePath");
        }
        String key = this.makeKey(path);
        try {
            return this.newFileSystemInternal(key, packagePath);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public PathFileSystem newFileSystem(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        String key = this.makeKey(path);
        return this.newFileSystemInternal(key, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathFileSystem newFileSystemInternal(String key, Path path) {
        Path normalizedPath = path.toAbsolutePath().normalize();
        Map<String, PathFileSystem> map = this.fileSystems;
        synchronized (map) {
            PathFileSystem ufs = new PathFileSystem(this, key, normalizedPath);
            this.fileSystems.put(key, ufs);
            return ufs;
        }
    }

    private String makeKey(URI uri) {
        String keyValue = uri.getRawSchemeSpecificPart();
        if (keyValue.startsWith("//")) {
            return keyValue.substring(2);
        }
        return keyValue;
    }

    private String makeKey(Path path) {
        return path.getFileName().toString();
    }

    @Override
    public Path getPath(URI uri) {
        String[] parts = uri.getRawSchemeSpecificPart().split(COMPONENT_SEPERATOR);
        if (parts.length > 1) {
            return this.getFileSystem(uri).getPath(parts[1], new String[0]);
        }
        return ((PathFileSystem)this.getFileSystem(uri)).getRoot();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String[] parts = uri.getRawSchemeSpecificPart().split(COMPONENT_SEPERATOR);
        if (!this.fileSystems.containsKey(parts[0])) {
            throw new FileSystemNotFoundException();
        }
        return this.fileSystems.get(parts[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (path instanceof PathPath) {
            PathPath up = (PathPath)path;
            return up.getFileSystem().newByteChannel(path, options, attrs);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (dir instanceof PathPath) {
            PathPath up = (PathPath)dir;
            return up.getFileSystem().newDirectoryStream(dir, filter);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return false;
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        if (path instanceof PathPath) {
            PathPath up = (PathPath)path;
            up.getFileSystem().checkAccess(path, modes);
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (path instanceof PathPath) {
            PathPath p = (PathPath)path;
            return p.getFileSystem().readAttributes(path, type, options);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(PathFileSystem fs) {
        Map<String, PathFileSystem> map = this.fileSystems;
        synchronized (map) {
            this.fileSystems.remove(fs.getKey());
        }
    }

    protected URI buildUriFor(PathPath path) throws URISyntaxException, IllegalArgumentException {
        return new URI(path.getFileSystem().provider().getScheme(), path.getFileSystem().getKey() + PATH_SEPERATOR + path, null);
    }

    protected Path createSubPath(PathFileSystem pathFileSystem, String ... args) {
        return new PathPath(pathFileSystem, false, args);
    }

    public Path adaptResolvedPath(PathPath path) {
        return path;
    }

    public String[] adaptPathParts(String longstring, String[] pathParts) {
        return pathParts;
    }

    protected Optional<FileSystem> getFileSystemFromKey(String section) {
        return Optional.ofNullable(this.fileSystems.get(section));
    }
}

