/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.multiplayer.client.AbstractFullDataNetworkRequestQueue;
import com.seibel.distanthorizons.core.multiplayer.client.ClientNetworkState;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;

public class RemoteWorldRetrievalQueue
extends AbstractFullDataNetworkRequestQueue
implements IFullDataSourceRetrievalQueue,
IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private int estimatedRemainingTaskCount;
    private int estimatedTotalChunkCount;
    private final RollingAverage rollingAverageChunkGenTimeInMs = new RollingAverage(1000);

    @Override
    public RollingAverage getRollingAverageChunkGenTimeInMs() {
        return this.rollingAverageChunkGenTimeInMs;
    }

    public RemoteWorldRetrievalQueue(ClientNetworkState networkState, DhClientLevel level) {
        super(networkState, level, false, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
    }

    @Override
    public void startAndSetTargetPos(DhBlockPos2D targetPos) {
        super.tick(targetPos);
    }

    @Override
    public byte lowestDataDetail() {
        return 12;
    }

    @Override
    public byte highestDataDetail() {
        return 0;
    }

    @Override
    public CompletableFuture<WorldGenResult> submitRetrievalTask(long sectionPos, byte requiredDataDetail, IWorldGenTaskTracker tracker) {
        long generationStartMsTime = System.currentTimeMillis();
        return super.submitRequest(sectionPos, fullDataSource -> {
            Objects.requireNonNull(tracker.getDataSourceConsumer()).accept((FullDataSourceV2)fullDataSource);
            fullDataSource.close();
        }).thenApply(requestResult -> {
            long totalGenTimeInMs = System.currentTimeMillis() - generationStartMsTime;
            int chunkWidth = DhSectionPos.getChunkWidth(sectionPos);
            int chunkCount = chunkWidth * chunkWidth;
            double timePerChunk = (double)totalGenTimeInMs / (double)chunkCount;
            this.rollingAverageChunkGenTimeInMs.addValue(timePerChunk);
            switch (requestResult) {
                case SUCCEEDED: {
                    return WorldGenResult.CreateSuccess(sectionPos);
                }
                case FAILED: {
                    return WorldGenResult.CreateFail();
                }
                case REQUIRES_SPLITTING: {
                    ArrayList<CompletableFuture<WorldGenResult>> childFutures = new ArrayList<CompletableFuture<WorldGenResult>>(4);
                    DhSectionPos.forEachChild(sectionPos, childPos -> tracker.shouldGenerateSplitChild(childPos).thenAccept(shouldGenerate -> {
                        if (shouldGenerate.booleanValue()) {
                            childFutures.add(this.submitRetrievalTask(childPos, requiredDataDetail, tracker));
                        }
                    }));
                    return WorldGenResult.CreateSplit(childFutures);
                }
            }
            LodUtil.assertNotReach();
            return WorldGenResult.CreateFail();
        });
    }

    @Override
    public CompletableFuture<Void> startClosingAsync(boolean cancelCurrentGeneration, boolean alsoInterruptRunning) {
        return super.startClosingAsync(alsoInterruptRunning);
    }

    @Override
    protected int getRequestRateLimit() {
        return this.networkState.sessionConfig.getGenerationRequestRateLimit();
    }

    @Override
    protected boolean isSectionAllowedToGenerate(long sectionPos, DhBlockPos2D targetPos) {
        if (this.networkState.sessionConfig.getGenerationBoundsRadius() > 0 && DhSectionPos.getChebyshevSignedBlockDistance(sectionPos, new DhBlockPos2D(this.networkState.sessionConfig.getGenerationBoundsX(), this.networkState.sessionConfig.getGenerationBoundsZ())) > this.networkState.sessionConfig.getGenerationBoundsRadius()) {
            return false;
        }
        return DhSectionPos.getChebyshevSignedBlockDistance(sectionPos, targetPos) <= this.networkState.sessionConfig.getMaxGenerationRequestDistance() * 16;
    }

    @Override
    protected boolean onBeforeRequest(long sectionPos, CompletableFuture<AbstractFullDataNetworkRequestQueue.ERequestResult> future) {
        if (DhSectionPos.getDetailLevel(sectionPos) > 6 && !Config.Server.Experimental.enableNSizedGeneration.get().booleanValue()) {
            future.complete(AbstractFullDataNetworkRequestQueue.ERequestResult.REQUIRES_SPLITTING);
            return false;
        }
        return true;
    }

    @Override
    protected String getQueueName() {
        return "World Remote Generation Queue";
    }

    @Override
    public int getEstimatedRemainingTaskCount() {
        return this.estimatedRemainingTaskCount;
    }

    @Override
    public void setEstimatedRemainingTaskCount(int newEstimate) {
        this.estimatedRemainingTaskCount = newEstimate;
    }

    @Override
    public int getRetrievalEstimatedRemainingChunkCount() {
        return this.estimatedTotalChunkCount;
    }

    @Override
    public void setRetrievalEstimatedRemainingChunkCount(int newEstimate) {
        this.estimatedTotalChunkCount = newEstimate;
    }

    @Override
    public int getQueuedChunkCount() {
        return 0;
    }
}

