/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;

public abstract class Column {
    public static Range around(int p_158165_, int p_158166_) {
        return new Range(p_158165_ - 1, p_158166_ + 1);
    }

    public static Range inside(int p_158189_, int p_158190_) {
        return new Range(p_158189_, p_158190_);
    }

    public static Column below(int p_158163_) {
        return new Ray(p_158163_, false);
    }

    public static Column fromHighest(int p_158187_) {
        return new Ray(p_158187_ + 1, false);
    }

    public static Column above(int p_158194_) {
        return new Ray(p_158194_, true);
    }

    public static Column fromLowest(int p_158196_) {
        return new Ray(p_158196_ - 1, true);
    }

    public static Column line() {
        return Line.INSTANCE;
    }

    public static Column create(OptionalInt p_158184_, OptionalInt p_158185_) {
        if (p_158184_.isPresent() && p_158185_.isPresent()) {
            return Column.inside(p_158184_.getAsInt(), p_158185_.getAsInt());
        }
        if (p_158184_.isPresent()) {
            return Column.above(p_158184_.getAsInt());
        }
        if (p_158185_.isPresent()) {
            return Column.below(p_158185_.getAsInt());
        }
        return Column.line();
    }

    public abstract OptionalInt getCeiling();

    public abstract OptionalInt getFloor();

    public abstract OptionalInt getHeight();

    public Column withFloor(OptionalInt p_158182_) {
        return Column.create(p_158182_, this.getCeiling());
    }

    public Column withCeiling(OptionalInt p_158192_) {
        return Column.create(this.getFloor(), p_158192_);
    }

    public static Optional<Column> scan(LevelSimulatedReader p_158176_, BlockPos p_158177_, int p_158178_, Predicate<BlockState> p_158179_, Predicate<BlockState> p_158180_) {
        BlockPos.MutableBlockPos $$5 = p_158177_.mutable();
        if (!p_158176_.isStateAtPosition(p_158177_, p_158179_)) {
            return Optional.empty();
        }
        int $$6 = p_158177_.getY();
        OptionalInt $$7 = Column.scanDirection(p_158176_, p_158178_, p_158179_, p_158180_, $$5, $$6, Direction.UP);
        OptionalInt $$8 = Column.scanDirection(p_158176_, p_158178_, p_158179_, p_158180_, $$5, $$6, Direction.DOWN);
        return Optional.of(Column.create($$8, $$7));
    }

    private static OptionalInt scanDirection(LevelSimulatedReader p_158168_, int p_158169_, Predicate<BlockState> p_158170_, Predicate<BlockState> p_158171_, BlockPos.MutableBlockPos p_158172_, int p_158173_, Direction p_158174_) {
        p_158172_.setY(p_158173_);
        for (int $$7 = 1; $$7 < p_158169_ && p_158168_.isStateAtPosition(p_158172_, p_158170_); ++$$7) {
            p_158172_.move(p_158174_);
        }
        return p_158168_.isStateAtPosition(p_158172_, p_158171_) ? OptionalInt.of(p_158172_.getY()) : OptionalInt.empty();
    }

    public static final class Range
    extends Column {
        private final int floor;
        private final int ceiling;

        protected Range(int p_158207_, int p_158208_) {
            this.floor = p_158207_;
            this.ceiling = p_158208_;
            if (this.height() < 0) {
                throw new IllegalArgumentException("Column of negative height: " + String.valueOf(this));
            }
        }

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.of(this.ceiling);
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.of(this.floor);
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.of(this.height());
        }

        public int ceiling() {
            return this.ceiling;
        }

        public int floor() {
            return this.floor;
        }

        public int height() {
            return this.ceiling - this.floor - 1;
        }

        public String toString() {
            return "C(" + this.ceiling + "-" + this.floor + ")";
        }
    }

    public static final class Ray
    extends Column {
        private final int edge;
        private final boolean pointingUp;

        public Ray(int p_158219_, boolean p_158220_) {
            this.edge = p_158219_;
            this.pointingUp = p_158220_;
        }

        @Override
        public OptionalInt getCeiling() {
            return this.pointingUp ? OptionalInt.empty() : OptionalInt.of(this.edge);
        }

        @Override
        public OptionalInt getFloor() {
            return this.pointingUp ? OptionalInt.of(this.edge) : OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return this.pointingUp ? "C(" + this.edge + "-)" : "C(-" + this.edge + ")";
        }
    }

    public static final class Line
    extends Column {
        static final Line INSTANCE = new Line();

        private Line() {
        }

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return "C(-)";
        }
    }
}

