/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;

public class DecoratedPotRecipe
extends CustomRecipe {
    public DecoratedPotRecipe(CraftingBookCategory p_273056_) {
        super(p_273056_);
    }

    @Override
    public boolean matches(CraftingInput p_344915_, Level p_272812_) {
        if (!this.canCraftInDimensions(p_344915_.width(), p_344915_.height())) {
            return false;
        }
        block3: for (int $$2 = 0; $$2 < p_344915_.size(); ++$$2) {
            ItemStack $$3 = p_344915_.getItem($$2);
            switch ($$2) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    if ($$3.is(ItemTags.DECORATED_POT_INGREDIENTS)) continue block3;
                    return false;
                }
                default: {
                    if ($$3.is(Items.AIR)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack assemble(CraftingInput p_345761_, HolderLookup.Provider p_335840_) {
        PotDecorations $$2 = new PotDecorations(p_345761_.getItem(1).getItem(), p_345761_.getItem(3).getItem(), p_345761_.getItem(5).getItem(), p_345761_.getItem(7).getItem());
        return DecoratedPotBlockEntity.createDecoratedPotItem($$2);
    }

    @Override
    public boolean canCraftInDimensions(int p_273734_, int p_273516_) {
        return p_273734_ == 3 && p_273516_ == 3;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.DECORATED_POT_RECIPE;
    }
}

