/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Objects;
import net.minecraft.server.level.TicketType;

public final class Ticket<T>
implements Comparable<Ticket<?>> {
    private final TicketType<T> type;
    private final int ticketLevel;
    private final T key;
    private long createdTick;

    protected Ticket(TicketType<T> p_9425_, int p_9426_, T p_9427_) {
        this.type = p_9425_;
        this.ticketLevel = p_9426_;
        this.key = p_9427_;
    }

    @Override
    public int compareTo(Ticket<?> p_9432_) {
        int $$1 = Integer.compare(this.ticketLevel, p_9432_.ticketLevel);
        if ($$1 != 0) {
            return $$1;
        }
        int $$2 = Integer.compare(System.identityHashCode(this.type), System.identityHashCode(p_9432_.type));
        if ($$2 != 0) {
            return $$2;
        }
        return this.type.getComparator().compare(this.key, p_9432_.key);
    }

    public boolean equals(Object p_9439_) {
        if (this == p_9439_) {
            return true;
        }
        if (!(p_9439_ instanceof Ticket)) {
            return false;
        }
        Ticket $$1 = (Ticket)p_9439_;
        return this.ticketLevel == $$1.ticketLevel && Objects.equals(this.type, $$1.type) && Objects.equals(this.key, $$1.key);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.ticketLevel, this.key);
    }

    public String toString() {
        return "Ticket[" + String.valueOf(this.type) + " " + this.ticketLevel + " (" + String.valueOf(this.key) + ")] at " + this.createdTick;
    }

    public TicketType<T> getType() {
        return this.type;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    protected void setCreatedTick(long p_9430_) {
        this.createdTick = p_9430_;
    }

    protected boolean timedOut(long p_9435_) {
        long $$1 = this.type.timeout();
        return $$1 != 0L && p_9435_ - this.createdTick > $$1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((Ticket)object);
    }
}

