/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.WorldDataConfiguration;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> load(InitConfig p_214363_, WorldDataSupplier<D> p_214364_, ResultFactory<D, R> p_214365_, Executor p_214366_, Executor p_214367_) {
        try {
            Pair<WorldDataConfiguration, CloseableResourceManager> $$5 = p_214363_.packConfig.createResourceManager();
            CloseableResourceManager $$6 = (CloseableResourceManager)$$5.getSecond();
            LayeredRegistryAccess<RegistryLayer> $$7 = RegistryLayer.createRegistryAccess();
            LayeredRegistryAccess<RegistryLayer> $$8 = WorldLoader.loadAndReplaceLayer($$6, $$7, RegistryLayer.WORLDGEN, RegistryDataLoader.WORLDGEN_REGISTRIES);
            RegistryAccess.Frozen $$9 = $$8.getAccessForLoading(RegistryLayer.DIMENSIONS);
            RegistryAccess.Frozen $$10 = RegistryDataLoader.load($$6, (RegistryAccess)$$9, RegistryDataLoader.DIMENSION_REGISTRIES);
            WorldDataConfiguration $$11 = (WorldDataConfiguration)$$5.getFirst();
            DataLoadOutput<D> $$12 = p_214364_.get(new DataLoadContext($$6, $$11, $$9, $$10));
            LayeredRegistryAccess<RegistryLayer> $$13 = $$8.replaceFrom(RegistryLayer.DIMENSIONS, $$12.finalDimensions);
            return ((CompletableFuture)ReloadableServerResources.loadResources($$6, $$13, $$11.enabledFeatures(), p_214363_.commandSelection(), p_214363_.functionCompilationLevel(), p_214366_, p_214367_).whenComplete((p_214370_, p_214371_) -> {
                if (p_214371_ != null) {
                    $$6.close();
                }
            })).thenApplyAsync(p_335216_ -> {
                p_335216_.updateRegistryTags();
                return p_214365_.create($$6, (ReloadableServerResources)p_335216_, $$13, p_335215_.cookie);
            }, p_214367_);
        }
        catch (Exception $$14) {
            return CompletableFuture.failedFuture($$14);
        }
    }

    private static RegistryAccess.Frozen loadLayer(ResourceManager p_251529_, LayeredRegistryAccess<RegistryLayer> p_250737_, RegistryLayer p_250790_, List<RegistryDataLoader.RegistryData<?>> p_249516_) {
        RegistryAccess.Frozen $$4 = p_250737_.getAccessForLoading(p_250790_);
        return RegistryDataLoader.load(p_251529_, (RegistryAccess)$$4, p_249516_);
    }

    private static LayeredRegistryAccess<RegistryLayer> loadAndReplaceLayer(ResourceManager p_249913_, LayeredRegistryAccess<RegistryLayer> p_252077_, RegistryLayer p_250346_, List<RegistryDataLoader.RegistryData<?>> p_250589_) {
        RegistryAccess.Frozen $$4 = WorldLoader.loadLayer(p_249913_, p_252077_, p_250346_, p_250589_);
        return p_252077_.replaceFrom(p_250346_, $$4);
    }

    public record InitConfig(PackConfig packConfig, Commands.CommandSelection commandSelection, int functionCompilationLevel) {
    }

    public record PackConfig(PackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean safeMode, boolean initMode) {
        public Pair<WorldDataConfiguration, CloseableResourceManager> createResourceManager() {
            WorldDataConfiguration $$0 = MinecraftServer.configurePackRepository(this.packRepository, this.initialDataConfig, this.initMode, this.safeMode);
            List<PackResources> $$1 = this.packRepository.openAllSelected();
            MultiPackResourceManager $$2 = new MultiPackResourceManager(PackType.SERVER_DATA, $$1);
            return Pair.of((Object)$$0, (Object)$$2);
        }
    }

    public record DataLoadContext(ResourceManager resources, WorldDataConfiguration dataConfiguration, RegistryAccess.Frozen datapackWorldgen, RegistryAccess.Frozen datapackDimensions) {
    }

    @FunctionalInterface
    public static interface WorldDataSupplier<D> {
        public DataLoadOutput<D> get(DataLoadContext var1);
    }

    public record DataLoadOutput<D>(D cookie, RegistryAccess.Frozen finalDimensions) {
    }

    @FunctionalInterface
    public static interface ResultFactory<D, R> {
        public R create(CloseableResourceManager var1, ReloadableServerResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

