/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class PlayerAdvancements {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PlayerList playerList;
    private final Path playerSavePath;
    private AdvancementTree tree;
    private final Map<AdvancementHolder, AdvancementProgress> progress = new LinkedHashMap<AdvancementHolder, AdvancementProgress>();
    private final Set<AdvancementHolder> visible = new HashSet<AdvancementHolder>();
    private final Set<AdvancementHolder> progressChanged = new HashSet<AdvancementHolder>();
    private final Set<AdvancementNode> rootsToUpdate = new HashSet<AdvancementNode>();
    private ServerPlayer player;
    @Nullable
    private AdvancementHolder lastSelectedTab;
    private boolean isFirstPacket = true;
    private final Codec<Data> codec;

    public PlayerAdvancements(DataFixer p_265655_, PlayerList p_265703_, ServerAdvancementManager p_265166_, Path p_265268_, ServerPlayer p_265673_) {
        this.playerList = p_265703_;
        this.playerSavePath = p_265268_;
        this.player = p_265673_;
        this.tree = p_265166_.tree();
        int $$5 = 1343;
        this.codec = DataFixTypes.ADVANCEMENTS.wrapCodec(Data.CODEC, p_265655_, 1343);
        this.load(p_265166_);
    }

    public void setPlayer(ServerPlayer p_135980_) {
        this.player = p_135980_;
    }

    public void stopListening() {
        for (CriterionTrigger criterionTrigger : BuiltInRegistries.TRIGGER_TYPES) {
            criterionTrigger.removePlayerListeners(this);
        }
    }

    public void reload(ServerAdvancementManager p_135982_) {
        this.stopListening();
        this.progress.clear();
        this.visible.clear();
        this.rootsToUpdate.clear();
        this.progressChanged.clear();
        this.isFirstPacket = true;
        this.lastSelectedTab = null;
        this.tree = p_135982_.tree();
        this.load(p_135982_);
    }

    private void registerListeners(ServerAdvancementManager p_135995_) {
        for (AdvancementHolder $$1 : p_135995_.getAllAdvancements()) {
            this.registerListeners($$1);
        }
    }

    private void checkForAutomaticTriggers(ServerAdvancementManager p_136003_) {
        for (AdvancementHolder $$1 : p_136003_.getAllAdvancements()) {
            Advancement $$2 = $$1.value();
            if (!$$2.criteria().isEmpty()) continue;
            this.award($$1, "");
            $$2.rewards().grant(this.player);
        }
    }

    private void load(ServerAdvancementManager p_136007_) {
        if (Files.isRegularFile(this.playerSavePath, new LinkOption[0])) {
            try (JsonReader $$1 = new JsonReader((Reader)Files.newBufferedReader(this.playerSavePath, StandardCharsets.UTF_8));){
                $$1.setLenient(false);
                JsonElement $$2 = Streams.parse((JsonReader)$$1);
                Data $$3 = (Data)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$2).getOrThrow(JsonParseException::new);
                this.applyFrom(p_136007_, $$3);
            }
            catch (JsonIOException | IOException $$4) {
                LOGGER.error("Couldn't access player advancements in {}", (Object)this.playerSavePath, (Object)$$4);
            }
            catch (JsonParseException $$5) {
                LOGGER.error("Couldn't parse player advancements in {}", (Object)this.playerSavePath, (Object)$$5);
            }
        }
        this.checkForAutomaticTriggers(p_136007_);
        this.registerListeners(p_136007_);
    }

    public void save() {
        JsonElement $$0 = (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.asData()).getOrThrow();
        try {
            FileUtil.createDirectoriesSafe(this.playerSavePath.getParent());
            try (BufferedWriter $$1 = Files.newBufferedWriter(this.playerSavePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson($$0, GSON.newJsonWriter((Writer)$$1));
            }
        }
        catch (JsonIOException | IOException $$2) {
            LOGGER.error("Couldn't save player advancements to {}", (Object)this.playerSavePath, (Object)$$2);
        }
    }

    private void applyFrom(ServerAdvancementManager p_301166_, Data p_301198_) {
        p_301198_.forEach((p_300732_, p_300733_) -> {
            AdvancementHolder $$3 = p_301166_.get((ResourceLocation)p_300732_);
            if ($$3 == null) {
                LOGGER.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", p_300732_, (Object)this.playerSavePath);
                return;
            }
            this.startProgress($$3, (AdvancementProgress)p_300733_);
            this.progressChanged.add($$3);
            this.markForVisibilityUpdate($$3);
        });
    }

    private Data asData() {
        LinkedHashMap<ResourceLocation, AdvancementProgress> $$0 = new LinkedHashMap<ResourceLocation, AdvancementProgress>();
        this.progress.forEach((p_300724_, p_300725_) -> {
            if (p_300725_.hasProgress()) {
                $$0.put(p_300724_.id(), (AdvancementProgress)p_300725_);
            }
        });
        return new Data($$0);
    }

    public boolean award(AdvancementHolder p_300979_, String p_135990_) {
        boolean $$2 = false;
        AdvancementProgress $$3 = this.getOrStartProgress(p_300979_);
        boolean $$4 = $$3.isDone();
        if ($$3.grantProgress(p_135990_)) {
            this.unregisterListeners(p_300979_);
            this.progressChanged.add(p_300979_);
            $$2 = true;
            if (!$$4 && $$3.isDone()) {
                p_300979_.value().rewards().grant(this.player);
                p_300979_.value().display().ifPresent(p_352686_ -> {
                    if (p_352686_.shouldAnnounceChat() && this.player.level().getGameRules().getBoolean(GameRules.RULE_ANNOUNCE_ADVANCEMENTS)) {
                        this.playerList.broadcastSystemMessage(p_352686_.getType().createAnnouncement(p_300979_, this.player), false);
                    }
                });
            }
        }
        if (!$$4 && $$3.isDone()) {
            this.markForVisibilityUpdate(p_300979_);
        }
        return $$2;
    }

    public boolean revoke(AdvancementHolder p_301073_, String p_136000_) {
        boolean $$2 = false;
        AdvancementProgress $$3 = this.getOrStartProgress(p_301073_);
        boolean $$4 = $$3.isDone();
        if ($$3.revokeProgress(p_136000_)) {
            this.registerListeners(p_301073_);
            this.progressChanged.add(p_301073_);
            $$2 = true;
        }
        if ($$4 && !$$3.isDone()) {
            this.markForVisibilityUpdate(p_301073_);
        }
        return $$2;
    }

    private void markForVisibilityUpdate(AdvancementHolder p_301097_) {
        AdvancementNode $$1 = this.tree.get(p_301097_);
        if ($$1 != null) {
            this.rootsToUpdate.add($$1.root());
        }
    }

    private void registerListeners(AdvancementHolder p_301053_) {
        AdvancementProgress $$1 = this.getOrStartProgress(p_301053_);
        if ($$1.isDone()) {
            return;
        }
        for (Map.Entry<String, Criterion<?>> $$2 : p_301053_.value().criteria().entrySet()) {
            CriterionProgress $$3 = $$1.getCriterion($$2.getKey());
            if ($$3 == null || $$3.isDone()) continue;
            this.registerListener(p_301053_, $$2.getKey(), $$2.getValue());
        }
    }

    private <T extends CriterionTriggerInstance> void registerListener(AdvancementHolder p_301059_, String p_300946_, Criterion<T> p_300887_) {
        p_300887_.trigger().addPlayerListener(this, new CriterionTrigger.Listener<T>(p_300887_.triggerInstance(), p_301059_, p_300946_));
    }

    private void unregisterListeners(AdvancementHolder p_301082_) {
        AdvancementProgress $$1 = this.getOrStartProgress(p_301082_);
        for (Map.Entry<String, Criterion<?>> $$2 : p_301082_.value().criteria().entrySet()) {
            CriterionProgress $$3 = $$1.getCriterion($$2.getKey());
            if ($$3 == null || !$$3.isDone() && !$$1.isDone()) continue;
            this.removeListener(p_301082_, $$2.getKey(), $$2.getValue());
        }
    }

    private <T extends CriterionTriggerInstance> void removeListener(AdvancementHolder p_301213_, String p_301253_, Criterion<T> p_301311_) {
        p_301311_.trigger().removePlayerListener(this, new CriterionTrigger.Listener<T>(p_301311_.triggerInstance(), p_301213_, p_301253_));
    }

    public void flushDirty(ServerPlayer p_135993_) {
        if (this.isFirstPacket || !this.rootsToUpdate.isEmpty() || !this.progressChanged.isEmpty()) {
            HashMap<ResourceLocation, AdvancementProgress> $$1 = new HashMap<ResourceLocation, AdvancementProgress>();
            HashSet<AdvancementHolder> $$2 = new HashSet<AdvancementHolder>();
            HashSet<ResourceLocation> $$3 = new HashSet<ResourceLocation>();
            for (AdvancementNode $$4 : this.rootsToUpdate) {
                this.updateTreeVisibility($$4, $$2, $$3);
            }
            this.rootsToUpdate.clear();
            for (AdvancementHolder $$5 : this.progressChanged) {
                if (!this.visible.contains($$5)) continue;
                $$1.put($$5.id(), this.progress.get($$5));
            }
            this.progressChanged.clear();
            if (!($$1.isEmpty() && $$2.isEmpty() && $$3.isEmpty())) {
                p_135993_.connection.send(new ClientboundUpdateAdvancementsPacket(this.isFirstPacket, $$2, $$3, $$1));
            }
        }
        this.isFirstPacket = false;
    }

    public void setSelectedTab(@Nullable AdvancementHolder p_301180_) {
        AdvancementHolder $$1 = this.lastSelectedTab;
        this.lastSelectedTab = p_301180_ != null && p_301180_.value().isRoot() && p_301180_.value().display().isPresent() ? p_301180_ : null;
        if ($$1 != this.lastSelectedTab) {
            this.player.connection.send(new ClientboundSelectAdvancementsTabPacket(this.lastSelectedTab == null ? null : this.lastSelectedTab.id()));
        }
    }

    public AdvancementProgress getOrStartProgress(AdvancementHolder p_301185_) {
        AdvancementProgress $$1 = this.progress.get(p_301185_);
        if ($$1 == null) {
            $$1 = new AdvancementProgress();
            this.startProgress(p_301185_, $$1);
        }
        return $$1;
    }

    private void startProgress(AdvancementHolder p_300931_, AdvancementProgress p_135987_) {
        p_135987_.update(p_300931_.value().requirements());
        this.progress.put(p_300931_, p_135987_);
    }

    private void updateTreeVisibility(AdvancementNode p_301178_, Set<AdvancementHolder> p_265206_, Set<ResourceLocation> p_265593_) {
        AdvancementVisibilityEvaluator.evaluateVisibility(p_301178_, p_300726_ -> this.getOrStartProgress(p_300726_.holder()).isDone(), (p_300729_, p_300730_) -> {
            AdvancementHolder $$4 = p_300729_.holder();
            if (p_300730_) {
                if (this.visible.add($$4)) {
                    p_265206_.add($$4);
                    if (this.progress.containsKey($$4)) {
                        this.progressChanged.add($$4);
                    }
                }
            } else if (this.visible.remove($$4)) {
                p_265593_.add($$4.id());
            }
        });
    }

    record Data(Map<ResourceLocation, AdvancementProgress> map) {
        public static final Codec<Data> CODEC = Codec.unboundedMap(ResourceLocation.CODEC, AdvancementProgress.CODEC).xmap(Data::new, Data::map);

        public void forEach(BiConsumer<ResourceLocation, AdvancementProgress> p_300973_) {
            this.map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach((? super T p_301323_) -> p_300973_.accept((ResourceLocation)p_301323_.getKey(), (AdvancementProgress)p_301323_.getValue()));
        }
    }
}

