/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.TrappedChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityWithoutLevelRenderer
implements ResourceManagerReloadListener {
    private static final ShulkerBoxBlockEntity[] SHULKER_BOXES = (ShulkerBoxBlockEntity[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::getId)).map(p_172557_ -> new ShulkerBoxBlockEntity((DyeColor)p_172557_, BlockPos.ZERO, Blocks.SHULKER_BOX.defaultBlockState())).toArray(ShulkerBoxBlockEntity[]::new);
    private static final ShulkerBoxBlockEntity DEFAULT_SHULKER_BOX = new ShulkerBoxBlockEntity(BlockPos.ZERO, Blocks.SHULKER_BOX.defaultBlockState());
    private final ChestBlockEntity chest = new ChestBlockEntity(BlockPos.ZERO, Blocks.CHEST.defaultBlockState());
    private final ChestBlockEntity trappedChest = new TrappedChestBlockEntity(BlockPos.ZERO, Blocks.TRAPPED_CHEST.defaultBlockState());
    private final EnderChestBlockEntity enderChest = new EnderChestBlockEntity(BlockPos.ZERO, Blocks.ENDER_CHEST.defaultBlockState());
    private final BannerBlockEntity banner = new BannerBlockEntity(BlockPos.ZERO, Blocks.WHITE_BANNER.defaultBlockState());
    private final BedBlockEntity bed = new BedBlockEntity(BlockPos.ZERO, Blocks.RED_BED.defaultBlockState());
    private final ConduitBlockEntity conduit = new ConduitBlockEntity(BlockPos.ZERO, Blocks.CONDUIT.defaultBlockState());
    private final DecoratedPotBlockEntity decoratedPot = new DecoratedPotBlockEntity(BlockPos.ZERO, Blocks.DECORATED_POT.defaultBlockState());
    private ShieldModel shieldModel;
    private TridentModel tridentModel;
    private Map<SkullBlock.Type, SkullModelBase> skullModels;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final EntityModelSet entityModelSet;

    public BlockEntityWithoutLevelRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        this.blockEntityRenderDispatcher = p_172550_;
        this.entityModelSet = p_172551_;
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_172555_) {
        this.shieldModel = new ShieldModel(this.entityModelSet.bakeLayer(ModelLayers.SHIELD));
        this.tridentModel = new TridentModel(this.entityModelSet.bakeLayer(ModelLayers.TRIDENT));
        this.skullModels = SkullBlockRenderer.createSkullRenderers(this.entityModelSet);
    }

    /*
     * WARNING - void declaration
     */
    public void renderByItem(ItemStack p_108830_, ItemDisplayContext p_270899_, PoseStack p_108832_, MultiBufferSource p_108833_, int p_108834_, int p_108835_) {
        Item $$6 = p_108830_.getItem();
        if ($$6 instanceof BlockItem) {
            void $$23;
            Block $$7 = ((BlockItem)$$6).getBlock();
            if ($$7 instanceof AbstractSkullBlock) {
                AbstractSkullBlock $$8 = (AbstractSkullBlock)$$7;
                ResolvableProfile $$9 = p_108830_.get(DataComponents.PROFILE);
                if ($$9 != null && !$$9.isResolved()) {
                    p_108830_.remove(DataComponents.PROFILE);
                    $$9.resolve().thenAcceptAsync(p_329787_ -> p_108830_.set(DataComponents.PROFILE, p_329787_), (Executor)Minecraft.getInstance());
                    $$9 = null;
                }
                SkullModelBase $$10 = this.skullModels.get($$8.getType());
                RenderType $$11 = SkullBlockRenderer.getRenderType($$8.getType(), $$9);
                SkullBlockRenderer.renderSkull(null, 180.0f, 0.0f, p_108832_, p_108833_, p_108834_, $$10, $$11);
                return;
            }
            BlockState $$12 = $$7.defaultBlockState();
            if ($$7 instanceof AbstractBannerBlock) {
                this.banner.fromItem(p_108830_, ((AbstractBannerBlock)$$7).getColor());
                BannerBlockEntity $$13 = this.banner;
            } else if ($$7 instanceof BedBlock) {
                this.bed.setColor(((BedBlock)$$7).getColor());
                BedBlockEntity $$14 = this.bed;
            } else if ($$12.is(Blocks.CONDUIT)) {
                ConduitBlockEntity $$15 = this.conduit;
            } else if ($$12.is(Blocks.CHEST)) {
                ChestBlockEntity $$16 = this.chest;
            } else if ($$12.is(Blocks.ENDER_CHEST)) {
                EnderChestBlockEntity $$17 = this.enderChest;
            } else if ($$12.is(Blocks.TRAPPED_CHEST)) {
                ChestBlockEntity $$18 = this.trappedChest;
            } else if ($$12.is(Blocks.DECORATED_POT)) {
                this.decoratedPot.setFromItem(p_108830_);
                DecoratedPotBlockEntity $$19 = this.decoratedPot;
            } else if ($$7 instanceof ShulkerBoxBlock) {
                DyeColor $$20 = ShulkerBoxBlock.getColorFromItem($$6);
                if ($$20 == null) {
                    ShulkerBoxBlockEntity $$21 = DEFAULT_SHULKER_BOX;
                } else {
                    ShulkerBoxBlockEntity $$22 = SHULKER_BOXES[$$20.getId()];
                }
            } else {
                return;
            }
            this.blockEntityRenderDispatcher.renderItem($$23, p_108832_, p_108833_, p_108834_, p_108835_);
            return;
        }
        if (p_108830_.is(Items.SHIELD)) {
            BannerPatternLayers $$24 = p_108830_.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY);
            DyeColor $$25 = p_108830_.get(DataComponents.BASE_COLOR);
            boolean $$26 = !$$24.layers().isEmpty() || $$25 != null;
            p_108832_.pushPose();
            p_108832_.scale(1.0f, -1.0f, -1.0f);
            Material $$27 = $$26 ? ModelBakery.SHIELD_BASE : ModelBakery.NO_PATTERN_SHIELD;
            VertexConsumer $$28 = $$27.sprite().wrap(ItemRenderer.getFoilBufferDirect(p_108833_, this.shieldModel.renderType($$27.atlasLocation()), true, p_108830_.hasFoil()));
            this.shieldModel.handle().render(p_108832_, $$28, p_108834_, p_108835_);
            if ($$26) {
                BannerRenderer.renderPatterns(p_108832_, p_108833_, p_108834_, p_108835_, this.shieldModel.plate(), $$27, false, Objects.requireNonNullElse($$25, DyeColor.WHITE), $$24, p_108830_.hasFoil());
            } else {
                this.shieldModel.plate().render(p_108832_, $$28, p_108834_, p_108835_);
            }
            p_108832_.popPose();
        } else if (p_108830_.is(Items.TRIDENT)) {
            p_108832_.pushPose();
            p_108832_.scale(1.0f, -1.0f, -1.0f);
            VertexConsumer $$29 = ItemRenderer.getFoilBufferDirect(p_108833_, this.tridentModel.renderType(TridentModel.TEXTURE), false, p_108830_.hasFoil());
            this.tridentModel.renderToBuffer(p_108832_, $$29, p_108834_, p_108835_);
            p_108832_.popPose();
        }
    }
}

