/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.DebugQueryHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.DemoIntroScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerReconfigScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ChunkBatchSizeCalculator;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.DebugSampleSubscriber;
import net.minecraft.client.multiplayer.LevelLoadStatusManager;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.PingDebugMonitor;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.multiplayer.TagCollector;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateRenderer;
import net.minecraft.client.renderer.debug.VillageSectionsDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptRenderer;
import net.minecraft.client.resources.sounds.BeeAggressiveSoundInstance;
import net.minecraft.client.resources.sounds.BeeFlyingSoundInstance;
import net.minecraft.client.resources.sounds.GuardianAttackSoundInstance;
import net.minecraft.client.resources.sounds.MinecartSoundInstance;
import net.minecraft.client.resources.sounds.SnifferSoundInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessagesTracker;
import net.minecraft.network.chat.LocalChatSession;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.BeeDebugPayload;
import net.minecraft.network.protocol.common.custom.BrainDebugPayload;
import net.minecraft.network.protocol.common.custom.BreezeDebugPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameEventListenerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.HiveDebugPayload;
import net.minecraft.network.protocol.common.custom.NeighborUpdatesDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiAddedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiRemovedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiTicketCountDebugPayload;
import net.minecraft.network.protocol.common.custom.RaidsDebugPayload;
import net.minecraft.network.protocol.common.custom.StructuresDebugPayload;
import net.minecraft.network.protocol.common.custom.VillageSectionsDebugPayload;
import net.minecraft.network.protocol.common.custom.WorldGenAttemptDebugPayload;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundDebugSamplePacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTickingStatePacket;
import net.minecraft.network.protocol.game.ClientboundTickingStepPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Crypt;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.slf4j.Logger;

public class ClientPacketListener
extends ClientCommonPacketListenerImpl
implements ClientGamePacketListener,
TickablePacketListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component UNSECURE_SERVER_TOAST_TITLE = Component.translatable("multiplayer.unsecureserver.toast.title");
    private static final Component UNSERURE_SERVER_TOAST = Component.translatable("multiplayer.unsecureserver.toast");
    private static final Component INVALID_PACKET = Component.translatable("multiplayer.disconnect.invalid_packet");
    private static final Component CHAT_VALIDATION_FAILED_ERROR = Component.translatable("multiplayer.disconnect.chat_validation_failed");
    private static final Component RECONFIGURE_SCREEN_MESSAGE = Component.translatable("connect.reconfiguring");
    private static final int PENDING_OFFSET_THRESHOLD = 64;
    private final GameProfile localGameProfile;
    private ClientLevel level;
    private ClientLevel.ClientLevelData levelData;
    private final Map<UUID, PlayerInfo> playerInfoMap = Maps.newHashMap();
    private final Set<PlayerInfo> listedPlayers = new ReferenceOpenHashSet();
    private final ClientAdvancements advancements;
    private final ClientSuggestionProvider suggestionsProvider;
    private final DebugQueryHandler debugQueryHandler = new DebugQueryHandler(this);
    private int serverChunkRadius = 3;
    private int serverSimulationDistance = 3;
    private final RandomSource random = RandomSource.createThreadSafe();
    private CommandDispatcher<SharedSuggestionProvider> commands = new CommandDispatcher();
    private final RecipeManager recipeManager;
    private final UUID id = UUID.randomUUID();
    private Set<ResourceKey<Level>> levels;
    private final RegistryAccess.Frozen registryAccess;
    private final FeatureFlagSet enabledFeatures;
    private final PotionBrewing potionBrewing;
    @Nullable
    private LocalChatSession chatSession;
    private SignedMessageChain.Encoder signedMessageEncoder = SignedMessageChain.Encoder.UNSIGNED;
    private LastSeenMessagesTracker lastSeenMessages = new LastSeenMessagesTracker(20);
    private MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final ChunkBatchSizeCalculator chunkBatchSizeCalculator = new ChunkBatchSizeCalculator();
    private final PingDebugMonitor pingDebugMonitor;
    private final DebugSampleSubscriber debugSampleSubscriber;
    @Nullable
    private LevelLoadStatusManager levelLoadStatusManager;
    private boolean serverEnforcesSecureChat;
    private boolean seenInsecureChatWarning = false;
    private volatile boolean closed;
    private final Scoreboard scoreboard = new Scoreboard();
    private final SessionSearchTrees searchTrees = new SessionSearchTrees();

    public ClientPacketListener(Minecraft p_253924_, Connection p_253614_, CommonListenerCookie p_295121_) {
        super(p_253924_, p_253614_, p_295121_);
        this.localGameProfile = p_295121_.localGameProfile();
        this.registryAccess = p_295121_.receivedRegistries();
        this.enabledFeatures = p_295121_.enabledFeatures();
        this.advancements = new ClientAdvancements(p_253924_, this.telemetryManager);
        this.suggestionsProvider = new ClientSuggestionProvider(this, p_253924_);
        this.pingDebugMonitor = new PingDebugMonitor(this, p_253924_.getDebugOverlay().getPingLogger());
        this.recipeManager = new RecipeManager(this.registryAccess);
        this.debugSampleSubscriber = new DebugSampleSubscriber(this, p_253924_.getDebugOverlay());
        if (p_295121_.chatState() != null) {
            p_253924_.gui.getChat().restoreState(p_295121_.chatState());
        }
        this.potionBrewing = PotionBrewing.bootstrap(this.enabledFeatures);
    }

    public ClientSuggestionProvider getSuggestionsProvider() {
        return this.suggestionsProvider;
    }

    public void close() {
        this.closed = true;
        this.clearLevel();
        this.telemetryManager.onDisconnect();
    }

    public void clearLevel() {
        this.level = null;
        this.levelLoadStatusManager = null;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public void handleLogin(ClientboundLoginPacket p_105030_) {
        ClientLevel.ClientLevelData $$7;
        PacketUtils.ensureRunningOnSameThread(p_105030_, this, this.minecraft);
        this.minecraft.gameMode = new MultiPlayerGameMode(this.minecraft, this);
        CommonPlayerSpawnInfo $$1 = p_105030_.commonPlayerSpawnInfo();
        ArrayList $$2 = Lists.newArrayList(p_105030_.levels());
        Collections.shuffle($$2);
        this.levels = Sets.newLinkedHashSet((Iterable)$$2);
        ResourceKey<Level> $$3 = $$1.dimension();
        Holder<DimensionType> $$4 = $$1.dimensionType();
        this.serverChunkRadius = p_105030_.chunkRadius();
        this.serverSimulationDistance = p_105030_.simulationDistance();
        boolean $$5 = $$1.isDebug();
        boolean $$6 = $$1.isFlat();
        this.levelData = $$7 = new ClientLevel.ClientLevelData(Difficulty.NORMAL, p_105030_.hardcore(), $$6);
        this.level = new ClientLevel(this, $$7, $$3, $$4, this.serverChunkRadius, this.serverSimulationDistance, this.minecraft::getProfiler, this.minecraft.levelRenderer, $$5, $$1.seed());
        this.minecraft.setLevel(this.level, ReceivingLevelScreen.Reason.OTHER);
        if (this.minecraft.player == null) {
            this.minecraft.player = this.minecraft.gameMode.createPlayer(this.level, new StatsCounter(), new ClientRecipeBook());
            this.minecraft.player.setYRot(-180.0f);
            if (this.minecraft.getSingleplayerServer() != null) {
                this.minecraft.getSingleplayerServer().setUUID(this.minecraft.player.getUUID());
            }
        }
        this.minecraft.debugRenderer.clear();
        this.minecraft.player.resetPos();
        this.minecraft.player.setId(p_105030_.playerId());
        this.level.addEntity(this.minecraft.player);
        this.minecraft.player.input = new KeyboardInput(this.minecraft.options);
        this.minecraft.gameMode.adjustPlayer(this.minecraft.player);
        this.minecraft.cameraEntity = this.minecraft.player;
        this.startWaitingForNewLevel(this.minecraft.player, this.level, ReceivingLevelScreen.Reason.OTHER);
        this.minecraft.player.setReducedDebugInfo(p_105030_.reducedDebugInfo());
        this.minecraft.player.setShowDeathScreen(p_105030_.showDeathScreen());
        this.minecraft.player.setDoLimitedCrafting(p_105030_.doLimitedCrafting());
        this.minecraft.player.setLastDeathLocation($$1.lastDeathLocation());
        this.minecraft.player.setPortalCooldown($$1.portalCooldown());
        this.minecraft.gameMode.setLocalMode($$1.gameType(), $$1.previousGameType());
        this.minecraft.options.setServerRenderDistance(p_105030_.chunkRadius());
        this.chatSession = null;
        this.lastSeenMessages = new LastSeenMessagesTracker(20);
        this.messageSignatureCache = MessageSignatureCache.createDefault();
        if (this.connection.isEncrypted()) {
            this.minecraft.getProfileKeyPairManager().prepareKeyPair().thenAcceptAsync(p_253341_ -> p_253341_.ifPresent(this::setKeyPair), (Executor)this.minecraft);
        }
        this.telemetryManager.onPlayerInfoReceived($$1.gameType(), p_105030_.hardcore());
        this.minecraft.quickPlayLog().log(this.minecraft);
        this.serverEnforcesSecureChat = p_105030_.enforcesSecureChat();
        if (this.serverData != null && !this.seenInsecureChatWarning && !this.enforcesSecureChat()) {
            SystemToast $$8 = SystemToast.multiline(this.minecraft, SystemToast.SystemToastId.UNSECURE_SERVER_WARNING, UNSECURE_SERVER_TOAST_TITLE, UNSERURE_SERVER_TOAST);
            this.minecraft.getToasts().addToast($$8);
            this.seenInsecureChatWarning = true;
        }
    }

    @Override
    public void handleAddEntity(ClientboundAddEntityPacket p_104958_) {
        PacketUtils.ensureRunningOnSameThread(p_104958_, this, this.minecraft);
        Entity $$1 = this.createEntityFromPacket(p_104958_);
        if ($$1 != null) {
            $$1.recreateFromPacket(p_104958_);
            this.level.addEntity($$1);
            this.postAddEntitySoundInstance($$1);
        } else {
            LOGGER.warn("Skipping Entity with id {}", p_104958_.getType());
        }
    }

    @Nullable
    private Entity createEntityFromPacket(ClientboundAddEntityPacket p_302232_) {
        EntityType<?> $$1 = p_302232_.getType();
        if ($$1 == EntityType.PLAYER) {
            PlayerInfo $$2 = this.getPlayerInfo(p_302232_.getUUID());
            if ($$2 == null) {
                LOGGER.warn("Server attempted to add player prior to sending player info (Player id {})", (Object)p_302232_.getUUID());
                return null;
            }
            return new RemotePlayer(this.level, $$2.getProfile());
        }
        return $$1.create(this.level);
    }

    private void postAddEntitySoundInstance(Entity p_233664_) {
        if (p_233664_ instanceof AbstractMinecart) {
            AbstractMinecart $$1 = (AbstractMinecart)p_233664_;
            this.minecraft.getSoundManager().play(new MinecartSoundInstance($$1));
        } else if (p_233664_ instanceof Bee) {
            BeeFlyingSoundInstance $$5;
            Bee $$2 = (Bee)p_233664_;
            boolean $$3 = $$2.isAngry();
            if ($$3) {
                BeeAggressiveSoundInstance $$4 = new BeeAggressiveSoundInstance($$2);
            } else {
                $$5 = new BeeFlyingSoundInstance($$2);
            }
            this.minecraft.getSoundManager().queueTickingSound($$5);
        }
    }

    @Override
    public void handleAddExperienceOrb(ClientboundAddExperienceOrbPacket p_104960_) {
        PacketUtils.ensureRunningOnSameThread(p_104960_, this, this.minecraft);
        double $$1 = p_104960_.getX();
        double $$2 = p_104960_.getY();
        double $$3 = p_104960_.getZ();
        ExperienceOrb $$4 = new ExperienceOrb(this.level, $$1, $$2, $$3, p_104960_.getValue());
        $$4.syncPacketPositionCodec($$1, $$2, $$3);
        $$4.setYRot(0.0f);
        $$4.setXRot(0.0f);
        $$4.setId(p_104960_.getId());
        this.level.addEntity($$4);
    }

    @Override
    public void handleSetEntityMotion(ClientboundSetEntityMotionPacket p_105092_) {
        PacketUtils.ensureRunningOnSameThread(p_105092_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105092_.getId());
        if ($$1 == null) {
            return;
        }
        $$1.lerpMotion(p_105092_.getXa(), p_105092_.getYa(), p_105092_.getZa());
    }

    @Override
    public void handleSetEntityData(ClientboundSetEntityDataPacket p_105088_) {
        PacketUtils.ensureRunningOnSameThread(p_105088_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105088_.id());
        if ($$1 != null) {
            $$1.getEntityData().assignValues(p_105088_.packedItems());
        }
    }

    @Override
    public void handleTeleportEntity(ClientboundTeleportEntityPacket p_105124_) {
        PacketUtils.ensureRunningOnSameThread(p_105124_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105124_.getId());
        if ($$1 == null) {
            return;
        }
        double $$2 = p_105124_.getX();
        double $$3 = p_105124_.getY();
        double $$4 = p_105124_.getZ();
        $$1.syncPacketPositionCodec($$2, $$3, $$4);
        if (!$$1.isControlledByLocalInstance()) {
            float $$5 = (float)(p_105124_.getyRot() * 360) / 256.0f;
            float $$6 = (float)(p_105124_.getxRot() * 360) / 256.0f;
            $$1.lerpTo($$2, $$3, $$4, $$5, $$6, 3);
            $$1.setOnGround(p_105124_.isOnGround());
        }
    }

    @Override
    public void handleTickingState(ClientboundTickingStatePacket p_309203_) {
        PacketUtils.ensureRunningOnSameThread(p_309203_, this, this.minecraft);
        if (this.minecraft.level == null) {
            return;
        }
        TickRateManager $$1 = this.minecraft.level.tickRateManager();
        $$1.setTickRate(p_309203_.tickRate());
        $$1.setFrozen(p_309203_.isFrozen());
    }

    @Override
    public void handleTickingStep(ClientboundTickingStepPacket p_308901_) {
        PacketUtils.ensureRunningOnSameThread(p_308901_, this, this.minecraft);
        if (this.minecraft.level == null) {
            return;
        }
        TickRateManager $$1 = this.minecraft.level.tickRateManager();
        $$1.setFrozenTicksToRun(p_308901_.tickSteps());
    }

    @Override
    public void handleSetCarriedItem(ClientboundSetCarriedItemPacket p_105078_) {
        PacketUtils.ensureRunningOnSameThread(p_105078_, this, this.minecraft);
        if (Inventory.isHotbarSlot(p_105078_.getSlot())) {
            this.minecraft.player.getInventory().selected = p_105078_.getSlot();
        }
    }

    @Override
    public void handleMoveEntity(ClientboundMoveEntityPacket p_105036_) {
        PacketUtils.ensureRunningOnSameThread(p_105036_, this, this.minecraft);
        Entity $$1 = p_105036_.getEntity(this.level);
        if ($$1 == null) {
            return;
        }
        if (!$$1.isControlledByLocalInstance()) {
            if (p_105036_.hasPosition()) {
                VecDeltaCodec $$2 = $$1.getPositionCodec();
                Vec3 $$3 = $$2.decode(p_105036_.getXa(), p_105036_.getYa(), p_105036_.getZa());
                $$2.setBase($$3);
                float $$4 = p_105036_.hasRotation() ? (float)(p_105036_.getyRot() * 360) / 256.0f : $$1.lerpTargetYRot();
                float $$5 = p_105036_.hasRotation() ? (float)(p_105036_.getxRot() * 360) / 256.0f : $$1.lerpTargetXRot();
                $$1.lerpTo($$3.x(), $$3.y(), $$3.z(), $$4, $$5, 3);
            } else if (p_105036_.hasRotation()) {
                float $$6 = (float)(p_105036_.getyRot() * 360) / 256.0f;
                float $$7 = (float)(p_105036_.getxRot() * 360) / 256.0f;
                $$1.lerpTo($$1.lerpTargetX(), $$1.lerpTargetY(), $$1.lerpTargetZ(), $$6, $$7, 3);
            }
            $$1.setOnGround(p_105036_.isOnGround());
        }
    }

    @Override
    public void handleRotateMob(ClientboundRotateHeadPacket p_105068_) {
        PacketUtils.ensureRunningOnSameThread(p_105068_, this, this.minecraft);
        Entity $$1 = p_105068_.getEntity(this.level);
        if ($$1 == null) {
            return;
        }
        float $$2 = (float)(p_105068_.getYHeadRot() * 360) / 256.0f;
        $$1.lerpHeadTo($$2, 3);
    }

    @Override
    public void handleRemoveEntities(ClientboundRemoveEntitiesPacket p_182633_) {
        PacketUtils.ensureRunningOnSameThread(p_182633_, this, this.minecraft);
        p_182633_.getEntityIds().forEach(p_205521_ -> this.level.removeEntity(p_205521_, Entity.RemovalReason.DISCARDED));
    }

    @Override
    public void handleMovePlayer(ClientboundPlayerPositionPacket p_105056_) {
        double $$17;
        double $$16;
        double $$13;
        double $$12;
        double $$9;
        double $$8;
        PacketUtils.ensureRunningOnSameThread(p_105056_, this, this.minecraft);
        LocalPlayer $$1 = this.minecraft.player;
        Vec3 $$2 = $$1.getDeltaMovement();
        boolean $$3 = p_105056_.getRelativeArguments().contains((Object)RelativeMovement.X);
        boolean $$4 = p_105056_.getRelativeArguments().contains((Object)RelativeMovement.Y);
        boolean $$5 = p_105056_.getRelativeArguments().contains((Object)RelativeMovement.Z);
        if ($$3) {
            double $$6 = $$2.x();
            double $$7 = $$1.getX() + p_105056_.getX();
            $$1.xOld += p_105056_.getX();
            $$1.xo += p_105056_.getX();
        } else {
            $$8 = 0.0;
            $$1.xOld = $$9 = p_105056_.getX();
            $$1.xo = $$9;
        }
        if ($$4) {
            double $$10 = $$2.y();
            double $$11 = $$1.getY() + p_105056_.getY();
            $$1.yOld += p_105056_.getY();
            $$1.yo += p_105056_.getY();
        } else {
            $$12 = 0.0;
            $$1.yOld = $$13 = p_105056_.getY();
            $$1.yo = $$13;
        }
        if ($$5) {
            double $$14 = $$2.z();
            double $$15 = $$1.getZ() + p_105056_.getZ();
            $$1.zOld += p_105056_.getZ();
            $$1.zo += p_105056_.getZ();
        } else {
            $$16 = 0.0;
            $$1.zOld = $$17 = p_105056_.getZ();
            $$1.zo = $$17;
        }
        $$1.setPos($$9, $$13, $$17);
        $$1.setDeltaMovement($$8, $$12, $$16);
        float $$18 = p_105056_.getYRot();
        float $$19 = p_105056_.getXRot();
        if (p_105056_.getRelativeArguments().contains((Object)RelativeMovement.X_ROT)) {
            $$1.setXRot($$1.getXRot() + $$19);
            $$1.xRotO += $$19;
        } else {
            $$1.setXRot($$19);
            $$1.xRotO = $$19;
        }
        if (p_105056_.getRelativeArguments().contains((Object)RelativeMovement.Y_ROT)) {
            $$1.setYRot($$1.getYRot() + $$18);
            $$1.yRotO += $$18;
        } else {
            $$1.setYRot($$18);
            $$1.yRotO = $$18;
        }
        this.connection.send(new ServerboundAcceptTeleportationPacket(p_105056_.getId()));
        this.connection.send(new ServerboundMovePlayerPacket.PosRot($$1.getX(), $$1.getY(), $$1.getZ(), $$1.getYRot(), $$1.getXRot(), false));
    }

    @Override
    public void handleChunkBlocksUpdate(ClientboundSectionBlocksUpdatePacket p_105070_) {
        PacketUtils.ensureRunningOnSameThread(p_105070_, this, this.minecraft);
        p_105070_.runUpdates((p_284633_, p_284634_) -> this.level.setServerVerifiedBlockState((BlockPos)p_284633_, (BlockState)p_284634_, 19));
    }

    @Override
    public void handleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket p_194241_) {
        PacketUtils.ensureRunningOnSameThread(p_194241_, this, this.minecraft);
        int $$1 = p_194241_.getX();
        int $$2 = p_194241_.getZ();
        this.updateLevelChunk($$1, $$2, p_194241_.getChunkData());
        ClientboundLightUpdatePacketData $$3 = p_194241_.getLightData();
        this.level.queueLightUpdate(() -> {
            this.applyLightData($$1, $$2, $$3);
            LevelChunk $$3 = this.level.getChunkSource().getChunk($$1, $$2, false);
            if ($$3 != null) {
                this.enableChunkLight($$3, $$1, $$2);
            }
        });
    }

    @Override
    public void handleChunksBiomes(ClientboundChunksBiomesPacket p_275437_) {
        PacketUtils.ensureRunningOnSameThread(p_275437_, this, this.minecraft);
        for (ClientboundChunksBiomesPacket.ChunkBiomeData $$1 : p_275437_.chunkBiomeData()) {
            this.level.getChunkSource().replaceBiomes($$1.pos().x, $$1.pos().z, $$1.getReadBuffer());
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData $$2 : p_275437_.chunkBiomeData()) {
            this.level.onChunkLoaded(new ChunkPos($$2.pos().x, $$2.pos().z));
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData $$3 : p_275437_.chunkBiomeData()) {
            for (int $$4 = -1; $$4 <= 1; ++$$4) {
                for (int $$5 = -1; $$5 <= 1; ++$$5) {
                    for (int $$6 = this.level.getMinSection(); $$6 < this.level.getMaxSection(); ++$$6) {
                        this.minecraft.levelRenderer.setSectionDirty($$3.pos().x + $$4, $$6, $$3.pos().z + $$5);
                    }
                }
            }
        }
    }

    private void updateLevelChunk(int p_194199_, int p_194200_, ClientboundLevelChunkPacketData p_194201_) {
        this.level.getChunkSource().replaceWithPacketData(p_194199_, p_194200_, p_194201_.getReadBuffer(), p_194201_.getHeightmaps(), p_194201_.getBlockEntitiesTagsConsumer(p_194199_, p_194200_));
    }

    private void enableChunkLight(LevelChunk p_194213_, int p_194214_, int p_194215_) {
        LevelLightEngine $$3 = this.level.getChunkSource().getLightEngine();
        LevelChunkSection[] $$4 = p_194213_.getSections();
        ChunkPos $$5 = p_194213_.getPos();
        for (int $$6 = 0; $$6 < $$4.length; ++$$6) {
            LevelChunkSection $$7 = $$4[$$6];
            int $$8 = this.level.getSectionYFromSectionIndex($$6);
            $$3.updateSectionStatus(SectionPos.of($$5, $$8), $$7.hasOnlyAir());
            this.level.setSectionDirtyWithNeighbors(p_194214_, $$8, p_194215_);
        }
    }

    @Override
    public void handleForgetLevelChunk(ClientboundForgetLevelChunkPacket p_105014_) {
        PacketUtils.ensureRunningOnSameThread(p_105014_, this, this.minecraft);
        this.level.getChunkSource().drop(p_105014_.pos());
        this.queueLightRemoval(p_105014_);
    }

    private void queueLightRemoval(ClientboundForgetLevelChunkPacket p_194253_) {
        ChunkPos $$1 = p_194253_.pos();
        this.level.queueLightUpdate(() -> {
            LevelLightEngine $$1 = this.level.getLightEngine();
            $$1.setLightEnabled($$1, false);
            for (int $$2 = $$1.getMinLightSection(); $$2 < $$1.getMaxLightSection(); ++$$2) {
                SectionPos $$3 = SectionPos.of($$1, $$2);
                $$1.queueSectionData(LightLayer.BLOCK, $$3, null);
                $$1.queueSectionData(LightLayer.SKY, $$3, null);
            }
            for (int $$4 = this.level.getMinSection(); $$4 < this.level.getMaxSection(); ++$$4) {
                $$1.updateSectionStatus(SectionPos.of($$1, $$4), true);
            }
        });
    }

    @Override
    public void handleBlockUpdate(ClientboundBlockUpdatePacket p_104980_) {
        PacketUtils.ensureRunningOnSameThread(p_104980_, this, this.minecraft);
        this.level.setServerVerifiedBlockState(p_104980_.getPos(), p_104980_.getBlockState(), 19);
    }

    @Override
    public void handleConfigurationStart(ClientboundStartConfigurationPacket p_296485_) {
        PacketUtils.ensureRunningOnSameThread(p_296485_, this, this.minecraft);
        this.minecraft.getChatListener().clearQueue();
        this.sendChatAcknowledgement();
        ChatComponent.State $$1 = this.minecraft.gui.getChat().storeState();
        this.minecraft.clearClientLevel(new ServerReconfigScreen(RECONFIGURE_SCREEN_MESSAGE, this.connection));
        this.connection.setupInboundProtocol(ConfigurationProtocols.CLIENTBOUND, new ClientConfigurationPacketListenerImpl(this.minecraft, this.connection, new CommonListenerCookie(this.localGameProfile, this.telemetryManager, this.registryAccess, this.enabledFeatures, this.serverBrand, this.serverData, this.postDisconnectScreen, this.serverCookies, $$1, this.strictErrorHandling, this.customReportDetails, this.serverLinks)));
        this.send(ServerboundConfigurationAcknowledgedPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.SERVERBOUND);
    }

    @Override
    public void handleTakeItemEntity(ClientboundTakeItemEntityPacket p_105122_) {
        PacketUtils.ensureRunningOnSameThread(p_105122_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105122_.getItemId());
        LivingEntity $$2 = (LivingEntity)this.level.getEntity(p_105122_.getPlayerId());
        if ($$2 == null) {
            $$2 = this.minecraft.player;
        }
        if ($$1 != null) {
            if ($$1 instanceof ExperienceOrb) {
                this.level.playLocalSound($$1.getX(), $$1.getY(), $$1.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f, false);
            } else {
                this.level.playLocalSound($$1.getX(), $$1.getY(), $$1.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 1.4f + 2.0f, false);
            }
            this.minecraft.particleEngine.add(new ItemPickupParticle(this.minecraft.getEntityRenderDispatcher(), this.minecraft.renderBuffers(), this.level, $$1, $$2));
            if ($$1 instanceof ItemEntity) {
                ItemEntity $$3 = (ItemEntity)$$1;
                ItemStack $$4 = $$3.getItem();
                if (!$$4.isEmpty()) {
                    $$4.shrink(p_105122_.getAmount());
                }
                if ($$4.isEmpty()) {
                    this.level.removeEntity(p_105122_.getItemId(), Entity.RemovalReason.DISCARDED);
                }
            } else if (!($$1 instanceof ExperienceOrb)) {
                this.level.removeEntity(p_105122_.getItemId(), Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public void handleSystemChat(ClientboundSystemChatPacket p_233708_) {
        PacketUtils.ensureRunningOnSameThread(p_233708_, this, this.minecraft);
        this.minecraft.getChatListener().handleSystemMessage(p_233708_.content(), p_233708_.overlay());
    }

    @Override
    public void handlePlayerChat(ClientboundPlayerChatPacket p_233702_) {
        SignedMessageLink $$6;
        PacketUtils.ensureRunningOnSameThread(p_233702_, this, this.minecraft);
        Optional<SignedMessageBody> $$1 = p_233702_.body().unpack(this.messageSignatureCache);
        if ($$1.isEmpty()) {
            this.connection.disconnect(INVALID_PACKET);
            return;
        }
        this.messageSignatureCache.push($$1.get(), p_233702_.signature());
        UUID $$2 = p_233702_.sender();
        PlayerInfo $$3 = this.getPlayerInfo($$2);
        if ($$3 == null) {
            LOGGER.error("Received player chat packet for unknown player with ID: {}", (Object)$$2);
            this.minecraft.getChatListener().handleChatMessageError($$2, p_233702_.chatType());
            return;
        }
        RemoteChatSession $$4 = $$3.getChatSession();
        if ($$4 != null) {
            SignedMessageLink $$5 = new SignedMessageLink(p_233702_.index(), $$2, $$4.sessionId());
        } else {
            $$6 = SignedMessageLink.unsigned($$2);
        }
        PlayerChatMessage $$7 = new PlayerChatMessage($$6, p_233702_.signature(), $$1.get(), p_233702_.unsignedContent(), p_233702_.filterMask());
        $$7 = $$3.getMessageValidator().updateAndValidate($$7);
        if ($$7 != null) {
            this.minecraft.getChatListener().handlePlayerChatMessage($$7, $$3.getProfile(), p_233702_.chatType());
        } else {
            this.minecraft.getChatListener().handleChatMessageError($$2, p_233702_.chatType());
        }
    }

    @Override
    public void handleDisguisedChat(ClientboundDisguisedChatPacket p_251920_) {
        PacketUtils.ensureRunningOnSameThread(p_251920_, this, this.minecraft);
        this.minecraft.getChatListener().handleDisguisedChatMessage(p_251920_.message(), p_251920_.chatType());
    }

    @Override
    public void handleDeleteChat(ClientboundDeleteChatPacket p_241325_) {
        PacketUtils.ensureRunningOnSameThread(p_241325_, this, this.minecraft);
        Optional<MessageSignature> $$1 = p_241325_.messageSignature().unpack(this.messageSignatureCache);
        if ($$1.isEmpty()) {
            this.connection.disconnect(INVALID_PACKET);
            return;
        }
        this.lastSeenMessages.ignorePending($$1.get());
        if (!this.minecraft.getChatListener().removeFromDelayedMessageQueue($$1.get())) {
            this.minecraft.gui.getChat().deleteMessage($$1.get());
        }
    }

    @Override
    public void handleAnimate(ClientboundAnimatePacket p_104968_) {
        PacketUtils.ensureRunningOnSameThread(p_104968_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_104968_.getId());
        if ($$1 == null) {
            return;
        }
        if (p_104968_.getAction() == 0) {
            LivingEntity $$2 = (LivingEntity)$$1;
            $$2.swing(InteractionHand.MAIN_HAND);
        } else if (p_104968_.getAction() == 3) {
            LivingEntity $$3 = (LivingEntity)$$1;
            $$3.swing(InteractionHand.OFF_HAND);
        } else if (p_104968_.getAction() == 2) {
            Player $$4 = (Player)$$1;
            $$4.stopSleepInBed(false, false);
        } else if (p_104968_.getAction() == 4) {
            this.minecraft.particleEngine.createTrackingEmitter($$1, ParticleTypes.CRIT);
        } else if (p_104968_.getAction() == 5) {
            this.minecraft.particleEngine.createTrackingEmitter($$1, ParticleTypes.ENCHANTED_HIT);
        }
    }

    @Override
    public void handleHurtAnimation(ClientboundHurtAnimationPacket p_265581_) {
        PacketUtils.ensureRunningOnSameThread(p_265581_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_265581_.id());
        if ($$1 == null) {
            return;
        }
        $$1.animateHurt(p_265581_.yaw());
    }

    @Override
    public void handleSetTime(ClientboundSetTimePacket p_105108_) {
        PacketUtils.ensureRunningOnSameThread(p_105108_, this, this.minecraft);
        this.minecraft.level.setGameTime(p_105108_.getGameTime());
        this.minecraft.level.setDayTime(p_105108_.getDayTime());
        this.telemetryManager.setTime(p_105108_.getGameTime());
    }

    @Override
    public void handleSetSpawn(ClientboundSetDefaultSpawnPositionPacket p_105084_) {
        PacketUtils.ensureRunningOnSameThread(p_105084_, this, this.minecraft);
        this.minecraft.level.setDefaultSpawnPos(p_105084_.getPos(), p_105084_.getAngle());
    }

    @Override
    public void handleSetEntityPassengersPacket(ClientboundSetPassengersPacket p_105102_) {
        PacketUtils.ensureRunningOnSameThread(p_105102_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105102_.getVehicle());
        if ($$1 == null) {
            LOGGER.warn("Received passengers for unknown entity");
            return;
        }
        boolean $$2 = $$1.hasIndirectPassenger(this.minecraft.player);
        $$1.ejectPassengers();
        for (int $$3 : p_105102_.getPassengers()) {
            Entity $$4 = this.level.getEntity($$3);
            if ($$4 == null) continue;
            $$4.startRiding($$1, true);
            if ($$4 != this.minecraft.player || $$2) continue;
            if ($$1 instanceof Boat) {
                this.minecraft.player.yRotO = $$1.getYRot();
                this.minecraft.player.setYRot($$1.getYRot());
                this.minecraft.player.setYHeadRot($$1.getYRot());
            }
            MutableComponent $$5 = Component.translatable("mount.onboard", this.minecraft.options.keyShift.getTranslatedKeyMessage());
            this.minecraft.gui.setOverlayMessage($$5, false);
            this.minecraft.getNarrator().sayNow($$5);
        }
    }

    @Override
    public void handleEntityLinkPacket(ClientboundSetEntityLinkPacket p_105090_) {
        PacketUtils.ensureRunningOnSameThread(p_105090_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105090_.getSourceId());
        if ($$1 instanceof Leashable) {
            Leashable $$2 = (Leashable)((Object)$$1);
            $$2.setDelayedLeashHolderId(p_105090_.getDestId());
        }
    }

    private static ItemStack findTotem(Player p_104928_) {
        for (InteractionHand $$1 : InteractionHand.values()) {
            ItemStack $$2 = p_104928_.getItemInHand($$1);
            if (!$$2.is(Items.TOTEM_OF_UNDYING)) continue;
            return $$2;
        }
        return new ItemStack(Items.TOTEM_OF_UNDYING);
    }

    @Override
    public void handleEntityEvent(ClientboundEntityEventPacket p_105010_) {
        PacketUtils.ensureRunningOnSameThread(p_105010_, this, this.minecraft);
        Entity $$1 = p_105010_.getEntity(this.level);
        if ($$1 != null) {
            switch (p_105010_.getEventId()) {
                case 63: {
                    this.minecraft.getSoundManager().play(new SnifferSoundInstance((Sniffer)$$1));
                    break;
                }
                case 21: {
                    this.minecraft.getSoundManager().play(new GuardianAttackSoundInstance((Guardian)$$1));
                    break;
                }
                case 35: {
                    int $$2 = 40;
                    this.minecraft.particleEngine.createTrackingEmitter($$1, ParticleTypes.TOTEM_OF_UNDYING, 30);
                    this.level.playLocalSound($$1.getX(), $$1.getY(), $$1.getZ(), SoundEvents.TOTEM_USE, $$1.getSoundSource(), 1.0f, 1.0f, false);
                    if ($$1 != this.minecraft.player) break;
                    this.minecraft.gameRenderer.displayItemActivation(ClientPacketListener.findTotem(this.minecraft.player));
                    break;
                }
                default: {
                    $$1.handleEntityEvent(p_105010_.getEventId());
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(ClientboundDamageEventPacket p_270800_) {
        PacketUtils.ensureRunningOnSameThread(p_270800_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_270800_.entityId());
        if ($$1 == null) {
            return;
        }
        $$1.handleDamageEvent(p_270800_.getSource(this.level));
    }

    @Override
    public void handleSetHealth(ClientboundSetHealthPacket p_105098_) {
        PacketUtils.ensureRunningOnSameThread(p_105098_, this, this.minecraft);
        this.minecraft.player.hurtTo(p_105098_.getHealth());
        this.minecraft.player.getFoodData().setFoodLevel(p_105098_.getFood());
        this.minecraft.player.getFoodData().setSaturation(p_105098_.getSaturation());
    }

    @Override
    public void handleSetExperience(ClientboundSetExperiencePacket p_105096_) {
        PacketUtils.ensureRunningOnSameThread(p_105096_, this, this.minecraft);
        this.minecraft.player.setExperienceValues(p_105096_.getExperienceProgress(), p_105096_.getTotalExperience(), p_105096_.getExperienceLevel());
    }

    @Override
    public void handleRespawn(ClientboundRespawnPacket p_105066_) {
        List<SynchedEntityData.DataValue<?>> $$14;
        LocalPlayer $$13;
        PacketUtils.ensureRunningOnSameThread(p_105066_, this, this.minecraft);
        CommonPlayerSpawnInfo $$1 = p_105066_.commonPlayerSpawnInfo();
        ResourceKey<Level> $$2 = $$1.dimension();
        Holder<DimensionType> $$3 = $$1.dimensionType();
        LocalPlayer $$4 = this.minecraft.player;
        ResourceKey<Level> $$5 = $$4.level().dimension();
        boolean $$6 = $$2 != $$5;
        ReceivingLevelScreen.Reason $$7 = this.determineLevelLoadingReason($$4.isDeadOrDying(), $$2, $$5);
        if ($$6) {
            ClientLevel.ClientLevelData $$11;
            Map<MapId, MapItemSavedData> $$8 = this.level.getAllMapData();
            boolean $$9 = $$1.isDebug();
            boolean $$10 = $$1.isFlat();
            this.levelData = $$11 = new ClientLevel.ClientLevelData(this.levelData.getDifficulty(), this.levelData.isHardcore(), $$10);
            this.level = new ClientLevel(this, $$11, $$2, $$3, this.serverChunkRadius, this.serverSimulationDistance, this.minecraft::getProfiler, this.minecraft.levelRenderer, $$9, $$1.seed());
            this.level.addMapData($$8);
            this.minecraft.setLevel(this.level, $$7);
        }
        this.minecraft.cameraEntity = null;
        if ($$4.hasContainerOpen()) {
            $$4.closeContainer();
        }
        if (p_105066_.shouldKeep((byte)2)) {
            LocalPlayer $$12 = this.minecraft.gameMode.createPlayer(this.level, $$4.getStats(), $$4.getRecipeBook(), $$4.isShiftKeyDown(), $$4.isSprinting());
        } else {
            $$13 = this.minecraft.gameMode.createPlayer(this.level, $$4.getStats(), $$4.getRecipeBook());
        }
        this.startWaitingForNewLevel($$13, this.level, $$7);
        $$13.setId($$4.getId());
        this.minecraft.player = $$13;
        if ($$6) {
            this.minecraft.getMusicManager().stopPlaying();
        }
        this.minecraft.cameraEntity = $$13;
        if (p_105066_.shouldKeep((byte)2) && ($$14 = $$4.getEntityData().getNonDefaultValues()) != null) {
            $$13.getEntityData().assignValues($$14);
        }
        if (p_105066_.shouldKeep((byte)1)) {
            $$13.getAttributes().assignAllValues($$4.getAttributes());
        } else {
            $$13.getAttributes().assignBaseValues($$4.getAttributes());
        }
        $$13.resetPos();
        this.level.addEntity($$13);
        $$13.setYRot(-180.0f);
        $$13.input = new KeyboardInput(this.minecraft.options);
        this.minecraft.gameMode.adjustPlayer($$13);
        $$13.setReducedDebugInfo($$4.isReducedDebugInfo());
        $$13.setShowDeathScreen($$4.shouldShowDeathScreen());
        $$13.setLastDeathLocation($$1.lastDeathLocation());
        $$13.setPortalCooldown($$1.portalCooldown());
        $$13.spinningEffectIntensity = $$4.spinningEffectIntensity;
        $$13.oSpinningEffectIntensity = $$4.oSpinningEffectIntensity;
        if (this.minecraft.screen instanceof DeathScreen || this.minecraft.screen instanceof DeathScreen.TitleConfirmScreen) {
            this.minecraft.setScreen(null);
        }
        this.minecraft.gameMode.setLocalMode($$1.gameType(), $$1.previousGameType());
    }

    private ReceivingLevelScreen.Reason determineLevelLoadingReason(boolean p_341642_, ResourceKey<Level> p_341617_, ResourceKey<Level> p_341637_) {
        ReceivingLevelScreen.Reason $$3 = ReceivingLevelScreen.Reason.OTHER;
        if (!p_341642_) {
            if (p_341617_ == Level.NETHER || p_341637_ == Level.NETHER) {
                $$3 = ReceivingLevelScreen.Reason.NETHER_PORTAL;
            } else if (p_341617_ == Level.END || p_341637_ == Level.END) {
                $$3 = ReceivingLevelScreen.Reason.END_PORTAL;
            }
        }
        return $$3;
    }

    @Override
    public void handleExplosion(ClientboundExplodePacket p_105012_) {
        PacketUtils.ensureRunningOnSameThread(p_105012_, this, this.minecraft);
        Explosion $$1 = new Explosion(this.minecraft.level, null, p_105012_.getX(), p_105012_.getY(), p_105012_.getZ(), p_105012_.getPower(), p_105012_.getToBlow(), p_105012_.getBlockInteraction(), p_105012_.getSmallExplosionParticles(), p_105012_.getLargeExplosionParticles(), p_105012_.getExplosionSound());
        $$1.finalizeExplosion(true);
        this.minecraft.player.setDeltaMovement(this.minecraft.player.getDeltaMovement().add(p_105012_.getKnockbackX(), p_105012_.getKnockbackY(), p_105012_.getKnockbackZ()));
    }

    @Override
    public void handleHorseScreenOpen(ClientboundHorseScreenOpenPacket p_105018_) {
        PacketUtils.ensureRunningOnSameThread(p_105018_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105018_.getEntityId());
        if ($$1 instanceof AbstractHorse) {
            AbstractHorse $$2 = (AbstractHorse)$$1;
            LocalPlayer $$3 = this.minecraft.player;
            int $$4 = p_105018_.getInventoryColumns();
            SimpleContainer $$5 = new SimpleContainer(AbstractHorse.getInventorySize($$4));
            HorseInventoryMenu $$6 = new HorseInventoryMenu(p_105018_.getContainerId(), $$3.getInventory(), $$5, $$2, $$4);
            $$3.containerMenu = $$6;
            this.minecraft.setScreen(new HorseInventoryScreen($$6, $$3.getInventory(), $$2, $$4));
        }
    }

    @Override
    public void handleOpenScreen(ClientboundOpenScreenPacket p_105042_) {
        PacketUtils.ensureRunningOnSameThread(p_105042_, this, this.minecraft);
        MenuScreens.create(p_105042_.getType(), this.minecraft, p_105042_.getContainerId(), p_105042_.getTitle());
    }

    @Override
    public void handleContainerSetSlot(ClientboundContainerSetSlotPacket p_105000_) {
        PacketUtils.ensureRunningOnSameThread(p_105000_, this, this.minecraft);
        LocalPlayer $$1 = this.minecraft.player;
        ItemStack $$2 = p_105000_.getItem();
        int $$3 = p_105000_.getSlot();
        this.minecraft.getTutorial().onGetItem($$2);
        if (p_105000_.getContainerId() == -1) {
            if (!(this.minecraft.screen instanceof CreativeModeInventoryScreen)) {
                $$1.containerMenu.setCarried($$2);
            }
        } else if (p_105000_.getContainerId() == -2) {
            $$1.getInventory().setItem($$3, $$2);
        } else {
            boolean $$4 = false;
            Screen screen = this.minecraft.screen;
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen $$5 = (CreativeModeInventoryScreen)screen;
                boolean bl = $$4 = !$$5.isInventoryOpen();
            }
            if (p_105000_.getContainerId() == 0 && InventoryMenu.isHotbarSlot($$3)) {
                ItemStack $$6;
                if (!$$2.isEmpty() && (($$6 = $$1.inventoryMenu.getSlot($$3).getItem()).isEmpty() || $$6.getCount() < $$2.getCount())) {
                    $$2.setPopTime(5);
                }
                $$1.inventoryMenu.setItem($$3, p_105000_.getStateId(), $$2);
            } else if (!(p_105000_.getContainerId() != $$1.containerMenu.containerId || p_105000_.getContainerId() == 0 && $$4)) {
                $$1.containerMenu.setItem($$3, p_105000_.getStateId(), $$2);
            }
        }
    }

    @Override
    public void handleContainerContent(ClientboundContainerSetContentPacket p_104996_) {
        PacketUtils.ensureRunningOnSameThread(p_104996_, this, this.minecraft);
        LocalPlayer $$1 = this.minecraft.player;
        if (p_104996_.getContainerId() == 0) {
            $$1.inventoryMenu.initializeContents(p_104996_.getStateId(), p_104996_.getItems(), p_104996_.getCarriedItem());
        } else if (p_104996_.getContainerId() == $$1.containerMenu.containerId) {
            $$1.containerMenu.initializeContents(p_104996_.getStateId(), p_104996_.getItems(), p_104996_.getCarriedItem());
        }
    }

    @Override
    public void handleOpenSignEditor(ClientboundOpenSignEditorPacket p_105044_) {
        PacketUtils.ensureRunningOnSameThread(p_105044_, this, this.minecraft);
        BlockPos $$1 = p_105044_.getPos();
        BlockEntity blockEntity = this.level.getBlockEntity($$1);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity $$2 = (SignBlockEntity)blockEntity;
            this.minecraft.player.openTextEdit($$2, p_105044_.isFrontText());
        } else {
            BlockState $$3 = this.level.getBlockState($$1);
            SignBlockEntity $$4 = new SignBlockEntity($$1, $$3);
            $$4.setLevel(this.level);
            this.minecraft.player.openTextEdit($$4, p_105044_.isFrontText());
        }
    }

    @Override
    public void handleBlockEntityData(ClientboundBlockEntityDataPacket p_104976_) {
        PacketUtils.ensureRunningOnSameThread(p_104976_, this, this.minecraft);
        BlockPos $$1 = p_104976_.getPos();
        this.minecraft.level.getBlockEntity($$1, p_104976_.getType()).ifPresent(p_337415_ -> {
            CompoundTag $$2 = p_104976_.getTag();
            if (!$$2.isEmpty()) {
                p_337415_.loadWithComponents($$2, this.registryAccess);
            }
            if (p_337415_ instanceof CommandBlockEntity && this.minecraft.screen instanceof CommandBlockEditScreen) {
                ((CommandBlockEditScreen)this.minecraft.screen).updateGui();
            }
        });
    }

    @Override
    public void handleContainerSetData(ClientboundContainerSetDataPacket p_104998_) {
        PacketUtils.ensureRunningOnSameThread(p_104998_, this, this.minecraft);
        LocalPlayer $$1 = this.minecraft.player;
        if ($$1.containerMenu != null && $$1.containerMenu.containerId == p_104998_.getContainerId()) {
            $$1.containerMenu.setData(p_104998_.getId(), p_104998_.getValue());
        }
    }

    @Override
    public void handleSetEquipment(ClientboundSetEquipmentPacket p_105094_) {
        PacketUtils.ensureRunningOnSameThread(p_105094_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105094_.getEntity());
        if ($$1 instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)$$1;
            p_105094_.getSlots().forEach(p_323056_ -> $$2.setItemSlot((EquipmentSlot)p_323056_.getFirst(), (ItemStack)p_323056_.getSecond()));
        }
    }

    @Override
    public void handleContainerClose(ClientboundContainerClosePacket p_104994_) {
        PacketUtils.ensureRunningOnSameThread(p_104994_, this, this.minecraft);
        this.minecraft.player.clientSideCloseContainer();
    }

    @Override
    public void handleBlockEvent(ClientboundBlockEventPacket p_104978_) {
        PacketUtils.ensureRunningOnSameThread(p_104978_, this, this.minecraft);
        this.minecraft.level.blockEvent(p_104978_.getPos(), p_104978_.getBlock(), p_104978_.getB0(), p_104978_.getB1());
    }

    @Override
    public void handleBlockDestruction(ClientboundBlockDestructionPacket p_104974_) {
        PacketUtils.ensureRunningOnSameThread(p_104974_, this, this.minecraft);
        this.minecraft.level.destroyBlockProgress(p_104974_.getId(), p_104974_.getPos(), p_104974_.getProgress());
    }

    @Override
    public void handleGameEvent(ClientboundGameEventPacket p_105016_) {
        PacketUtils.ensureRunningOnSameThread(p_105016_, this, this.minecraft);
        LocalPlayer $$1 = this.minecraft.player;
        ClientboundGameEventPacket.Type $$2 = p_105016_.getEvent();
        float $$3 = p_105016_.getParam();
        int $$4 = Mth.floor($$3 + 0.5f);
        if ($$2 == ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE) {
            ((Player)$$1).displayClientMessage(Component.translatable("block.minecraft.spawn.not_valid"), false);
        } else if ($$2 == ClientboundGameEventPacket.START_RAINING) {
            this.level.getLevelData().setRaining(true);
            this.level.setRainLevel(0.0f);
        } else if ($$2 == ClientboundGameEventPacket.STOP_RAINING) {
            this.level.getLevelData().setRaining(false);
            this.level.setRainLevel(1.0f);
        } else if ($$2 == ClientboundGameEventPacket.CHANGE_GAME_MODE) {
            this.minecraft.gameMode.setLocalMode(GameType.byId($$4));
        } else if ($$2 == ClientboundGameEventPacket.WIN_GAME) {
            this.minecraft.setScreen(new WinScreen(true, () -> {
                this.minecraft.player.connection.send(new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
                this.minecraft.setScreen(null);
            }));
        } else if ($$2 == ClientboundGameEventPacket.DEMO_EVENT) {
            Options $$5 = this.minecraft.options;
            if ($$3 == 0.0f) {
                this.minecraft.setScreen(new DemoIntroScreen());
            } else if ($$3 == 101.0f) {
                this.minecraft.gui.getChat().addMessage(Component.translatable("demo.help.movement", $$5.keyUp.getTranslatedKeyMessage(), $$5.keyLeft.getTranslatedKeyMessage(), $$5.keyDown.getTranslatedKeyMessage(), $$5.keyRight.getTranslatedKeyMessage()));
            } else if ($$3 == 102.0f) {
                this.minecraft.gui.getChat().addMessage(Component.translatable("demo.help.jump", $$5.keyJump.getTranslatedKeyMessage()));
            } else if ($$3 == 103.0f) {
                this.minecraft.gui.getChat().addMessage(Component.translatable("demo.help.inventory", $$5.keyInventory.getTranslatedKeyMessage()));
            } else if ($$3 == 104.0f) {
                this.minecraft.gui.getChat().addMessage(Component.translatable("demo.day.6", $$5.keyScreenshot.getTranslatedKeyMessage()));
            }
        } else if ($$2 == ClientboundGameEventPacket.ARROW_HIT_PLAYER) {
            this.level.playSound((Player)$$1, $$1.getX(), $$1.getEyeY(), $$1.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.18f, 0.45f);
        } else if ($$2 == ClientboundGameEventPacket.RAIN_LEVEL_CHANGE) {
            this.level.setRainLevel($$3);
        } else if ($$2 == ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE) {
            this.level.setThunderLevel($$3);
        } else if ($$2 == ClientboundGameEventPacket.PUFFER_FISH_STING) {
            this.level.playSound((Player)$$1, $$1.getX(), $$1.getY(), $$1.getZ(), SoundEvents.PUFFER_FISH_STING, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if ($$2 == ClientboundGameEventPacket.GUARDIAN_ELDER_EFFECT) {
            this.level.addParticle(ParticleTypes.ELDER_GUARDIAN, $$1.getX(), $$1.getY(), $$1.getZ(), 0.0, 0.0, 0.0);
            if ($$4 == 1) {
                this.level.playSound((Player)$$1, $$1.getX(), $$1.getY(), $$1.getZ(), SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        } else if ($$2 == ClientboundGameEventPacket.IMMEDIATE_RESPAWN) {
            this.minecraft.player.setShowDeathScreen($$3 == 0.0f);
        } else if ($$2 == ClientboundGameEventPacket.LIMITED_CRAFTING) {
            this.minecraft.player.setDoLimitedCrafting($$3 == 1.0f);
        } else if ($$2 == ClientboundGameEventPacket.LEVEL_CHUNKS_LOAD_START && this.levelLoadStatusManager != null) {
            this.levelLoadStatusManager.loadingPacketsReceived();
        }
    }

    private void startWaitingForNewLevel(LocalPlayer p_304688_, ClientLevel p_304528_, ReceivingLevelScreen.Reason p_341690_) {
        this.levelLoadStatusManager = new LevelLoadStatusManager(p_304688_, p_304528_, this.minecraft.levelRenderer);
        this.minecraft.setScreen(new ReceivingLevelScreen(this.levelLoadStatusManager::levelReady, p_341690_));
    }

    @Override
    public void handleMapItemData(ClientboundMapItemDataPacket p_105032_) {
        PacketUtils.ensureRunningOnSameThread(p_105032_, this, this.minecraft);
        MapRenderer $$1 = this.minecraft.gameRenderer.getMapRenderer();
        MapId $$2 = p_105032_.mapId();
        MapItemSavedData $$3 = this.minecraft.level.getMapData($$2);
        if ($$3 == null) {
            $$3 = MapItemSavedData.createForClient(p_105032_.scale(), p_105032_.locked(), this.minecraft.level.dimension());
            this.minecraft.level.overrideMapData($$2, $$3);
        }
        p_105032_.applyToMap($$3);
        $$1.update($$2, $$3);
    }

    @Override
    public void handleLevelEvent(ClientboundLevelEventPacket p_105024_) {
        PacketUtils.ensureRunningOnSameThread(p_105024_, this, this.minecraft);
        if (p_105024_.isGlobalEvent()) {
            this.minecraft.level.globalLevelEvent(p_105024_.getType(), p_105024_.getPos(), p_105024_.getData());
        } else {
            this.minecraft.level.levelEvent(p_105024_.getType(), p_105024_.getPos(), p_105024_.getData());
        }
    }

    @Override
    public void handleUpdateAdvancementsPacket(ClientboundUpdateAdvancementsPacket p_105126_) {
        PacketUtils.ensureRunningOnSameThread(p_105126_, this, this.minecraft);
        this.advancements.update(p_105126_);
    }

    @Override
    public void handleSelectAdvancementsTab(ClientboundSelectAdvancementsTabPacket p_105072_) {
        PacketUtils.ensureRunningOnSameThread(p_105072_, this, this.minecraft);
        ResourceLocation $$1 = p_105072_.getTab();
        if ($$1 == null) {
            this.advancements.setSelectedTab(null, false);
        } else {
            AdvancementHolder $$2 = this.advancements.get($$1);
            this.advancements.setSelectedTab($$2, false);
        }
    }

    @Override
    public void handleCommands(ClientboundCommandsPacket p_104990_) {
        PacketUtils.ensureRunningOnSameThread(p_104990_, this, this.minecraft);
        this.commands = new CommandDispatcher(p_104990_.getRoot(CommandBuildContext.simple(this.registryAccess, this.enabledFeatures)));
    }

    @Override
    public void handleStopSoundEvent(ClientboundStopSoundPacket p_105116_) {
        PacketUtils.ensureRunningOnSameThread(p_105116_, this, this.minecraft);
        this.minecraft.getSoundManager().stop(p_105116_.getName(), p_105116_.getSource());
    }

    @Override
    public void handleCommandSuggestions(ClientboundCommandSuggestionsPacket p_104988_) {
        PacketUtils.ensureRunningOnSameThread(p_104988_, this, this.minecraft);
        this.suggestionsProvider.completeCustomSuggestions(p_104988_.id(), p_104988_.toSuggestions());
    }

    @Override
    public void handleUpdateRecipes(ClientboundUpdateRecipesPacket p_105132_) {
        PacketUtils.ensureRunningOnSameThread(p_105132_, this, this.minecraft);
        this.recipeManager.replaceRecipes(p_105132_.getRecipes());
        ClientRecipeBook $$1 = this.minecraft.player.getRecipeBook();
        $$1.setupCollections(this.recipeManager.getOrderedRecipes(), this.minecraft.level.registryAccess());
        this.searchTrees.updateRecipes($$1, this.registryAccess);
    }

    @Override
    public void handleLookAt(ClientboundPlayerLookAtPacket p_105054_) {
        PacketUtils.ensureRunningOnSameThread(p_105054_, this, this.minecraft);
        Vec3 $$1 = p_105054_.getPosition(this.level);
        if ($$1 != null) {
            this.minecraft.player.lookAt(p_105054_.getFromAnchor(), $$1);
        }
    }

    @Override
    public void handleTagQueryPacket(ClientboundTagQueryPacket p_105120_) {
        PacketUtils.ensureRunningOnSameThread(p_105120_, this, this.minecraft);
        if (!this.debugQueryHandler.handleResponse(p_105120_.getTransactionId(), p_105120_.getTag())) {
            LOGGER.debug("Got unhandled response to tag query {}", (Object)p_105120_.getTransactionId());
        }
    }

    @Override
    public void handleAwardStats(ClientboundAwardStatsPacket p_104970_) {
        PacketUtils.ensureRunningOnSameThread(p_104970_, this, this.minecraft);
        for (Object2IntMap.Entry $$1 : p_104970_.stats().object2IntEntrySet()) {
            Stat $$2 = (Stat)$$1.getKey();
            int $$3 = $$1.getIntValue();
            this.minecraft.player.getStats().setValue(this.minecraft.player, $$2, $$3);
        }
        Screen screen = this.minecraft.screen;
        if (screen instanceof StatsScreen) {
            StatsScreen $$4 = (StatsScreen)screen;
            $$4.onStatsUpdated();
        }
    }

    @Override
    public void handleAddOrRemoveRecipes(ClientboundRecipePacket p_105058_) {
        PacketUtils.ensureRunningOnSameThread(p_105058_, this, this.minecraft);
        ClientRecipeBook $$1 = this.minecraft.player.getRecipeBook();
        $$1.setBookSettings(p_105058_.getBookSettings());
        ClientboundRecipePacket.State $$2 = p_105058_.getState();
        switch ($$2) {
            case REMOVE: {
                for (ResourceLocation $$3 : p_105058_.getRecipes()) {
                    this.recipeManager.byKey($$3).ifPresent($$1::remove);
                }
                break;
            }
            case INIT: {
                for (ResourceLocation $$4 : p_105058_.getRecipes()) {
                    this.recipeManager.byKey($$4).ifPresent($$1::add);
                }
                for (ResourceLocation $$5 : p_105058_.getHighlights()) {
                    this.recipeManager.byKey($$5).ifPresent($$1::addHighlight);
                }
                break;
            }
            case ADD: {
                for (ResourceLocation $$6 : p_105058_.getRecipes()) {
                    this.recipeManager.byKey($$6).ifPresent(p_300677_ -> {
                        $$1.add((RecipeHolder<?>)p_300677_);
                        $$1.addHighlight((RecipeHolder<?>)p_300677_);
                        if (p_300677_.value().showNotification()) {
                            RecipeToast.addOrUpdate(this.minecraft.getToasts(), p_300677_);
                        }
                    });
                }
                break;
            }
        }
        $$1.getCollections().forEach(p_205540_ -> p_205540_.updateKnownRecipes($$1));
        if (this.minecraft.screen instanceof RecipeUpdateListener) {
            ((RecipeUpdateListener)((Object)this.minecraft.screen)).recipesUpdated();
        }
    }

    @Override
    public void handleUpdateMobEffect(ClientboundUpdateMobEffectPacket p_105130_) {
        PacketUtils.ensureRunningOnSameThread(p_105130_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105130_.getEntityId());
        if (!($$1 instanceof LivingEntity)) {
            return;
        }
        Holder<MobEffect> $$2 = p_105130_.getEffect();
        MobEffectInstance $$3 = new MobEffectInstance($$2, p_105130_.getEffectDurationTicks(), p_105130_.getEffectAmplifier(), p_105130_.isEffectAmbient(), p_105130_.isEffectVisible(), p_105130_.effectShowsIcon(), null);
        if (!p_105130_.shouldBlend()) {
            $$3.skipBlending();
        }
        ((LivingEntity)$$1).forceAddEffect($$3, null);
    }

    @Override
    public void handleUpdateTags(ClientboundUpdateTagsPacket p_294888_) {
        PacketUtils.ensureRunningOnSameThread(p_294888_, this, this.minecraft);
        TagCollector $$1 = new TagCollector();
        p_294888_.getTags().forEach($$1::append);
        $$1.updateTags(this.registryAccess, this.connection.isMemoryConnection());
        List<ItemStack> $$2 = List.copyOf(CreativeModeTabs.searchTab().getDisplayItems());
        this.searchTrees.updateCreativeTags($$2);
    }

    @Override
    public void handlePlayerCombatEnd(ClientboundPlayerCombatEndPacket p_171771_) {
    }

    @Override
    public void handlePlayerCombatEnter(ClientboundPlayerCombatEnterPacket p_171773_) {
    }

    @Override
    public void handlePlayerCombatKill(ClientboundPlayerCombatKillPacket p_171775_) {
        PacketUtils.ensureRunningOnSameThread(p_171775_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_171775_.playerId());
        if ($$1 == this.minecraft.player) {
            if (this.minecraft.player.shouldShowDeathScreen()) {
                this.minecraft.setScreen(new DeathScreen(p_171775_.message(), this.level.getLevelData().isHardcore()));
            } else {
                this.minecraft.player.respawn();
            }
        }
    }

    @Override
    public void handleChangeDifficulty(ClientboundChangeDifficultyPacket p_104984_) {
        PacketUtils.ensureRunningOnSameThread(p_104984_, this, this.minecraft);
        this.levelData.setDifficulty(p_104984_.getDifficulty());
        this.levelData.setDifficultyLocked(p_104984_.isLocked());
    }

    @Override
    public void handleSetCamera(ClientboundSetCameraPacket p_105076_) {
        PacketUtils.ensureRunningOnSameThread(p_105076_, this, this.minecraft);
        Entity $$1 = p_105076_.getEntity(this.level);
        if ($$1 != null) {
            this.minecraft.setCameraEntity($$1);
        }
    }

    @Override
    public void handleInitializeBorder(ClientboundInitializeBorderPacket p_171767_) {
        PacketUtils.ensureRunningOnSameThread(p_171767_, this, this.minecraft);
        WorldBorder $$1 = this.level.getWorldBorder();
        $$1.setCenter(p_171767_.getNewCenterX(), p_171767_.getNewCenterZ());
        long $$2 = p_171767_.getLerpTime();
        if ($$2 > 0L) {
            $$1.lerpSizeBetween(p_171767_.getOldSize(), p_171767_.getNewSize(), $$2);
        } else {
            $$1.setSize(p_171767_.getNewSize());
        }
        $$1.setAbsoluteMaxSize(p_171767_.getNewAbsoluteMaxSize());
        $$1.setWarningBlocks(p_171767_.getWarningBlocks());
        $$1.setWarningTime(p_171767_.getWarningTime());
    }

    @Override
    public void handleSetBorderCenter(ClientboundSetBorderCenterPacket p_171781_) {
        PacketUtils.ensureRunningOnSameThread(p_171781_, this, this.minecraft);
        this.level.getWorldBorder().setCenter(p_171781_.getNewCenterX(), p_171781_.getNewCenterZ());
    }

    @Override
    public void handleSetBorderLerpSize(ClientboundSetBorderLerpSizePacket p_171783_) {
        PacketUtils.ensureRunningOnSameThread(p_171783_, this, this.minecraft);
        this.level.getWorldBorder().lerpSizeBetween(p_171783_.getOldSize(), p_171783_.getNewSize(), p_171783_.getLerpTime());
    }

    @Override
    public void handleSetBorderSize(ClientboundSetBorderSizePacket p_171785_) {
        PacketUtils.ensureRunningOnSameThread(p_171785_, this, this.minecraft);
        this.level.getWorldBorder().setSize(p_171785_.getSize());
    }

    @Override
    public void handleSetBorderWarningDistance(ClientboundSetBorderWarningDistancePacket p_171789_) {
        PacketUtils.ensureRunningOnSameThread(p_171789_, this, this.minecraft);
        this.level.getWorldBorder().setWarningBlocks(p_171789_.getWarningBlocks());
    }

    @Override
    public void handleSetBorderWarningDelay(ClientboundSetBorderWarningDelayPacket p_171787_) {
        PacketUtils.ensureRunningOnSameThread(p_171787_, this, this.minecraft);
        this.level.getWorldBorder().setWarningTime(p_171787_.getWarningDelay());
    }

    @Override
    public void handleTitlesClear(ClientboundClearTitlesPacket p_171765_) {
        PacketUtils.ensureRunningOnSameThread(p_171765_, this, this.minecraft);
        this.minecraft.gui.clear();
        if (p_171765_.shouldResetTimes()) {
            this.minecraft.gui.resetTitleTimes();
        }
    }

    @Override
    public void handleServerData(ClientboundServerDataPacket p_233704_) {
        PacketUtils.ensureRunningOnSameThread(p_233704_, this, this.minecraft);
        if (this.serverData == null) {
            return;
        }
        this.serverData.motd = p_233704_.motd();
        p_233704_.iconBytes().map(ServerData::validateIcon).ifPresent(this.serverData::setIconBytes);
        ServerList.saveSingleServer(this.serverData);
    }

    @Override
    public void handleCustomChatCompletions(ClientboundCustomChatCompletionsPacket p_240832_) {
        PacketUtils.ensureRunningOnSameThread(p_240832_, this, this.minecraft);
        this.suggestionsProvider.modifyCustomCompletions(p_240832_.action(), p_240832_.entries());
    }

    @Override
    public void setActionBarText(ClientboundSetActionBarTextPacket p_171779_) {
        PacketUtils.ensureRunningOnSameThread(p_171779_, this, this.minecraft);
        this.minecraft.gui.setOverlayMessage(p_171779_.text(), false);
    }

    @Override
    public void setTitleText(ClientboundSetTitleTextPacket p_171793_) {
        PacketUtils.ensureRunningOnSameThread(p_171793_, this, this.minecraft);
        this.minecraft.gui.setTitle(p_171793_.text());
    }

    @Override
    public void setSubtitleText(ClientboundSetSubtitleTextPacket p_171791_) {
        PacketUtils.ensureRunningOnSameThread(p_171791_, this, this.minecraft);
        this.minecraft.gui.setSubtitle(p_171791_.text());
    }

    @Override
    public void setTitlesAnimation(ClientboundSetTitlesAnimationPacket p_171795_) {
        PacketUtils.ensureRunningOnSameThread(p_171795_, this, this.minecraft);
        this.minecraft.gui.setTimes(p_171795_.getFadeIn(), p_171795_.getStay(), p_171795_.getFadeOut());
    }

    @Override
    public void handleTabListCustomisation(ClientboundTabListPacket p_105118_) {
        PacketUtils.ensureRunningOnSameThread(p_105118_, this, this.minecraft);
        this.minecraft.gui.getTabList().setHeader(p_105118_.header().getString().isEmpty() ? null : p_105118_.header());
        this.minecraft.gui.getTabList().setFooter(p_105118_.footer().getString().isEmpty() ? null : p_105118_.footer());
    }

    @Override
    public void handleRemoveMobEffect(ClientboundRemoveMobEffectPacket p_105062_) {
        PacketUtils.ensureRunningOnSameThread(p_105062_, this, this.minecraft);
        Entity entity = p_105062_.getEntity(this.level);
        if (entity instanceof LivingEntity) {
            LivingEntity $$1 = (LivingEntity)entity;
            $$1.removeEffectNoUpdate(p_105062_.effect());
        }
    }

    @Override
    public void handlePlayerInfoRemove(ClientboundPlayerInfoRemovePacket p_248731_) {
        PacketUtils.ensureRunningOnSameThread(p_248731_, this, this.minecraft);
        for (UUID $$1 : p_248731_.profileIds()) {
            this.minecraft.getPlayerSocialManager().removePlayer($$1);
            PlayerInfo $$2 = this.playerInfoMap.remove($$1);
            if ($$2 == null) continue;
            this.listedPlayers.remove($$2);
        }
    }

    @Override
    public void handlePlayerInfoUpdate(ClientboundPlayerInfoUpdatePacket p_250115_) {
        PacketUtils.ensureRunningOnSameThread(p_250115_, this, this.minecraft);
        for (ClientboundPlayerInfoUpdatePacket.Entry $$1 : p_250115_.newEntries()) {
            PlayerInfo $$2 = new PlayerInfo(Objects.requireNonNull($$1.profile()), this.enforcesSecureChat());
            if (this.playerInfoMap.putIfAbsent($$1.profileId(), $$2) != null) continue;
            this.minecraft.getPlayerSocialManager().addPlayer($$2);
        }
        for (ClientboundPlayerInfoUpdatePacket.Entry $$3 : p_250115_.entries()) {
            PlayerInfo $$4 = this.playerInfoMap.get($$3.profileId());
            if ($$4 == null) {
                LOGGER.warn("Ignoring player info update for unknown player {} ({})", (Object)$$3.profileId(), p_250115_.actions());
                continue;
            }
            for (ClientboundPlayerInfoUpdatePacket.Action $$5 : p_250115_.actions()) {
                this.applyPlayerInfoUpdate($$5, $$3, $$4);
            }
        }
    }

    private void applyPlayerInfoUpdate(ClientboundPlayerInfoUpdatePacket.Action p_248954_, ClientboundPlayerInfoUpdatePacket.Entry p_251310_, PlayerInfo p_251146_) {
        switch (p_248954_) {
            case INITIALIZE_CHAT: {
                this.initializeChatSession(p_251310_, p_251146_);
                break;
            }
            case UPDATE_GAME_MODE: {
                if (p_251146_.getGameMode() != p_251310_.gameMode() && this.minecraft.player != null && this.minecraft.player.getUUID().equals(p_251310_.profileId())) {
                    this.minecraft.player.onGameModeChanged(p_251310_.gameMode());
                }
                p_251146_.setGameMode(p_251310_.gameMode());
                break;
            }
            case UPDATE_LISTED: {
                if (p_251310_.listed()) {
                    this.listedPlayers.add(p_251146_);
                    break;
                }
                this.listedPlayers.remove(p_251146_);
                break;
            }
            case UPDATE_LATENCY: {
                p_251146_.setLatency(p_251310_.latency());
                break;
            }
            case UPDATE_DISPLAY_NAME: {
                p_251146_.setTabListDisplayName(p_251310_.displayName());
            }
        }
    }

    private void initializeChatSession(ClientboundPlayerInfoUpdatePacket.Entry p_248806_, PlayerInfo p_251136_) {
        GameProfile $$2 = p_251136_.getProfile();
        SignatureValidator $$3 = this.minecraft.getProfileKeySignatureValidator();
        if ($$3 == null) {
            LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)$$2.getName());
            p_251136_.clearChatSession(this.enforcesSecureChat());
            return;
        }
        RemoteChatSession.Data $$4 = p_248806_.chatSession();
        if ($$4 != null) {
            try {
                RemoteChatSession $$5 = $$4.validate($$2, $$3);
                p_251136_.setChatSession($$5);
            }
            catch (ProfilePublicKey.ValidationException $$6) {
                LOGGER.error("Failed to validate profile key for player: '{}'", (Object)$$2.getName(), (Object)$$6);
                p_251136_.clearChatSession(this.enforcesSecureChat());
            }
        } else {
            p_251136_.clearChatSession(this.enforcesSecureChat());
        }
    }

    private boolean enforcesSecureChat() {
        return this.minecraft.canValidateProfileKeys() && this.serverEnforcesSecureChat;
    }

    @Override
    public void handlePlayerAbilities(ClientboundPlayerAbilitiesPacket p_105048_) {
        PacketUtils.ensureRunningOnSameThread(p_105048_, this, this.minecraft);
        LocalPlayer $$1 = this.minecraft.player;
        $$1.getAbilities().flying = p_105048_.isFlying();
        $$1.getAbilities().instabuild = p_105048_.canInstabuild();
        $$1.getAbilities().invulnerable = p_105048_.isInvulnerable();
        $$1.getAbilities().mayfly = p_105048_.canFly();
        $$1.getAbilities().setFlyingSpeed(p_105048_.getFlyingSpeed());
        $$1.getAbilities().setWalkingSpeed(p_105048_.getWalkingSpeed());
    }

    @Override
    public void handleSoundEvent(ClientboundSoundPacket p_105114_) {
        PacketUtils.ensureRunningOnSameThread(p_105114_, this, this.minecraft);
        this.minecraft.level.playSeededSound((Player)this.minecraft.player, p_105114_.getX(), p_105114_.getY(), p_105114_.getZ(), p_105114_.getSound(), p_105114_.getSource(), p_105114_.getVolume(), p_105114_.getPitch(), p_105114_.getSeed());
    }

    @Override
    public void handleSoundEntityEvent(ClientboundSoundEntityPacket p_105112_) {
        PacketUtils.ensureRunningOnSameThread(p_105112_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105112_.getId());
        if ($$1 == null) {
            return;
        }
        this.minecraft.level.playSeededSound(this.minecraft.player, $$1, p_105112_.getSound(), p_105112_.getSource(), p_105112_.getVolume(), p_105112_.getPitch(), p_105112_.getSeed());
    }

    @Override
    public void handleBossUpdate(ClientboundBossEventPacket p_104982_) {
        PacketUtils.ensureRunningOnSameThread(p_104982_, this, this.minecraft);
        this.minecraft.gui.getBossOverlay().update(p_104982_);
    }

    @Override
    public void handleItemCooldown(ClientboundCooldownPacket p_105002_) {
        PacketUtils.ensureRunningOnSameThread(p_105002_, this, this.minecraft);
        if (p_105002_.duration() == 0) {
            this.minecraft.player.getCooldowns().removeCooldown(p_105002_.item());
        } else {
            this.minecraft.player.getCooldowns().addCooldown(p_105002_.item(), p_105002_.duration());
        }
    }

    @Override
    public void handleMoveVehicle(ClientboundMoveVehiclePacket p_105038_) {
        PacketUtils.ensureRunningOnSameThread(p_105038_, this, this.minecraft);
        Entity $$1 = this.minecraft.player.getRootVehicle();
        if ($$1 != this.minecraft.player && $$1.isControlledByLocalInstance()) {
            $$1.absMoveTo(p_105038_.getX(), p_105038_.getY(), p_105038_.getZ(), p_105038_.getYRot(), p_105038_.getXRot());
            this.connection.send(new ServerboundMoveVehiclePacket($$1));
        }
    }

    @Override
    public void handleOpenBook(ClientboundOpenBookPacket p_105040_) {
        PacketUtils.ensureRunningOnSameThread(p_105040_, this, this.minecraft);
        ItemStack $$1 = this.minecraft.player.getItemInHand(p_105040_.getHand());
        BookViewScreen.BookAccess $$2 = BookViewScreen.BookAccess.fromItem($$1);
        if ($$2 != null) {
            this.minecraft.setScreen(new BookViewScreen($$2));
        }
    }

    @Override
    public void handleCustomPayload(CustomPacketPayload p_295851_) {
        if (p_295851_ instanceof PathfindingDebugPayload) {
            PathfindingDebugPayload $$1 = (PathfindingDebugPayload)p_295851_;
            this.minecraft.debugRenderer.pathfindingRenderer.addPath($$1.entityId(), $$1.path(), $$1.maxNodeDistance());
        } else if (p_295851_ instanceof NeighborUpdatesDebugPayload) {
            NeighborUpdatesDebugPayload $$2 = (NeighborUpdatesDebugPayload)p_295851_;
            ((NeighborsUpdateRenderer)this.minecraft.debugRenderer.neighborsUpdateRenderer).addUpdate($$2.time(), $$2.pos());
        } else if (p_295851_ instanceof StructuresDebugPayload) {
            StructuresDebugPayload $$3 = (StructuresDebugPayload)p_295851_;
            this.minecraft.debugRenderer.structureRenderer.addBoundingBox($$3.mainBB(), $$3.pieces(), $$3.dimension());
        } else if (p_295851_ instanceof WorldGenAttemptDebugPayload) {
            WorldGenAttemptDebugPayload $$4 = (WorldGenAttemptDebugPayload)p_295851_;
            ((WorldGenAttemptRenderer)this.minecraft.debugRenderer.worldGenAttemptRenderer).addPos($$4.pos(), $$4.scale(), $$4.red(), $$4.green(), $$4.blue(), $$4.alpha());
        } else if (p_295851_ instanceof PoiTicketCountDebugPayload) {
            PoiTicketCountDebugPayload $$5 = (PoiTicketCountDebugPayload)p_295851_;
            this.minecraft.debugRenderer.brainDebugRenderer.setFreeTicketCount($$5.pos(), $$5.freeTicketCount());
        } else if (p_295851_ instanceof PoiAddedDebugPayload) {
            PoiAddedDebugPayload $$6 = (PoiAddedDebugPayload)p_295851_;
            BrainDebugRenderer.PoiInfo $$7 = new BrainDebugRenderer.PoiInfo($$6.pos(), $$6.poiType(), $$6.freeTicketCount());
            this.minecraft.debugRenderer.brainDebugRenderer.addPoi($$7);
        } else if (p_295851_ instanceof PoiRemovedDebugPayload) {
            PoiRemovedDebugPayload $$8 = (PoiRemovedDebugPayload)p_295851_;
            this.minecraft.debugRenderer.brainDebugRenderer.removePoi($$8.pos());
        } else if (p_295851_ instanceof VillageSectionsDebugPayload) {
            VillageSectionsDebugPayload $$9 = (VillageSectionsDebugPayload)p_295851_;
            VillageSectionsDebugRenderer $$10 = this.minecraft.debugRenderer.villageSectionsDebugRenderer;
            $$9.villageChunks().forEach($$10::setVillageSection);
            $$9.notVillageChunks().forEach($$10::setNotVillageSection);
        } else if (p_295851_ instanceof GoalDebugPayload) {
            GoalDebugPayload $$11 = (GoalDebugPayload)p_295851_;
            this.minecraft.debugRenderer.goalSelectorRenderer.addGoalSelector($$11.entityId(), $$11.pos(), $$11.goals());
        } else if (p_295851_ instanceof BrainDebugPayload) {
            BrainDebugPayload $$12 = (BrainDebugPayload)p_295851_;
            this.minecraft.debugRenderer.brainDebugRenderer.addOrUpdateBrainDump($$12.brainDump());
        } else if (p_295851_ instanceof BeeDebugPayload) {
            BeeDebugPayload $$13 = (BeeDebugPayload)p_295851_;
            this.minecraft.debugRenderer.beeDebugRenderer.addOrUpdateBeeInfo($$13.beeInfo());
        } else if (p_295851_ instanceof HiveDebugPayload) {
            HiveDebugPayload $$14 = (HiveDebugPayload)p_295851_;
            this.minecraft.debugRenderer.beeDebugRenderer.addOrUpdateHiveInfo($$14.hiveInfo(), this.level.getGameTime());
        } else if (p_295851_ instanceof GameTestAddMarkerDebugPayload) {
            GameTestAddMarkerDebugPayload $$15 = (GameTestAddMarkerDebugPayload)p_295851_;
            this.minecraft.debugRenderer.gameTestDebugRenderer.addMarker($$15.pos(), $$15.color(), $$15.text(), $$15.durationMs());
        } else if (p_295851_ instanceof GameTestClearMarkersDebugPayload) {
            this.minecraft.debugRenderer.gameTestDebugRenderer.clear();
        } else if (p_295851_ instanceof RaidsDebugPayload) {
            RaidsDebugPayload $$16 = (RaidsDebugPayload)p_295851_;
            this.minecraft.debugRenderer.raidDebugRenderer.setRaidCenters($$16.raidCenters());
        } else if (p_295851_ instanceof GameEventDebugPayload) {
            GameEventDebugPayload $$17 = (GameEventDebugPayload)p_295851_;
            this.minecraft.debugRenderer.gameEventListenerRenderer.trackGameEvent($$17.gameEventType(), $$17.pos());
        } else if (p_295851_ instanceof GameEventListenerDebugPayload) {
            GameEventListenerDebugPayload $$18 = (GameEventListenerDebugPayload)p_295851_;
            this.minecraft.debugRenderer.gameEventListenerRenderer.trackListener($$18.listenerPos(), $$18.listenerRange());
        } else if (p_295851_ instanceof BreezeDebugPayload) {
            BreezeDebugPayload $$19 = (BreezeDebugPayload)p_295851_;
            this.minecraft.debugRenderer.breezeDebugRenderer.add($$19.breezeInfo());
        } else {
            this.handleUnknownCustomPayload(p_295851_);
        }
    }

    private void handleUnknownCustomPayload(CustomPacketPayload p_294389_) {
        LOGGER.warn("Unknown custom packet payload: {}", (Object)p_294389_.type().id());
    }

    @Override
    public void handleAddObjective(ClientboundSetObjectivePacket p_105100_) {
        PacketUtils.ensureRunningOnSameThread(p_105100_, this, this.minecraft);
        String $$1 = p_105100_.getObjectiveName();
        if (p_105100_.getMethod() == 0) {
            this.scoreboard.addObjective($$1, ObjectiveCriteria.DUMMY, p_105100_.getDisplayName(), p_105100_.getRenderType(), false, p_105100_.getNumberFormat().orElse(null));
        } else {
            Objective $$2 = this.scoreboard.getObjective($$1);
            if ($$2 != null) {
                if (p_105100_.getMethod() == 1) {
                    this.scoreboard.removeObjective($$2);
                } else if (p_105100_.getMethod() == 2) {
                    $$2.setRenderType(p_105100_.getRenderType());
                    $$2.setDisplayName(p_105100_.getDisplayName());
                    $$2.setNumberFormat(p_105100_.getNumberFormat().orElse(null));
                }
            }
        }
    }

    @Override
    public void handleSetScore(ClientboundSetScorePacket p_105106_) {
        PacketUtils.ensureRunningOnSameThread(p_105106_, this, this.minecraft);
        String $$1 = p_105106_.objectiveName();
        ScoreHolder $$2 = ScoreHolder.forNameOnly(p_105106_.owner());
        Objective $$3 = this.scoreboard.getObjective($$1);
        if ($$3 != null) {
            ScoreAccess $$4 = this.scoreboard.getOrCreatePlayerScore($$2, $$3, true);
            $$4.set(p_105106_.score());
            $$4.display(p_105106_.display().orElse(null));
            $$4.numberFormatOverride(p_105106_.numberFormat().orElse(null));
        } else {
            LOGGER.warn("Received packet for unknown scoreboard objective: {}", (Object)$$1);
        }
    }

    @Override
    public void handleResetScore(ClientboundResetScorePacket p_313768_) {
        PacketUtils.ensureRunningOnSameThread(p_313768_, this, this.minecraft);
        String $$1 = p_313768_.objectiveName();
        ScoreHolder $$2 = ScoreHolder.forNameOnly(p_313768_.owner());
        if ($$1 == null) {
            this.scoreboard.resetAllPlayerScores($$2);
        } else {
            Objective $$3 = this.scoreboard.getObjective($$1);
            if ($$3 != null) {
                this.scoreboard.resetSinglePlayerScore($$2, $$3);
            } else {
                LOGGER.warn("Received packet for unknown scoreboard objective: {}", (Object)$$1);
            }
        }
    }

    @Override
    public void handleSetDisplayObjective(ClientboundSetDisplayObjectivePacket p_105086_) {
        PacketUtils.ensureRunningOnSameThread(p_105086_, this, this.minecraft);
        String $$1 = p_105086_.getObjectiveName();
        Objective $$2 = $$1 == null ? null : this.scoreboard.getObjective($$1);
        this.scoreboard.setDisplayObjective(p_105086_.getSlot(), $$2);
    }

    @Override
    public void handleSetPlayerTeamPacket(ClientboundSetPlayerTeamPacket p_105104_) {
        PlayerTeam $$3;
        PacketUtils.ensureRunningOnSameThread(p_105104_, this, this.minecraft);
        ClientboundSetPlayerTeamPacket.Action $$1 = p_105104_.getTeamAction();
        if ($$1 == ClientboundSetPlayerTeamPacket.Action.ADD) {
            PlayerTeam $$2 = this.scoreboard.addPlayerTeam(p_105104_.getName());
        } else {
            $$3 = this.scoreboard.getPlayerTeam(p_105104_.getName());
            if ($$3 == null) {
                LOGGER.warn("Received packet for unknown team {}: team action: {}, player action: {}", new Object[]{p_105104_.getName(), p_105104_.getTeamAction(), p_105104_.getPlayerAction()});
                return;
            }
        }
        Optional<ClientboundSetPlayerTeamPacket.Parameters> $$4 = p_105104_.getParameters();
        $$4.ifPresent(p_233670_ -> {
            Team.CollisionRule $$3;
            $$3.setDisplayName(p_233670_.getDisplayName());
            $$3.setColor(p_233670_.getColor());
            $$3.unpackOptions(p_233670_.getOptions());
            Team.Visibility $$2 = Team.Visibility.byName(p_233670_.getNametagVisibility());
            if ($$2 != null) {
                $$3.setNameTagVisibility($$2);
            }
            if (($$3 = Team.CollisionRule.byName(p_233670_.getCollisionRule())) != null) {
                $$3.setCollisionRule($$3);
            }
            $$3.setPlayerPrefix(p_233670_.getPlayerPrefix());
            $$3.setPlayerSuffix(p_233670_.getPlayerSuffix());
        });
        ClientboundSetPlayerTeamPacket.Action $$5 = p_105104_.getPlayerAction();
        if ($$5 == ClientboundSetPlayerTeamPacket.Action.ADD) {
            for (String $$6 : p_105104_.getPlayers()) {
                this.scoreboard.addPlayerToTeam($$6, $$3);
            }
        } else if ($$5 == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            for (String $$7 : p_105104_.getPlayers()) {
                this.scoreboard.removePlayerFromTeam($$7, $$3);
            }
        }
        if ($$1 == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            this.scoreboard.removePlayerTeam($$3);
        }
    }

    @Override
    public void handleParticleEvent(ClientboundLevelParticlesPacket p_105026_) {
        PacketUtils.ensureRunningOnSameThread(p_105026_, this, this.minecraft);
        if (p_105026_.getCount() == 0) {
            double $$1 = p_105026_.getMaxSpeed() * p_105026_.getXDist();
            double $$2 = p_105026_.getMaxSpeed() * p_105026_.getYDist();
            double $$3 = p_105026_.getMaxSpeed() * p_105026_.getZDist();
            try {
                this.level.addParticle(p_105026_.getParticle(), p_105026_.isOverrideLimiter(), p_105026_.getX(), p_105026_.getY(), p_105026_.getZ(), $$1, $$2, $$3);
            }
            catch (Throwable $$4) {
                LOGGER.warn("Could not spawn particle effect {}", (Object)p_105026_.getParticle());
            }
        } else {
            for (int $$5 = 0; $$5 < p_105026_.getCount(); ++$$5) {
                double $$6 = this.random.nextGaussian() * (double)p_105026_.getXDist();
                double $$7 = this.random.nextGaussian() * (double)p_105026_.getYDist();
                double $$8 = this.random.nextGaussian() * (double)p_105026_.getZDist();
                double $$9 = this.random.nextGaussian() * (double)p_105026_.getMaxSpeed();
                double $$10 = this.random.nextGaussian() * (double)p_105026_.getMaxSpeed();
                double $$11 = this.random.nextGaussian() * (double)p_105026_.getMaxSpeed();
                try {
                    this.level.addParticle(p_105026_.getParticle(), p_105026_.isOverrideLimiter(), p_105026_.getX() + $$6, p_105026_.getY() + $$7, p_105026_.getZ() + $$8, $$9, $$10, $$11);
                    continue;
                }
                catch (Throwable $$12) {
                    LOGGER.warn("Could not spawn particle effect {}", (Object)p_105026_.getParticle());
                    return;
                }
            }
        }
    }

    @Override
    public void handleUpdateAttributes(ClientboundUpdateAttributesPacket p_105128_) {
        PacketUtils.ensureRunningOnSameThread(p_105128_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_105128_.getEntityId());
        if ($$1 == null) {
            return;
        }
        if (!($$1 instanceof LivingEntity)) {
            throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + String.valueOf($$1) + ")");
        }
        AttributeMap $$2 = ((LivingEntity)$$1).getAttributes();
        for (ClientboundUpdateAttributesPacket.AttributeSnapshot $$3 : p_105128_.getValues()) {
            AttributeInstance $$4 = $$2.getInstance($$3.attribute());
            if ($$4 == null) {
                LOGGER.warn("Entity {} does not have attribute {}", (Object)$$1, (Object)$$3.attribute().getRegisteredName());
                continue;
            }
            $$4.setBaseValue($$3.base());
            $$4.removeModifiers();
            for (AttributeModifier $$5 : $$3.modifiers()) {
                $$4.addTransientModifier($$5);
            }
        }
    }

    @Override
    public void handlePlaceRecipe(ClientboundPlaceGhostRecipePacket p_105046_) {
        PacketUtils.ensureRunningOnSameThread(p_105046_, this, this.minecraft);
        AbstractContainerMenu $$1 = this.minecraft.player.containerMenu;
        if ($$1.containerId != p_105046_.getContainerId()) {
            return;
        }
        this.recipeManager.byKey(p_105046_.getRecipe()).ifPresent(p_300679_ -> {
            if (this.minecraft.screen instanceof RecipeUpdateListener) {
                RecipeBookComponent $$2 = ((RecipeUpdateListener)((Object)this.minecraft.screen)).getRecipeBookComponent();
                $$2.setupGhostRecipe((RecipeHolder<?>)p_300679_, (List<Slot>)p_300678_.slots);
            }
        });
    }

    @Override
    public void handleLightUpdatePacket(ClientboundLightUpdatePacket p_194243_) {
        PacketUtils.ensureRunningOnSameThread(p_194243_, this, this.minecraft);
        int $$1 = p_194243_.getX();
        int $$2 = p_194243_.getZ();
        ClientboundLightUpdatePacketData $$3 = p_194243_.getLightData();
        this.level.queueLightUpdate(() -> this.applyLightData($$1, $$2, $$3));
    }

    private void applyLightData(int p_194249_, int p_194250_, ClientboundLightUpdatePacketData p_194251_) {
        LevelLightEngine $$3 = this.level.getChunkSource().getLightEngine();
        BitSet $$4 = p_194251_.getSkyYMask();
        BitSet $$5 = p_194251_.getEmptySkyYMask();
        Iterator<byte[]> $$6 = p_194251_.getSkyUpdates().iterator();
        this.readSectionList(p_194249_, p_194250_, $$3, LightLayer.SKY, $$4, $$5, $$6);
        BitSet $$7 = p_194251_.getBlockYMask();
        BitSet $$8 = p_194251_.getEmptyBlockYMask();
        Iterator<byte[]> $$9 = p_194251_.getBlockUpdates().iterator();
        this.readSectionList(p_194249_, p_194250_, $$3, LightLayer.BLOCK, $$7, $$8, $$9);
        $$3.setLightEnabled(new ChunkPos(p_194249_, p_194250_), true);
    }

    @Override
    public void handleMerchantOffers(ClientboundMerchantOffersPacket p_105034_) {
        PacketUtils.ensureRunningOnSameThread(p_105034_, this, this.minecraft);
        AbstractContainerMenu $$1 = this.minecraft.player.containerMenu;
        if (p_105034_.getContainerId() == $$1.containerId && $$1 instanceof MerchantMenu) {
            MerchantMenu $$2 = (MerchantMenu)$$1;
            $$2.setOffers(p_105034_.getOffers());
            $$2.setXp(p_105034_.getVillagerXp());
            $$2.setMerchantLevel(p_105034_.getVillagerLevel());
            $$2.setShowProgressBar(p_105034_.showProgress());
            $$2.setCanRestock(p_105034_.canRestock());
        }
    }

    @Override
    public void handleSetChunkCacheRadius(ClientboundSetChunkCacheRadiusPacket p_105082_) {
        PacketUtils.ensureRunningOnSameThread(p_105082_, this, this.minecraft);
        this.serverChunkRadius = p_105082_.getRadius();
        this.minecraft.options.setServerRenderDistance(this.serverChunkRadius);
        this.level.getChunkSource().updateViewRadius(p_105082_.getRadius());
    }

    @Override
    public void handleSetSimulationDistance(ClientboundSetSimulationDistancePacket p_194245_) {
        PacketUtils.ensureRunningOnSameThread(p_194245_, this, this.minecraft);
        this.serverSimulationDistance = p_194245_.simulationDistance();
        this.level.setServerSimulationDistance(this.serverSimulationDistance);
    }

    @Override
    public void handleSetChunkCacheCenter(ClientboundSetChunkCacheCenterPacket p_105080_) {
        PacketUtils.ensureRunningOnSameThread(p_105080_, this, this.minecraft);
        this.level.getChunkSource().updateViewCenter(p_105080_.getX(), p_105080_.getZ());
    }

    @Override
    public void handleBlockChangedAck(ClientboundBlockChangedAckPacket p_233698_) {
        PacketUtils.ensureRunningOnSameThread(p_233698_, this, this.minecraft);
        this.level.handleBlockChangedAck(p_233698_.sequence());
    }

    @Override
    public void handleBundlePacket(ClientboundBundlePacket p_265195_) {
        PacketUtils.ensureRunningOnSameThread(p_265195_, this, this.minecraft);
        for (Packet<ClientPacketListener> packet : p_265195_.subPackets()) {
            packet.handle(this);
        }
    }

    @Override
    public void handleProjectilePowerPacket(ClientboundProjectilePowerPacket p_339600_) {
        PacketUtils.ensureRunningOnSameThread(p_339600_, this, this.minecraft);
        Entity $$1 = this.level.getEntity(p_339600_.getId());
        if ($$1 instanceof AbstractHurtingProjectile) {
            AbstractHurtingProjectile $$2 = (AbstractHurtingProjectile)$$1;
            $$2.accelerationPower = p_339600_.getAccelerationPower();
        }
    }

    @Override
    public void handleChunkBatchStart(ClientboundChunkBatchStartPacket p_295704_) {
        this.chunkBatchSizeCalculator.onBatchStart();
    }

    @Override
    public void handleChunkBatchFinished(ClientboundChunkBatchFinishedPacket p_295731_) {
        this.chunkBatchSizeCalculator.onBatchFinished(p_295731_.batchSize());
        this.send(new ServerboundChunkBatchReceivedPacket(this.chunkBatchSizeCalculator.getDesiredChunksPerTick()));
    }

    @Override
    public void handleDebugSample(ClientboundDebugSamplePacket p_324125_) {
        this.minecraft.getDebugOverlay().logRemoteSample(p_324125_.sample(), p_324125_.debugSampleType());
    }

    @Override
    public void handlePongResponse(ClientboundPongResponsePacket p_320651_) {
        this.pingDebugMonitor.onPongReceived(p_320651_);
    }

    private void readSectionList(int p_171735_, int p_171736_, LevelLightEngine p_171737_, LightLayer p_171738_, BitSet p_171739_, BitSet p_171740_, Iterator<byte[]> p_171741_) {
        for (int $$7 = 0; $$7 < p_171737_.getLightSectionCount(); ++$$7) {
            int $$8 = p_171737_.getMinLightSection() + $$7;
            boolean $$9 = p_171739_.get($$7);
            boolean $$10 = p_171740_.get($$7);
            if (!$$9 && !$$10) continue;
            p_171737_.queueSectionData(p_171738_, SectionPos.of(p_171735_, $$8, p_171736_), $$9 ? new DataLayer((byte[])p_171741_.next().clone()) : new DataLayer());
            this.level.setSectionDirtyWithNeighbors(p_171735_, $$8, p_171736_);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.closed;
    }

    public Collection<PlayerInfo> getListedOnlinePlayers() {
        return this.listedPlayers;
    }

    public Collection<PlayerInfo> getOnlinePlayers() {
        return this.playerInfoMap.values();
    }

    public Collection<UUID> getOnlinePlayerIds() {
        return this.playerInfoMap.keySet();
    }

    @Nullable
    public PlayerInfo getPlayerInfo(UUID p_104950_) {
        return this.playerInfoMap.get(p_104950_);
    }

    @Nullable
    public PlayerInfo getPlayerInfo(String p_104939_) {
        for (PlayerInfo $$1 : this.playerInfoMap.values()) {
            if (!$$1.getProfile().getName().equals(p_104939_)) continue;
            return $$1;
        }
        return null;
    }

    public GameProfile getLocalGameProfile() {
        return this.localGameProfile;
    }

    public ClientAdvancements getAdvancements() {
        return this.advancements;
    }

    public CommandDispatcher<SharedSuggestionProvider> getCommands() {
        return this.commands;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    public DebugQueryHandler getDebugQueryHandler() {
        return this.debugQueryHandler;
    }

    public UUID getId() {
        return this.id;
    }

    public Set<ResourceKey<Level>> levels() {
        return this.levels;
    }

    public RegistryAccess.Frozen registryAccess() {
        return this.registryAccess;
    }

    public void markMessageAsProcessed(PlayerChatMessage p_242356_, boolean p_242455_) {
        MessageSignature $$2 = p_242356_.signature();
        if ($$2 != null && this.lastSeenMessages.addPending($$2, p_242455_) && this.lastSeenMessages.offset() > 64) {
            this.sendChatAcknowledgement();
        }
    }

    private void sendChatAcknowledgement() {
        int $$0 = this.lastSeenMessages.getAndClearOffset();
        if ($$0 > 0) {
            this.send(new ServerboundChatAckPacket($$0));
        }
    }

    public void sendChat(String p_249888_) {
        Instant $$1 = Instant.now();
        long $$2 = Crypt.SaltSupplier.getLong();
        LastSeenMessagesTracker.Update $$3 = this.lastSeenMessages.generateAndApplyUpdate();
        MessageSignature $$4 = this.signedMessageEncoder.pack(new SignedMessageBody(p_249888_, $$1, $$2, $$3.lastSeen()));
        this.send(new ServerboundChatPacket(p_249888_, $$1, $$2, $$4, $$3.update()));
    }

    public void sendCommand(String p_250092_) {
        SignableCommand<SharedSuggestionProvider> $$1 = SignableCommand.of(this.parseCommand(p_250092_));
        if ($$1.arguments().isEmpty()) {
            this.send(new ServerboundChatCommandPacket(p_250092_));
            return;
        }
        Instant $$2 = Instant.now();
        long $$3 = Crypt.SaltSupplier.getLong();
        LastSeenMessagesTracker.Update $$4 = this.lastSeenMessages.generateAndApplyUpdate();
        ArgumentSignatures $$5 = ArgumentSignatures.signCommand($$1, p_247875_ -> {
            SignedMessageBody $$4 = new SignedMessageBody(p_247875_, $$2, $$3, $$4.lastSeen());
            return this.signedMessageEncoder.pack($$4);
        });
        this.send(new ServerboundChatCommandSignedPacket(p_250092_, $$2, $$3, $$5, $$4.update()));
    }

    public boolean sendUnsignedCommand(String p_251509_) {
        if (!SignableCommand.hasSignableArguments(this.parseCommand(p_251509_))) {
            this.send(new ServerboundChatCommandPacket(p_251509_));
            return true;
        }
        return false;
    }

    private ParseResults<SharedSuggestionProvider> parseCommand(String p_249982_) {
        return this.commands.parse(p_249982_, (Object)this.suggestionsProvider);
    }

    @Override
    public void tick() {
        ProfileKeyPairManager $$0;
        if (this.connection.isEncrypted() && ($$0 = this.minecraft.getProfileKeyPairManager()).shouldRefreshKeyPair()) {
            $$0.prepareKeyPair().thenAcceptAsync(p_253339_ -> p_253339_.ifPresent(this::setKeyPair), (Executor)this.minecraft);
        }
        this.sendDeferredPackets();
        if (this.minecraft.getDebugOverlay().showNetworkCharts()) {
            this.pingDebugMonitor.tick();
        }
        this.debugSampleSubscriber.tick();
        this.telemetryManager.tick();
        if (this.levelLoadStatusManager != null) {
            this.levelLoadStatusManager.tick();
        }
    }

    public void setKeyPair(ProfileKeyPair p_261475_) {
        if (!this.minecraft.isLocalPlayer(this.localGameProfile.getId())) {
            return;
        }
        if (this.chatSession != null && this.chatSession.keyPair().equals(p_261475_)) {
            return;
        }
        this.chatSession = LocalChatSession.create(p_261475_);
        this.signedMessageEncoder = this.chatSession.createMessageEncoder(this.localGameProfile.getId());
        this.send(new ServerboundChatSessionUpdatePacket(this.chatSession.asRemote().asData()));
    }

    @Nullable
    public ServerData getServerData() {
        return this.serverData;
    }

    public FeatureFlagSet enabledFeatures() {
        return this.enabledFeatures;
    }

    public boolean isFeatureEnabled(FeatureFlagSet p_250605_) {
        return p_250605_.isSubsetOf(this.enabledFeatures());
    }

    public Scoreboard scoreboard() {
        return this.scoreboard;
    }

    public PotionBrewing potionBrewing() {
        return this.potionBrewing;
    }

    public void updateSearchTrees() {
        this.searchTrees.rebuildAfterLanguageChange();
    }

    public SessionSearchTrees searchTrees() {
        return this.searchTrees;
    }

    public ServerLinks serverLinks() {
        return this.serverLinks;
    }
}

