/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.Queues;
import com.mojang.math.MatrixUtil;
import java.util.Deque;
import net.minecraft.Util;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PoseStack {
    private final Deque<Pose> poseStack = Util.make(Queues.newArrayDeque(), p_85848_ -> {
        Matrix4f $$1 = new Matrix4f();
        Matrix3f $$2 = new Matrix3f();
        p_85848_.add(new Pose($$1, $$2));
    });

    public void translate(double p_85838_, double p_85839_, double p_85840_) {
        this.translate((float)p_85838_, (float)p_85839_, (float)p_85840_);
    }

    public void translate(float p_254202_, float p_253782_, float p_254238_) {
        Pose $$3 = this.poseStack.getLast();
        $$3.pose.translate(p_254202_, p_253782_, p_254238_);
    }

    public void scale(float p_85842_, float p_85843_, float p_85844_) {
        Pose $$3 = this.poseStack.getLast();
        $$3.pose.scale(p_85842_, p_85843_, p_85844_);
        if (Math.abs(p_85842_) == Math.abs(p_85843_) && Math.abs(p_85843_) == Math.abs(p_85844_)) {
            if (p_85842_ < 0.0f || p_85843_ < 0.0f || p_85844_ < 0.0f) {
                $$3.normal.scale(Math.signum(p_85842_), Math.signum(p_85843_), Math.signum(p_85844_));
            }
            return;
        }
        $$3.normal.scale(1.0f / p_85842_, 1.0f / p_85843_, 1.0f / p_85844_);
        $$3.trustedNormals = false;
    }

    public void mulPose(Quaternionf p_254385_) {
        Pose $$1 = this.poseStack.getLast();
        $$1.pose.rotate((Quaternionfc)p_254385_);
        $$1.normal.rotate((Quaternionfc)p_254385_);
    }

    public void rotateAround(Quaternionf p_272904_, float p_273581_, float p_272655_, float p_273275_) {
        Pose $$4 = this.poseStack.getLast();
        $$4.pose.rotateAround((Quaternionfc)p_272904_, p_273581_, p_272655_, p_273275_);
        $$4.normal.rotate((Quaternionfc)p_272904_);
    }

    public void pushPose() {
        this.poseStack.addLast(new Pose(this.poseStack.getLast()));
    }

    public void popPose() {
        this.poseStack.removeLast();
    }

    public Pose last() {
        return this.poseStack.getLast();
    }

    public boolean clear() {
        return this.poseStack.size() == 1;
    }

    public void setIdentity() {
        Pose $$0 = this.poseStack.getLast();
        $$0.pose.identity();
        $$0.normal.identity();
        $$0.trustedNormals = true;
    }

    public void mulPose(Matrix4f p_324519_) {
        Pose $$1 = this.poseStack.getLast();
        $$1.pose.mul((Matrix4fc)p_324519_);
        if (!MatrixUtil.isPureTranslation(p_324519_)) {
            if (MatrixUtil.isOrthonormal(p_324519_)) {
                $$1.normal.mul((Matrix3fc)new Matrix3f((Matrix4fc)p_324519_));
            } else {
                $$1.computeNormalMatrix();
            }
        }
    }

    public static final class Pose {
        final Matrix4f pose;
        final Matrix3f normal;
        boolean trustedNormals = true;

        Pose(Matrix4f p_254509_, Matrix3f p_254348_) {
            this.pose = p_254509_;
            this.normal = p_254348_;
        }

        Pose(Pose p_324130_) {
            this.pose = new Matrix4f((Matrix4fc)p_324130_.pose);
            this.normal = new Matrix3f((Matrix3fc)p_324130_.normal);
            this.trustedNormals = p_324130_.trustedNormals;
        }

        void computeNormalMatrix() {
            this.normal.set((Matrix4fc)this.pose).invert().transpose();
            this.trustedNormals = false;
        }

        public Matrix4f pose() {
            return this.pose;
        }

        public Matrix3f normal() {
            return this.normal;
        }

        public Vector3f transformNormal(Vector3f p_324099_, Vector3f p_323689_) {
            return this.transformNormal(p_324099_.x, p_324099_.y, p_324099_.z, p_323689_);
        }

        public Vector3f transformNormal(float p_324226_, float p_324133_, float p_323766_, Vector3f p_324001_) {
            Vector3f $$4 = this.normal.transform(p_324226_, p_324133_, p_323766_, p_324001_);
            return this.trustedNormals ? $$4 : $$4.normalize();
        }

        public Pose copy() {
            return new Pose(this);
        }
    }
}

