/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.DebugMemoryUntracker;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.slf4j.Logger;

public class GlDebug {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CIRCULAR_LOG_SIZE = 10;
    private static final Queue<LogEntry> MESSAGE_BUFFER = EvictingQueue.create((int)10);
    @Nullable
    private static volatile LogEntry lastEntry;
    private static final List<Integer> DEBUG_LEVELS;
    private static final List<Integer> DEBUG_LEVELS_ARB;
    private static boolean debugEnabled;

    private static String printUnknownToken(int p_84037_) {
        return "Unknown (0x" + Integer.toHexString(p_84037_).toUpperCase() + ")";
    }

    public static String sourceToString(int p_84056_) {
        switch (p_84056_) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return GlDebug.printUnknownToken(p_84056_);
    }

    public static String typeToString(int p_84058_) {
        switch (p_84058_) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return GlDebug.printUnknownToken(p_84058_);
    }

    public static String severityToString(int p_84060_) {
        switch (p_84060_) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
            case 33387: {
                return "NOTIFICATION";
            }
        }
        return GlDebug.printUnknownToken(p_84060_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void printDebugLog(int p_84039_, int p_84040_, int p_84041_, int p_84042_, int p_84043_, long p_84044_, long p_84045_) {
        void $$9;
        String $$7 = GLDebugMessageCallback.getMessage((int)p_84043_, (long)p_84044_);
        Queue<LogEntry> queue = MESSAGE_BUFFER;
        synchronized (queue) {
            LogEntry $$8 = lastEntry;
            if ($$8 == null || !$$8.isSame(p_84039_, p_84040_, p_84041_, p_84042_, $$7)) {
                $$8 = new LogEntry(p_84039_, p_84040_, p_84041_, p_84042_, $$7);
                MESSAGE_BUFFER.add($$8);
                lastEntry = $$8;
            } else {
                ++$$8.count;
            }
        }
        LOGGER.info("OpenGL debug message: {}", (Object)$$9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLastOpenGlDebugMessages() {
        Queue<LogEntry> queue = MESSAGE_BUFFER;
        synchronized (queue) {
            ArrayList $$0 = Lists.newArrayListWithCapacity((int)MESSAGE_BUFFER.size());
            for (LogEntry $$1 : MESSAGE_BUFFER) {
                $$0.add(String.valueOf($$1) + " x " + $$1.count);
            }
            return $$0;
        }
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void enableDebugCallback(int p_84050_, boolean p_84051_) {
        if (p_84050_ <= 0) {
            return;
        }
        GLCapabilities $$2 = GL.getCapabilities();
        if ($$2.GL_KHR_debug) {
            debugEnabled = true;
            GL11.glEnable((int)37600);
            if (p_84051_) {
                GL11.glEnable((int)33346);
            }
            for (int $$3 = 0; $$3 < DEBUG_LEVELS.size(); ++$$3) {
                boolean $$4 = $$3 < p_84050_;
                KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)DEBUG_LEVELS.get($$3), (int[])null, (boolean)$$4);
            }
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.make(GLDebugMessageCallback.create(GlDebug::printDebugLog), DebugMemoryUntracker::untrack)), (long)0L);
        } else if ($$2.GL_ARB_debug_output) {
            debugEnabled = true;
            if (p_84051_) {
                GL11.glEnable((int)33346);
            }
            for (int $$5 = 0; $$5 < DEBUG_LEVELS_ARB.size(); ++$$5) {
                boolean $$6 = $$5 < p_84050_;
                ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)DEBUG_LEVELS_ARB.get($$5), (int[])null, (boolean)$$6);
            }
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLX.make(GLDebugMessageARBCallback.create(GlDebug::printDebugLog), DebugMemoryUntracker::untrack)), (long)0L);
        }
    }

    static {
        DEBUG_LEVELS = ImmutableList.of((Object)37190, (Object)37191, (Object)37192, (Object)33387);
        DEBUG_LEVELS_ARB = ImmutableList.of((Object)37190, (Object)37191, (Object)37192);
    }

    static class LogEntry {
        private final int id;
        private final int source;
        private final int type;
        private final int severity;
        private final String message;
        int count = 1;

        LogEntry(int p_166234_, int p_166235_, int p_166236_, int p_166237_, String p_166238_) {
            this.id = p_166236_;
            this.source = p_166234_;
            this.type = p_166235_;
            this.severity = p_166237_;
            this.message = p_166238_;
        }

        boolean isSame(int p_166240_, int p_166241_, int p_166242_, int p_166243_, String p_166244_) {
            return p_166241_ == this.type && p_166240_ == this.source && p_166242_ == this.id && p_166243_ == this.severity && p_166244_.equals(this.message);
        }

        public String toString() {
            return "id=" + this.id + ", source=" + GlDebug.sourceToString(this.source) + ", type=" + GlDebug.typeToString(this.type) + ", severity=" + GlDebug.severityToString(this.severity) + ", message='" + this.message + "'";
        }
    }
}

