/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;

public abstract class StructurePiece {
    private static final Logger f_163536_ = LogUtils.getLogger();
    protected static final BlockState f_73382_ = Blocks.f_50627_.m_49966_();
    protected BoundingBox f_73383_;
    @Nullable
    private Direction f_73377_;
    private Mirror f_73378_;
    private Rotation f_73379_;
    protected int f_73384_;
    private final StructurePieceType f_73380_;
    private static final Set<Block> f_73381_ = ImmutableSet.builder().add((Object)Blocks.f_50198_).add((Object)Blocks.f_50081_).add((Object)Blocks.f_50082_).add((Object)Blocks.f_50132_).add((Object)Blocks.f_50479_).add((Object)Blocks.f_50483_).add((Object)Blocks.f_50482_).add((Object)Blocks.f_50480_).add((Object)Blocks.f_50481_).add((Object)Blocks.f_50155_).add((Object)Blocks.f_50183_).build();

    protected StructurePiece(StructurePieceType p_209994_, int p_209995_, BoundingBox p_209996_) {
        this.f_73380_ = p_209994_;
        this.f_73384_ = p_209995_;
        this.f_73383_ = p_209996_;
    }

    public StructurePiece(StructurePieceType p_209998_, CompoundTag p_209999_) {
        this(p_209998_, p_209999_.m_128451_("GD"), (BoundingBox)BoundingBox.f_162354_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_209999_.m_128423_("BB")).resultOrPartial(arg_0 -> ((Logger)f_163536_).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid boundingbox")));
        int i = p_209999_.m_128451_("O");
        this.m_73519_(i == -1 ? null : Direction.m_122407_(i));
    }

    protected static BoundingBox m_163541_(int p_163542_, int p_163543_, int p_163544_, Direction p_163545_, int p_163546_, int p_163547_, int p_163548_) {
        return p_163545_.m_122434_() == Direction.Axis.Z ? new BoundingBox(p_163542_, p_163543_, p_163544_, p_163542_ + p_163546_ - 1, p_163543_ + p_163547_ - 1, p_163544_ + p_163548_ - 1) : new BoundingBox(p_163542_, p_163543_, p_163544_, p_163542_ + p_163548_ - 1, p_163543_ + p_163547_ - 1, p_163544_ + p_163546_ - 1);
    }

    protected static Direction m_226760_(RandomSource p_226761_) {
        return Direction.Plane.HORIZONTAL.m_235690_(p_226761_);
    }

    public final CompoundTag m_192644_(StructurePieceSerializationContext p_192645_) {
        if (BuiltInRegistries.f_257014_.m_7981_((Object)this.m_210000_()) == null) {
            throw new RuntimeException("StructurePiece \"" + this.getClass().getName() + "\": \"" + this.m_210000_() + "\" unregistered, serializing impossible.");
        }
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("id", BuiltInRegistries.f_257014_.m_7981_((Object)this.m_210000_()).toString());
        BoundingBox.f_162354_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.f_73383_).resultOrPartial(arg_0 -> ((Logger)f_163536_).error(arg_0)).ifPresent(p_163579_ -> compoundtag.m_128365_("BB", (Tag)p_163579_));
        Direction direction = this.m_73549_();
        compoundtag.m_128405_("O", direction == null ? -1 : direction.m_122416_());
        compoundtag.m_128405_("GD", this.f_73384_);
        this.m_183620_(p_192645_, compoundtag);
        return compoundtag;
    }

    protected abstract void m_183620_(StructurePieceSerializationContext var1, CompoundTag var2);

    public void m_214092_(StructurePiece p_226835_, StructurePieceAccessor p_226836_, RandomSource p_226837_) {
    }

    public abstract void m_213694_(WorldGenLevel var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, BoundingBox var5, ChunkPos var6, BlockPos var7);

    public BoundingBox m_73547_() {
        return this.f_73383_;
    }

    public int m_73548_() {
        return this.f_73384_;
    }

    public void m_226758_(int p_226759_) {
        this.f_73384_ = p_226759_;
    }

    public boolean m_73411_(ChunkPos p_73412_, int p_73413_) {
        int i = p_73412_.m_45604_();
        int j = p_73412_.m_45605_();
        return this.f_73383_.m_71019_(i - p_73413_, j - p_73413_, i + 15 + p_73413_, j + 15 + p_73413_);
    }

    public BlockPos m_142171_() {
        return new BlockPos((Vec3i)this.f_73383_.m_162394_());
    }

    protected BlockPos.MutableBlockPos m_163582_(int p_163583_, int p_163584_, int p_163585_) {
        return new BlockPos.MutableBlockPos(this.m_73392_(p_163583_, p_163585_), this.m_73544_(p_163584_), this.m_73525_(p_163583_, p_163585_));
    }

    protected int m_73392_(int p_73393_, int p_73394_) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return p_73393_;
        }
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return this.f_73383_.m_162395_() + p_73393_;
            }
            case WEST: {
                return this.f_73383_.m_162399_() - p_73394_;
            }
            case EAST: {
                return this.f_73383_.m_162395_() + p_73394_;
            }
        }
        return p_73393_;
    }

    protected int m_73544_(int p_73545_) {
        return this.m_73549_() == null ? p_73545_ : p_73545_ + this.f_73383_.m_162396_();
    }

    protected int m_73525_(int p_73526_, int p_73527_) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return p_73527_;
        }
        switch (direction) {
            case NORTH: {
                return this.f_73383_.m_162401_() - p_73527_;
            }
            case SOUTH: {
                return this.f_73383_.m_162398_() + p_73527_;
            }
            case WEST: 
            case EAST: {
                return this.f_73383_.m_162398_() + p_73526_;
            }
        }
        return p_73527_;
    }

    protected void m_73434_(WorldGenLevel p_73435_, BlockState p_73436_, int p_73437_, int p_73438_, int p_73439_, BoundingBox p_73440_) {
        BlockPos.MutableBlockPos blockpos = this.m_163582_(p_73437_, p_73438_, p_73439_);
        if (p_73440_.m_71051_((Vec3i)blockpos) && this.m_142085_((LevelReader)p_73435_, p_73437_, p_73438_, p_73439_, p_73440_)) {
            if (this.f_73378_ != Mirror.NONE) {
                p_73436_ = p_73436_.m_60715_(this.f_73378_);
            }
            if (this.f_73379_ != Rotation.NONE) {
                p_73436_ = p_73436_.m_60717_(this.f_73379_);
            }
            p_73435_.m_7731_((BlockPos)blockpos, p_73436_, 2);
            FluidState fluidstate = p_73435_.m_6425_((BlockPos)blockpos);
            if (!fluidstate.m_76178_()) {
                p_73435_.m_186469_((BlockPos)blockpos, fluidstate.m_76152_(), 0);
            }
            if (f_73381_.contains(p_73436_.m_60734_())) {
                p_73435_.m_46865_((BlockPos)blockpos).m_8113_((BlockPos)blockpos);
            }
        }
    }

    protected boolean m_142085_(LevelReader p_163553_, int p_163554_, int p_163555_, int p_163556_, BoundingBox p_163557_) {
        return true;
    }

    protected BlockState m_73398_(BlockGetter p_73399_, int p_73400_, int p_73401_, int p_73402_, BoundingBox p_73403_) {
        BlockPos.MutableBlockPos blockpos = this.m_163582_(p_73400_, p_73401_, p_73402_);
        return !p_73403_.m_71051_((Vec3i)blockpos) ? Blocks.f_50016_.m_49966_() : p_73399_.m_8055_((BlockPos)blockpos);
    }

    protected boolean m_73414_(LevelReader p_73415_, int p_73416_, int p_73417_, int p_73418_, BoundingBox p_73419_) {
        BlockPos.MutableBlockPos blockpos = this.m_163582_(p_73416_, p_73417_ + 1, p_73418_);
        if (!p_73419_.m_71051_((Vec3i)blockpos)) {
            return false;
        }
        return blockpos.m_123342_() < p_73415_.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, blockpos.m_123341_(), blockpos.m_123343_());
    }

    protected void m_73535_(WorldGenLevel p_73536_, BoundingBox p_73537_, int p_73538_, int p_73539_, int p_73540_, int p_73541_, int p_73542_, int p_73543_) {
        for (int i = p_73539_; i <= p_73542_; ++i) {
            for (int j = p_73538_; j <= p_73541_; ++j) {
                for (int k = p_73540_; k <= p_73543_; ++k) {
                    this.m_73434_(p_73536_, Blocks.f_50016_.m_49966_(), j, i, k, p_73537_);
                }
            }
        }
    }

    protected void m_73441_(WorldGenLevel p_73442_, BoundingBox p_73443_, int p_73444_, int p_73445_, int p_73446_, int p_73447_, int p_73448_, int p_73449_, BlockState p_73450_, BlockState p_73451_, boolean p_73452_) {
        for (int i = p_73445_; i <= p_73448_; ++i) {
            for (int j = p_73444_; j <= p_73447_; ++j) {
                for (int k = p_73446_; k <= p_73449_; ++k) {
                    if (p_73452_ && this.m_73398_((BlockGetter)p_73442_, j, i, k, p_73443_).m_60795_()) continue;
                    if (i != p_73445_ && i != p_73448_ && j != p_73444_ && j != p_73447_ && k != p_73446_ && k != p_73449_) {
                        this.m_73434_(p_73442_, p_73451_, j, i, k, p_73443_);
                        continue;
                    }
                    this.m_73434_(p_73442_, p_73450_, j, i, k, p_73443_);
                }
            }
        }
    }

    protected void m_163558_(WorldGenLevel p_163559_, BoundingBox p_163560_, BoundingBox p_163561_, BlockState p_163562_, BlockState p_163563_, boolean p_163564_) {
        this.m_73441_(p_163559_, p_163560_, p_163561_.m_162395_(), p_163561_.m_162396_(), p_163561_.m_162398_(), p_163561_.m_162399_(), p_163561_.m_162400_(), p_163561_.m_162401_(), p_163562_, p_163563_, p_163564_);
    }

    protected void m_226776_(WorldGenLevel p_226777_, BoundingBox p_226778_, int p_226779_, int p_226780_, int p_226781_, int p_226782_, int p_226783_, int p_226784_, boolean p_226785_, RandomSource p_226786_, BlockSelector p_226787_) {
        for (int i = p_226780_; i <= p_226783_; ++i) {
            for (int j = p_226779_; j <= p_226782_; ++j) {
                for (int k = p_226781_; k <= p_226784_; ++k) {
                    if (p_226785_ && this.m_73398_((BlockGetter)p_226777_, j, i, k, p_226778_).m_60795_()) continue;
                    p_226787_.m_213766_(p_226786_, j, i, k, i == p_226780_ || i == p_226783_ || j == p_226779_ || j == p_226782_ || k == p_226781_ || k == p_226784_);
                    this.m_73434_(p_226777_, p_226787_.m_73555_(), j, i, k, p_226778_);
                }
            }
        }
    }

    protected void m_226828_(WorldGenLevel p_226829_, BoundingBox p_226830_, BoundingBox p_226831_, boolean p_226832_, RandomSource p_226833_, BlockSelector p_226834_) {
        this.m_226776_(p_226829_, p_226830_, p_226831_.m_162395_(), p_226831_.m_162396_(), p_226831_.m_162398_(), p_226831_.m_162399_(), p_226831_.m_162400_(), p_226831_.m_162401_(), p_226832_, p_226833_, p_226834_);
    }

    protected void m_226788_(WorldGenLevel p_226789_, BoundingBox p_226790_, RandomSource p_226791_, float p_226792_, int p_226793_, int p_226794_, int p_226795_, int p_226796_, int p_226797_, int p_226798_, BlockState p_226799_, BlockState p_226800_, boolean p_226801_, boolean p_226802_) {
        for (int i = p_226794_; i <= p_226797_; ++i) {
            for (int j = p_226793_; j <= p_226796_; ++j) {
                for (int k = p_226795_; k <= p_226798_; ++k) {
                    if (p_226791_.m_188501_() > p_226792_ || p_226801_ && this.m_73398_((BlockGetter)p_226789_, j, i, k, p_226790_).m_60795_() || p_226802_ && !this.m_73414_((LevelReader)p_226789_, j, i, k, p_226790_)) continue;
                    if (i != p_226794_ && i != p_226797_ && j != p_226793_ && j != p_226796_ && k != p_226795_ && k != p_226798_) {
                        this.m_73434_(p_226789_, p_226800_, j, i, k, p_226790_);
                        continue;
                    }
                    this.m_73434_(p_226789_, p_226799_, j, i, k, p_226790_);
                }
            }
        }
    }

    protected void m_226803_(WorldGenLevel p_226804_, BoundingBox p_226805_, RandomSource p_226806_, float p_226807_, int p_226808_, int p_226809_, int p_226810_, BlockState p_226811_) {
        if (p_226806_.m_188501_() < p_226807_) {
            this.m_73434_(p_226804_, p_226811_, p_226808_, p_226809_, p_226810_, p_226805_);
        }
    }

    protected void m_73453_(WorldGenLevel p_73454_, BoundingBox p_73455_, int p_73456_, int p_73457_, int p_73458_, int p_73459_, int p_73460_, int p_73461_, BlockState p_73462_, boolean p_73463_) {
        float f = p_73459_ - p_73456_ + 1;
        float f1 = p_73460_ - p_73457_ + 1;
        float f2 = p_73461_ - p_73458_ + 1;
        float f3 = (float)p_73456_ + f / 2.0f;
        float f4 = (float)p_73458_ + f2 / 2.0f;
        for (int i = p_73457_; i <= p_73460_; ++i) {
            float f5 = (float)(i - p_73457_) / f1;
            for (int j = p_73456_; j <= p_73459_; ++j) {
                float f6 = ((float)j - f3) / (f * 0.5f);
                for (int k = p_73458_; k <= p_73461_; ++k) {
                    float f8;
                    float f7 = ((float)k - f4) / (f2 * 0.5f);
                    if (p_73463_ && this.m_73398_((BlockGetter)p_73454_, j, i, k, p_73455_).m_60795_() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.m_73434_(p_73454_, p_73462_, j, i, k, p_73455_);
                }
            }
        }
    }

    protected void m_73528_(WorldGenLevel p_73529_, BlockState p_73530_, int p_73531_, int p_73532_, int p_73533_, BoundingBox p_73534_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = this.m_163582_(p_73531_, p_73532_, p_73533_);
        if (p_73534_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
            while (this.m_163572_(p_73529_.m_8055_((BlockPos)blockpos$mutableblockpos)) && blockpos$mutableblockpos.m_123342_() > p_73529_.m_141937_() + 1) {
                p_73529_.m_7731_((BlockPos)blockpos$mutableblockpos, p_73530_, 2);
                blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            }
        }
    }

    protected boolean m_163572_(BlockState p_163573_) {
        return p_163573_.m_60795_() || p_163573_.m_278721_() || p_163573_.m_60713_(Blocks.f_152475_) || p_163573_.m_60713_(Blocks.f_50037_) || p_163573_.m_60713_(Blocks.f_50038_);
    }

    protected boolean m_213787_(WorldGenLevel p_226812_, BoundingBox p_226813_, RandomSource p_226814_, int p_226815_, int p_226816_, int p_226817_, ResourceLocation p_226818_) {
        return this.m_226762_((ServerLevelAccessor)p_226812_, p_226813_, p_226814_, (BlockPos)this.m_163582_(p_226815_, p_226816_, p_226817_), p_226818_, null);
    }

    public static BlockState m_73407_(BlockGetter p_73408_, BlockPos p_73409_, BlockState p_73410_) {
        Direction direction = null;
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_73409_.m_121945_(direction1);
            BlockState blockstate = p_73408_.m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50087_)) {
                return p_73410_;
            }
            if (!blockstate.m_60804_(p_73408_, blockpos)) continue;
            if (direction != null) {
                direction = null;
                break;
            }
            direction = direction1;
        }
        if (direction != null) {
            return (BlockState)((Object)p_73410_.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Object)direction.m_122424_())));
        }
        Direction direction2 = (Direction)((Object)p_73410_.m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
        BlockPos blockpos1 = p_73409_.m_121945_(direction2);
        if (p_73408_.m_8055_(blockpos1).m_60804_(p_73408_, blockpos1)) {
            direction2 = direction2.m_122424_();
            blockpos1 = p_73409_.m_121945_(direction2);
        }
        if (p_73408_.m_8055_(blockpos1).m_60804_(p_73408_, blockpos1)) {
            direction2 = direction2.m_122427_();
            blockpos1 = p_73409_.m_121945_(direction2);
        }
        if (p_73408_.m_8055_(blockpos1).m_60804_(p_73408_, blockpos1)) {
            direction2 = direction2.m_122424_();
            blockpos1 = p_73409_.m_121945_(direction2);
        }
        return (BlockState)((Object)p_73410_.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Object)direction2)));
    }

    protected boolean m_226762_(ServerLevelAccessor p_226763_, BoundingBox p_226764_, RandomSource p_226765_, BlockPos p_226766_, ResourceLocation p_226767_, @Nullable BlockState p_226768_) {
        if (p_226764_.m_71051_((Vec3i)p_226766_) && !p_226763_.m_8055_(p_226766_).m_60713_(Blocks.f_50087_)) {
            if (p_226768_ == null) {
                p_226768_ = StructurePiece.m_73407_((BlockGetter)p_226763_, p_226766_, Blocks.f_50087_.m_49966_());
            }
            p_226763_.m_7731_(p_226766_, p_226768_, 2);
            BlockEntity blockentity = p_226763_.m_7702_(p_226766_);
            if (blockentity instanceof ChestBlockEntity) {
                ((ChestBlockEntity)((Object)blockentity)).m_59626_(p_226767_, p_226765_.m_188505_());
            }
            return true;
        }
        return false;
    }

    protected boolean m_226819_(WorldGenLevel p_226820_, BoundingBox p_226821_, RandomSource p_226822_, int p_226823_, int p_226824_, int p_226825_, Direction p_226826_, ResourceLocation p_226827_) {
        BlockPos.MutableBlockPos blockpos = this.m_163582_(p_226823_, p_226824_, p_226825_);
        if (p_226821_.m_71051_((Vec3i)blockpos) && !p_226820_.m_8055_((BlockPos)blockpos).m_60713_(Blocks.f_50061_)) {
            this.m_73434_(p_226820_, (BlockState)((Object)Blocks.f_50061_.m_49966_().m_61124_((Property)DispenserBlock.f_52659_, (Comparable)((Object)p_226826_))), p_226823_, p_226824_, p_226825_, p_226821_);
            BlockEntity blockentity = p_226820_.m_7702_((BlockPos)blockpos);
            if (blockentity instanceof DispenserBlockEntity) {
                ((DispenserBlockEntity)blockentity).m_59626_(p_226827_, p_226822_.m_188505_());
            }
            return true;
        }
        return false;
    }

    public void m_6324_(int p_73395_, int p_73396_, int p_73397_) {
        this.f_73383_.m_162367_(p_73395_, p_73396_, p_73397_);
    }

    public static BoundingBox m_192651_(Stream<StructurePiece> p_192652_) {
        return (BoundingBox)BoundingBox.m_162388_(p_192652_.map(StructurePiece::m_73547_)::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece m_192648_(List<StructurePiece> p_192649_, BoundingBox p_192650_) {
        for (StructurePiece structurepiece : p_192649_) {
            if (!structurepiece.m_73547_().m_71049_(p_192650_)) continue;
            return structurepiece;
        }
        return null;
    }

    @Nullable
    public Direction m_73549_() {
        return this.f_73377_;
    }

    public void m_73519_(@Nullable Direction p_73520_) {
        this.f_73377_ = p_73520_;
        if (p_73520_ == null) {
            this.f_73379_ = Rotation.NONE;
            this.f_73378_ = Mirror.NONE;
        } else {
            switch (p_73520_) {
                case SOUTH: {
                    this.f_73378_ = Mirror.LEFT_RIGHT;
                    this.f_73379_ = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.f_73378_ = Mirror.LEFT_RIGHT;
                    this.f_73379_ = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.f_73378_ = Mirror.NONE;
                    this.f_73379_ = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.f_73378_ = Mirror.NONE;
                    this.f_73379_ = Rotation.NONE;
                }
            }
        }
    }

    public Rotation m_6830_() {
        return this.f_73379_;
    }

    public Mirror m_163587_() {
        return this.f_73378_;
    }

    public StructurePieceType m_210000_() {
        return this.f_73380_;
    }

    public static abstract class BlockSelector {
        protected BlockState f_73553_ = Blocks.f_50016_.m_49966_();

        public abstract void m_213766_(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public BlockState m_73555_() {
            return this.f_73553_;
        }
    }
}

