/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.AlterGroundEvent;

public class AlterGroundDecorator
extends TreeDecorator {
    public static final Codec<AlterGroundDecorator> f_69302_ = BlockStateProvider.f_68747_.fieldOf("provider").xmap(AlterGroundDecorator::new, p_69327_ -> p_69327_.f_69303_).codec();
    private final BlockStateProvider f_69303_;

    public AlterGroundDecorator(BlockStateProvider p_69306_) {
        this.f_69303_ = p_69306_;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return TreeDecoratorType.f_70046_;
    }

    public void m_214187_(TreeDecorator.Context p_225969_) {
        ArrayList list = Lists.newArrayList();
        ObjectArrayList list1 = p_225969_.m_226070_();
        ObjectArrayList list2 = p_225969_.m_226068_();
        if (list1.isEmpty()) {
            list.addAll(list2);
        } else if (!list2.isEmpty() && ((BlockPos)list1.get(0)).m_123342_() == ((BlockPos)list2.get(0)).m_123342_()) {
            list.addAll(list2);
            list.addAll(list1);
        } else {
            list.addAll(list1);
        }
        if (!list.isEmpty()) {
            AlterGroundEvent.StateProvider eventProvider = ForgeEventFactory.alterGround((TreeDecorator.Context)p_225969_, (List)list, (arg_0, arg_1) -> ((BlockStateProvider)this.f_69303_).m_213972_(arg_0, arg_1));
            int i = ((BlockPos)list.get(0)).m_123342_();
            list.stream().filter(p_69310_ -> p_69310_.m_123342_() == i).forEach(p_225978_ -> {
                this.placeCircle(p_225969_, p_225978_.m_122024_().m_122012_(), eventProvider);
                this.placeCircle(p_225969_, p_225978_.m_122030_(2).m_122012_(), eventProvider);
                this.placeCircle(p_225969_, p_225978_.m_122024_().m_122020_(2), eventProvider);
                this.placeCircle(p_225969_, p_225978_.m_122030_(2).m_122020_(2), eventProvider);
                for (int j = 0; j < 5; ++j) {
                    int k = p_225969_.m_226067_().m_188503_(64);
                    int l = k % 8;
                    int i1 = k / 8;
                    if (l != 0 && l != 7 && i1 != 0 && i1 != 7) continue;
                    this.placeCircle(p_225969_, p_225978_.m_7918_(-3 + l, 0, -3 + i1), eventProvider);
                }
            });
        }
    }

    private void m_225970_(TreeDecorator.Context p_225971_, BlockPos p_225972_) {
        this.placeCircle(p_225971_, p_225972_, (arg_0, arg_1) -> ((BlockStateProvider)this.f_69303_).m_213972_(arg_0, arg_1));
    }

    private void placeCircle(TreeDecorator.Context pContext, BlockPos pPos, AlterGroundEvent.StateProvider eventProvider) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placeBlockAt(pContext, pPos.m_7918_(i, 0, j), eventProvider);
            }
        }
    }

    private void m_225973_(TreeDecorator.Context p_225974_, BlockPos p_225975_) {
        this.placeCircle(p_225974_, p_225975_, (arg_0, arg_1) -> ((BlockStateProvider)this.f_69303_).m_213972_(arg_0, arg_1));
    }

    private void placeBlockAt(TreeDecorator.Context pContext, BlockPos pPos, AlterGroundEvent.StateProvider eventProvider) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pPos.m_6630_(i);
            if (Feature.m_65788_(pContext.m_226058_(), blockpos)) {
                pContext.m_226061_(blockpos, eventProvider.getState(pContext.m_226067_(), pPos));
                break;
            }
            if (!pContext.m_226059_(blockpos) && i < 0) break;
        }
    }
}

