/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class ModLoadingContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadLocal<ModLoadingContext> context = ThreadLocal.withInitial(ModLoadingContext::new);
    private Object languageExtension;
    private ModLoadingStage stage;
    private ModContainer activeContainer;

    public static ModLoadingContext get() {
        return context.get();
    }

    public void setActiveContainer(ModContainer container) {
        this.activeContainer = container;
        this.languageExtension = container == null ? null : container.contextExtension.get();
    }

    public ModContainer getActiveContainer() {
        return this.activeContainer == null ? ModList.get().getModContainerById("minecraft").orElseThrow(() -> new RuntimeException("Where is minecraft???!")) : this.activeContainer;
    }

    public String getActiveNamespace() {
        return this.activeContainer == null ? "minecraft" : this.activeContainer.getNamespace();
    }

    public <T extends Record> void registerExtensionPoint(Class<? extends IExtensionPoint<T>> point, Supplier<T> extension) {
        this.getActiveContainer().registerExtensionPoint(point, extension);
    }

    public void registerConfig(ModConfig.Type type, IConfigSpec<?> spec) {
        if (spec.isEmpty()) {
            LOGGER.debug("Attempted to register an empty config for type {} on mod {}", (Object)type, (Object)this.getActiveContainer().getModId());
            return;
        }
        this.getActiveContainer().addConfig(new ModConfig(type, spec, this.getActiveContainer()));
    }

    public void registerConfig(ModConfig.Type type, IConfigSpec<?> spec, String fileName) {
        if (spec.isEmpty()) {
            LOGGER.debug("Attempted to register an empty config for type {} on mod {} using file name {}", new Object[]{type, this.getActiveContainer().getModId(), fileName});
            return;
        }
        this.getActiveContainer().addConfig(new ModConfig(type, spec, this.getActiveContainer(), fileName));
    }

    public <T> T extension() {
        return (T)this.languageExtension;
    }
}

